/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.criteria.placement;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.coursett.criteria.placement.PlacementSelectionCriterion;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.ifs.extension.ConflictStatistics;
import net.sf.cpsolver.ifs.extension.Extension;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solution.SolutionListener;
import net.sf.cpsolver.ifs.solver.Solver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedHardConflicts
extends PlacementSelectionCriterion
implements SolutionListener<Lecture, Placement> {
    protected ConflictStatistics<Lecture, Placement> iStat = null;
    protected long iIteration = 0L;

    @Override
    public boolean init(Solver<Lecture, Placement> solver) {
        super.init(solver);
        for (Extension<Lecture, Placement> extension : solver.getExtensions()) {
            if (!ConflictStatistics.class.isInstance(extension)) continue;
            this.iStat = (ConflictStatistics)extension;
        }
        solver.currentSolution().addSolutionListener(this);
        return true;
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.NrConflictsWeight";
    }

    @Override
    public double getValue(Placement value, Set<Placement> conflicts) {
        return this.iStat == null || conflicts == null ? 0.0 : this.iStat.countRemovals(this.iIteration, (Placement)((Object)conflicts), value);
    }

    @Override
    public double getPlacementSelectionWeightDefault(int level) {
        return level == 0 ? 3.0 : 0.0;
    }

    @Override
    public void solutionUpdated(Solution<Lecture, Placement> solution) {
        this.iIteration = solution.getIteration();
    }

    @Override
    public void getInfo(Solution<Lecture, Placement> solution, Map<String, String> info) {
    }

    @Override
    public void getInfo(Solution<Lecture, Placement> solution, Map<String, String> info, Collection<Lecture> variables) {
    }

    @Override
    public void bestCleared(Solution<Lecture, Placement> solution) {
        this.iIteration = solution.getIteration();
    }

    @Override
    public void bestSaved(Solution<Lecture, Placement> solution) {
        this.iIteration = solution.getIteration();
    }

    @Override
    public void bestRestored(Solution<Lecture, Placement> solution) {
        this.iIteration = solution.getIteration();
    }
}

