/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.criteria.placement;

import java.util.Set;
import net.sf.cpsolver.coursett.criteria.placement.PlacementSelectionCriterion;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.ifs.solver.Solver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeltaTimePreference
extends PlacementSelectionCriterion {
    private double iLevel1DefaultWeight = 0.0;

    @Override
    public boolean init(Solver<Lecture, Placement> solver) {
        this.iLevel1DefaultWeight = solver.getProperties().getPropertyDouble("Comparator.TimePreferenceWeight", 1.0) / 2.0;
        return super.init(solver);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.DeltaTimePreferenceWeight";
    }

    @Override
    public double getValue(Placement value, Set<Placement> conflicts) {
        double ret = ((Lecture)value.variable()).getWeight() * (value.getTimeLocation().getNormalizedPreference() - ((Lecture)value.variable()).getBestTimePreference());
        if (conflicts != null) {
            for (Placement placement : conflicts) {
                double timePref = placement.getTimeLocation().getNormalizedPreference();
                ret -= ((Lecture)placement.variable()).getWeight() * (timePref - ((Lecture)placement.variable()).getBestTimePreference());
            }
        }
        return ret;
    }

    @Override
    public double getPlacementSelectionWeightDefault(int level) {
        return level == 0 ? this.iLevel1DefaultWeight : 0.0;
    }
}

