/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.criteria.additional;

import java.util.Collection;
import java.util.Map;
import net.sf.cpsolver.coursett.criteria.StudentConflict;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.TimeLocation;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentLuchBreak
extends StudentConflict {
    private int iLunchStart;
    private int iLunchEnd;
    private int iLunchLength;

    @Override
    public boolean init(Solver<Lecture, Placement> solver) {
        this.iLunchStart = solver.getProperties().getPropertyInt("StudentLunch.StartSlot", 132);
        this.iLunchEnd = solver.getProperties().getPropertyInt("StudentLunch.EndStart", 162);
        this.iLunchLength = solver.getProperties().getPropertyInt("StudentLunch.Length", 6);
        return super.init(solver);
    }

    @Override
    public boolean isApplicable(Lecture l1, Lecture l2) {
        return StudentLuchBreak.applicable(l1, l2);
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.StudentLunchWeight", config.getPropertyDouble("Comparator.StudentConflictWeight", 1.0));
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.StudentLunchWeight";
    }

    public boolean nolunch(Placement p1, Placement p2) {
        TimeLocation t2;
        if (p1 == null || p2 == null || StudentLuchBreak.overlaps(p1, p2)) {
            return false;
        }
        if (((Lecture)p1.variable()).isCommitted() && ((Lecture)p2.variable()).isCommitted()) {
            return false;
        }
        TimeLocation t1 = p1.getTimeLocation();
        if (!t1.shareDays(t2 = p2.getTimeLocation()) || !t1.shareWeeks(t2)) {
            return false;
        }
        int s1 = t1.getStartSlot();
        int s2 = t2.getStartSlot();
        int e1 = t1.getStartSlot() + t1.getNrSlotsPerMeeting();
        int e2 = t2.getStartSlot() + t2.getNrSlotsPerMeeting();
        return e1 + this.iLunchLength > s2 && e2 + this.iLunchLength > s1 && e1 > this.iLunchStart && this.iLunchEnd > s1 && e2 > this.iLunchStart && this.iLunchEnd > s2;
    }

    @Override
    public boolean inConflict(Placement p1, Placement p2) {
        return this.nolunch(p1, p2);
    }

    @Override
    public void getInfo(Map<String, String> info) {
        super.getInfo(info);
        double conf = this.getValue();
        if (conf > 0.0) {
            info.put("Student lunch conflicts", String.valueOf(Math.round(conf)));
        }
    }

    @Override
    public void getInfo(Map<String, String> info, Collection<Lecture> variables) {
        super.getInfo(info, variables);
        double conf = this.getValue(variables);
        if (conf > 0.0) {
            info.put("Student lunch conflicts", String.valueOf(Math.round(conf)));
        }
    }
}

