/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.criteria.additional;

import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.cpsolver.coursett.Constants;
import net.sf.cpsolver.coursett.constraint.InstructorConstraint;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.TimetableModel;
import net.sf.cpsolver.ifs.criteria.AbstractCriterion;
import net.sf.cpsolver.ifs.solver.Solver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructorLunchBreak
extends AbstractCriterion<Lecture, Placement> {
    private double iMultiplier;
    private int iLunchStart;
    private int iLunchEnd;
    private int iLunchLength;
    private boolean iFullInfo;
    private List<BitSet> iWeeks = null;
    private Map<InstructorConstraint, CompactInfo> iCompactInfos = new HashMap<InstructorConstraint, CompactInfo>();

    public InstructorLunchBreak() {
        this.iValueUpdateType = AbstractCriterion.ValueUpdateType.NoUpdate;
    }

    @Override
    public boolean init(Solver<Lecture, Placement> solver) {
        super.init(solver);
        this.iWeight = solver.getProperties().getPropertyDouble("InstructorLunch.Weight", 0.3);
        this.iLunchStart = solver.getProperties().getPropertyInt("InstructorLunch.StartSlot", 132);
        this.iLunchEnd = solver.getProperties().getPropertyInt("InstructorLunch.EndSlot", 162);
        this.iLunchLength = solver.getProperties().getPropertyInt("InstructorLunch.Length", 6);
        this.iMultiplier = solver.getProperties().getPropertyDouble("InstructorLunch.Multiplier", 1.2);
        this.iFullInfo = solver.getProperties().getPropertyBoolean("InstructorLunch.InfoShowViolations", false);
        return true;
    }

    protected CompactInfo getCompactInfo(InstructorConstraint constraint) {
        CompactInfo info = this.iCompactInfos.get(constraint);
        if (info == null) {
            info = new CompactInfo();
            this.iCompactInfos.put(constraint, info);
        }
        return info;
    }

    @Override
    public void afterAssigned(long iteration, Placement value) {
        super.afterAssigned(iteration, value);
        for (InstructorConstraint constraint : ((Lecture)value.variable()).getInstructorConstraints()) {
            this.updateCriterion(constraint, value);
        }
    }

    @Override
    public void afterUnassigned(long iteration, Placement value) {
        super.afterUnassigned(iteration, value);
        for (InstructorConstraint constraint : ((Lecture)value.variable()).getInstructorConstraints()) {
            this.updateCriterion(constraint, value);
        }
    }

    protected List<BitSet> getWeeks() {
        if (this.iWeeks == null) {
            TimetableModel model = (TimetableModel)this.getModel();
            this.iWeeks = model.getWeeks();
        }
        return this.iWeeks;
    }

    public void updateLunchPenalty(InstructorConstraint constraint, Placement p) {
        if (p.getTimeLocation().getStartSlot() <= this.iLunchEnd && p.getTimeLocation().getStartSlot() + p.getTimeLocation().getLength() > this.iLunchStart) {
            CompactInfo compactInfo = this.getCompactInfo(constraint);
            for (int i = 0; i < Constants.NR_DAYS; ++i) {
                if ((p.getTimeLocation().getDayCode() & Constants.DAY_CODES[i]) == 0) continue;
                int currentLunchStartSlot = 288 * i + this.iLunchStart;
                int currentLunchEndSlot = 288 * i + this.iLunchEnd;
                int semesterViolations = 0;
                for (BitSet week : this.getWeeks()) {
                    int maxBreak = 0;
                    int currentBreak = 0;
                    for (int slot = currentLunchStartSlot; slot < currentLunchEndSlot; ++slot) {
                        if (constraint.getPlacements(slot, week).isEmpty()) {
                            if (maxBreak >= ++currentBreak) continue;
                            maxBreak = currentBreak;
                            continue;
                        }
                        currentBreak = 0;
                    }
                    if (maxBreak >= this.iLunchLength) continue;
                    ++semesterViolations;
                }
                compactInfo.getLunchDayViolations()[i] = semesterViolations;
            }
        }
    }

    public void updateCriterion(InstructorConstraint instructorConstraint, Placement placement) {
        this.iValue -= this.getLunchPreference(instructorConstraint);
        this.updateLunchPenalty(instructorConstraint, placement);
        this.iValue += this.getLunchPreference(instructorConstraint);
    }

    private double getLunchPreference(InstructorConstraint instructorConstraint) {
        double violations = 0.0;
        CompactInfo info = this.getCompactInfo(instructorConstraint);
        for (int i = 0; i < Constants.NR_DAYS; ++i) {
            violations += (double)info.getLunchDayViolations()[i];
        }
        return Math.pow(violations, this.iMultiplier);
    }

    @Override
    public double getValue(Placement value, Set<Placement> conflicts) {
        return this.iValue;
    }

    @Override
    public double getWeightedValue(Placement value, Set<Placement> conflicts) {
        return this.iValue * this.iWeight;
    }

    @Override
    public double getValue(Collection<Lecture> variables) {
        double lunchValue = 0.0;
        HashSet<InstructorConstraint> constraints = new HashSet<InstructorConstraint>();
        for (Lecture lecture : variables) {
            constraints.addAll(lecture.getInstructorConstraints());
        }
        for (InstructorConstraint instructor : constraints) {
            lunchValue += this.getLunchPreference(instructor);
        }
        return lunchValue;
    }

    @Override
    public void getInfo(Map<String, String> info) {
        TreeSet<String> violatedLunchBreaks = new TreeSet<String>();
        int lunchViolations = 0;
        for (InstructorConstraint c : ((TimetableModel)this.getModel()).getInstructorConstraints()) {
            String days = "";
            CompactInfo compactInfo = this.getCompactInfo(c);
            for (int i = 0; i < Constants.NR_DAYS; ++i) {
                if (compactInfo.getLunchDayViolations()[i] <= 0) continue;
                if (this.iFullInfo) {
                    days = days + (days.isEmpty() ? "" : ", ") + compactInfo.getLunchDayViolations()[i] + " &times; " + Constants.DAY_NAMES_SHORT[i];
                }
                lunchViolations += compactInfo.getLunchDayViolations()[i];
            }
            if (!this.iFullInfo || days.isEmpty()) continue;
            violatedLunchBreaks.add(c.getName() + ": " + days);
        }
        if (lunchViolations > 0) {
            info.put("Lunch breaks", this.getPerc(lunchViolations, 0.0, ((TimetableModel)this.getModel()).getInstructorConstraints().size() * Constants.NR_DAYS * this.getWeeks().size()) + "% (" + lunchViolations + ")");
            if (this.iFullInfo && !violatedLunchBreaks.isEmpty()) {
                String message = "";
                for (String s : violatedLunchBreaks) {
                    message = message + (message.isEmpty() ? "" : "<br>") + s;
                }
                info.put("Lunch break violations", message);
            }
        }
    }

    @Override
    public void getInfo(Map<String, String> info, Collection<Lecture> variables) {
        HashSet<InstructorConstraint> constraints = new HashSet<InstructorConstraint>();
        for (Lecture lecture : variables) {
            for (InstructorConstraint c : lecture.getInstructorConstraints()) {
                constraints.add(c);
            }
        }
        TreeSet<String> violatedLunchBreaks = new TreeSet<String>();
        int lunchViolations = 0;
        for (InstructorConstraint c : constraints) {
            String days = "";
            CompactInfo compactInfo = this.getCompactInfo(c);
            for (int i = 0; i < Constants.NR_DAYS; ++i) {
                if (compactInfo.getLunchDayViolations()[i] <= 0) continue;
                if (this.iFullInfo) {
                    days = days + (days.isEmpty() ? "" : ", ") + compactInfo.getLunchDayViolations()[i] + " &times; " + Constants.DAY_NAMES_SHORT[i];
                }
                lunchViolations += compactInfo.getLunchDayViolations()[i];
            }
            if (!this.iFullInfo || days.isEmpty()) continue;
            violatedLunchBreaks.add(c.getName() + ": " + days);
        }
        if (lunchViolations > 0) {
            info.put("Lunch breaks", this.getPerc(lunchViolations, 0.0, constraints.size() * Constants.NR_DAYS * this.getWeeks().size()) + "% (" + lunchViolations + ")");
            if (this.iFullInfo && !violatedLunchBreaks.isEmpty()) {
                String message = "";
                for (String s : violatedLunchBreaks) {
                    message = message + (message.isEmpty() ? "" : "; ") + s;
                }
                info.put("Lunch break violations", message);
            }
        }
    }

    public static class CompactInfo {
        private int[] iLunchDayViolations = new int[Constants.NR_DAYS];

        public int[] getLunchDayViolations() {
            return this.iLunchDayViolations;
        }
    }
}

