/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.criteria.additional;

import java.util.Collection;
import java.util.Map;
import net.sf.cpsolver.coursett.criteria.StudentConflict;
import net.sf.cpsolver.coursett.criteria.additional.IgnoredCommittedStudentConflict;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.ifs.criteria.Criterion;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoredStudentConflict
extends StudentConflict {
    @Override
    public boolean inConflict(Placement p1, Placement p2) {
        return IgnoredStudentConflict.ignore(p1, p2) && (IgnoredStudentConflict.overlaps(p1, p2) || IgnoredStudentConflict.distance(this.getMetrics(), p1, p2));
    }

    @Override
    public boolean isApplicable(Lecture l1, Lecture l2) {
        return IgnoredStudentConflict.ignore(l1, l2) && IgnoredStudentConflict.applicable(l1, l2);
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.IgnoredStudentConflictWeight", 0.0);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.NrIgnoredStudConfsWeight";
    }

    @Override
    public void getInfo(Map<String, String> info) {
        super.getInfo(info);
        double conf = this.getValue();
        if (conf > 0.0) {
            Criterion c = this.getModel().getCriterion(IgnoredCommittedStudentConflict.class);
            double committed = c == null ? 0.0 : c.getValue();
            info.put("Ignored student conflicts", sDoubleFormat.format(conf) + (committed > 0.0 ? " [committed: " + sDoubleFormat.format(committed) + "]" : ""));
        }
    }

    @Override
    public void getInfo(Map<String, String> info, Collection<Lecture> variables) {
        super.getInfo(info, variables);
        double conf = this.getValue(variables);
        if (conf > 0.0) {
            Criterion c = this.getModel().getCriterion(IgnoredCommittedStudentConflict.class);
            double committed = c == null ? 0.0 : c.getValue(variables);
            info.put("Ignored student conflicts", sDoubleFormat.format(conf) + (committed > 0.0 ? " [committed: " + sDoubleFormat.format(committed) + "]" : ""));
        }
    }
}

