/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.criteria.additional;

import java.util.Collection;
import java.util.Set;
import net.sf.cpsolver.coursett.criteria.StudentConflict;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.Student;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoredCommittedStudentConflict
extends StudentConflict {
    @Override
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.IgnoredCommitedStudentConflictWeight", 0.0);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.NrIgnoredCommitedStudConfsWeight";
    }

    @Override
    public boolean isApplicable(Lecture l1, Lecture l2) {
        return IgnoredCommittedStudentConflict.ignore(l1, l2) && IgnoredCommittedStudentConflict.committed(l1, l2);
    }

    @Override
    public boolean inConflict(Placement p1, Placement p2) {
        return IgnoredCommittedStudentConflict.ignore(p1, p2) && IgnoredCommittedStudentConflict.committed(p1, p2) && super.inConflict(p1, p2);
    }

    public int countCommittedConflicts(Student student, Placement placement) {
        if (student.getCommitedPlacements() == null) {
            return 0;
        }
        int conflicts = 0;
        Lecture lecture = (Lecture)placement.variable();
        for (Placement commitedPlacement : student.getCommitedPlacements()) {
            Lecture commitedLecture = (Lecture)commitedPlacement.variable();
            if (lecture.getSchedulingSubpartId() != null && lecture.getSchedulingSubpartId().equals(commitedLecture.getSchedulingSubpartId()) || !IgnoredCommittedStudentConflict.ignore(placement, commitedPlacement) || !IgnoredCommittedStudentConflict.overlaps(placement, commitedPlacement) && !IgnoredCommittedStudentConflict.distance(this.getMetrics(), placement, commitedPlacement)) continue;
            ++conflicts;
        }
        if (conflicts == 0) {
            return 0;
        }
        double w = student.getOfferingWeight(((Lecture)placement.variable()).getConfiguration());
        return (int)Math.round(student.avg(w, 1.0) * (double)conflicts);
    }

    public double countCommittedConflicts(Placement placement) {
        double ret = 0.0;
        Lecture lecture = (Lecture)placement.variable();
        for (Student student : lecture.students()) {
            ret += (double)this.countCommittedConflicts(student, placement);
        }
        return ret;
    }

    @Override
    public double[] getBounds(Collection<Lecture> variables) {
        double[] bounds = super.getBounds(variables);
        for (Lecture lecture : variables) {
            Double max = null;
            for (Placement placement : lecture.values()) {
                if (max == null) {
                    max = new Double(this.countCommittedConflicts(placement));
                    continue;
                }
                max = Math.max(max, this.countCommittedConflicts(placement));
            }
            if (max == null) continue;
            bounds[0] = bounds[0] + max;
        }
        return bounds;
    }

    @Override
    public double getValue(Placement value, Set<Placement> conflicts) {
        double ret = super.getValue(value, conflicts);
        ret += this.countCommittedConflicts(value);
        if (this.iIncludeConflicts && conflicts != null) {
            for (Placement conflict : conflicts) {
                ret -= this.countCommittedConflicts(conflict);
            }
        }
        return ret;
    }

    @Override
    public double getValue(Collection<Lecture> variables) {
        double ret = super.getValue(variables);
        for (Lecture lect : variables) {
            if (lect.getAssignment() == null) continue;
            ret += this.countCommittedConflicts((Placement)lect.getAssignment());
        }
        return Math.round(ret);
    }
}

