/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.Set;
import net.sf.cpsolver.coursett.criteria.StudentConflict;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentCommittedConflict
extends StudentConflict {
    @Override
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.CommitedStudentConflictWeight", 1.0);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.NrCommitedStudConfsWeight";
    }

    @Override
    public boolean isApplicable(Lecture l1, Lecture l2) {
        return !StudentCommittedConflict.ignore(l1, l2) && StudentCommittedConflict.committed(l1, l2);
    }

    @Override
    public boolean inConflict(Placement p1, Placement p2) {
        return !StudentCommittedConflict.ignore(p1, p2) && StudentCommittedConflict.committed(p1, p2) && super.inConflict(p1, p2);
    }

    @Override
    public double[] getBounds(Collection<Lecture> variables) {
        double[] bounds = super.getBounds(variables);
        for (Lecture lecture : variables) {
            Double max = null;
            for (Placement placement : lecture.values()) {
                if (max == null) {
                    max = new Double(lecture.getCommitedConflicts(placement));
                    continue;
                }
                max = Math.max(max, (double)lecture.getCommitedConflicts(placement));
            }
            if (max == null) continue;
            bounds[0] = bounds[0] + max;
        }
        return bounds;
    }

    @Override
    public double getValue(Placement value, Set<Placement> conflicts) {
        double ret = super.getValue(value, conflicts);
        ret += (double)((Lecture)value.variable()).getCommitedConflicts(value);
        if (this.iIncludeConflicts && conflicts != null) {
            for (Placement conflict : conflicts) {
                ret -= (double)((Lecture)value.variable()).getCommitedConflicts(conflict);
            }
        }
        return ret;
    }

    @Override
    public double getValue(Collection<Lecture> variables) {
        double ret = super.getValue(variables);
        for (Lecture lect : variables) {
            if (lect.getAssignment() == null) continue;
            ret += (double)lect.getCommitedConflicts((Placement)lect.getAssignment());
        }
        return Math.round(ret);
    }
}

