/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.Set;
import net.sf.cpsolver.coursett.criteria.TimetablingCriterion;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.ifs.criteria.AbstractCriterion;
import net.sf.cpsolver.ifs.perturbations.PerturbationsCounter;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Perturbations
extends TimetablingCriterion {
    private PerturbationsCounter<Lecture, Placement> iPerturbationsCounter = null;

    public Perturbations() {
        this.iValueUpdateType = AbstractCriterion.ValueUpdateType.NoUpdate;
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.MPP_DeltaInitialAssignmentWeight";
    }

    @Override
    public boolean init(Solver<Lecture, Placement> solver) {
        this.iPerturbationsCounter = solver.getPerturbationsCounter();
        return super.init(solver);
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.PerturbationPenaltyWeight", 1.0);
    }

    public PerturbationsCounter<Lecture, Placement> getPerturbationsCounter() {
        return this.iPerturbationsCounter;
    }

    @Override
    public double getValue(Placement value, Set<Placement> conflicts) {
        return this.getPerturbationsCounter().getPerturbationPenalty(this.getModel(), value, conflicts);
    }

    @Override
    public double getValue() {
        return this.getPerturbationsCounter().getPerturbationPenalty(this.getModel());
    }

    @Override
    public double getValue(Collection<Lecture> variables) {
        return this.getPerturbationsCounter().getPerturbationPenalty(this.getModel(), variables);
    }

    @Override
    public double[] getBounds() {
        return new double[]{0.0, 0.0};
    }

    @Override
    public double[] getBounds(Collection<Lecture> variables) {
        return new double[]{0.0, 0.0};
    }
}

