/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.sf.cpsolver.coursett.constraint.DepartmentSpreadConstraint;
import net.sf.cpsolver.coursett.criteria.SameSubpartBalancingPenalty;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DepartmentBalancingPenalty
extends SameSubpartBalancingPenalty {
    @Override
    public double getWeightDefault(DataProperties config) {
        return 12.0 * config.getPropertyDouble("Comparator.DeptSpreadPenaltyWeight", 1.0);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.DeptSpreadPenaltyWeight";
    }

    @Override
    public double getValue(Placement value, Set<Placement> conflicts) {
        return (((Lecture)value.variable()).getDeptSpreadConstraint() == null ? 0.0 : (double)((Lecture)value.variable()).getDeptSpreadConstraint().getPenalty(value)) / 12.0;
    }

    @Override
    public double getValue(Collection<Lecture> variables) {
        double ret = 0.0;
        HashSet<DepartmentSpreadConstraint> constraints = new HashSet<DepartmentSpreadConstraint>();
        for (Lecture lect : variables) {
            if (lect.getDeptSpreadConstraint() == null || !constraints.add(lect.getDeptSpreadConstraint())) continue;
            ret += (double)lect.getDeptSpreadConstraint().getPenalty();
        }
        return ret / 12.0;
    }
}

