/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.coursett.Constants;
import net.sf.cpsolver.coursett.constraint.GroupConstraint;
import net.sf.cpsolver.coursett.criteria.SameSubpartBalancingPenalty;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.TimeLocation;
import net.sf.cpsolver.ifs.criteria.Criterion;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.model.WeakeningConstraint;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpreadConstraint
extends Constraint<Lecture, Placement>
implements WeakeningConstraint<Lecture, Placement> {
    private int[][] iMaxCourses = null;
    private int iCurrentPenalty = 0;
    private int iMaxAllowedPenalty = 0;
    private boolean iInitialized = false;
    private int[][] iNrCourses = null;
    private List<Placement>[][] iCourses = null;
    private double iSpreadFactor = 1.2;
    private int iUnassignmentsToWeaken = 250;
    private long iUnassignment = 0L;
    private String iName = null;
    public static boolean USE_MOST_IMPROVEMENT_ADEPTS = false;

    public SpreadConstraint(String name, double spreadFactor, int unassignmentsToWeaken, boolean interactiveMode) {
        this.iName = name;
        this.iSpreadFactor = spreadFactor;
        this.iUnassignmentsToWeaken = unassignmentsToWeaken;
        this.iNrCourses = new int[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.NR_DAYS_WEEK];
        this.iCourses = new List[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.NR_DAYS_WEEK];
        if (interactiveMode) {
            this.iUnassignmentsToWeaken = 0;
        }
        for (int i = 0; i < this.iNrCourses.length; ++i) {
            for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                this.iNrCourses[i][j] = 0;
                this.iCourses[i][j] = new ArrayList<Placement>(10);
            }
        }
    }

    public SpreadConstraint(DataProperties config, String name) {
        this(name, config.getPropertyDouble("Spread.SpreadFactor", 1.2), config.getPropertyInt("Spread.Unassignments2Weaken", 250), config.getPropertyBoolean("General.InteractiveMode", false));
    }

    protected Criterion<Lecture, Placement> getCriterion() {
        return this.getModel().getCriterion(SameSubpartBalancingPenalty.class);
    }

    public void init() {
        int i;
        int endSlot;
        int firstSlot;
        if (this.iInitialized) {
            return;
        }
        double[][] histogramPerDay = new double[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.NR_DAYS_WEEK];
        this.iMaxCourses = new int[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.NR_DAYS_WEEK];
        for (int i2 = 0; i2 < Constants.SLOTS_PER_DAY_NO_EVENINGS; ++i2) {
            for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                histogramPerDay[i2][j] = 0.0;
            }
        }
        int totalUsedSlots = 0;
        for (Lecture lecture : this.variables()) {
            Placement firstPlacement;
            Placement placement = firstPlacement = lecture.values().isEmpty() ? null : lecture.values().get(0);
            if (firstPlacement != null) {
                totalUsedSlots += firstPlacement.getTimeLocation().getNrSlotsPerMeeting() * firstPlacement.getTimeLocation().getNrMeetings();
            }
            for (Placement p : lecture.values()) {
                firstSlot = p.getTimeLocation().getStartSlot();
                if (firstSlot > Constants.DAY_SLOTS_LAST || (endSlot = firstSlot + p.getTimeLocation().getNrSlotsPerMeeting() - 1) < Constants.DAY_SLOTS_FIRST) continue;
                for (i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
                    int dayCode = p.getTimeLocation().getDayCode();
                    for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                        if ((dayCode & Constants.DAY_CODES[j]) == 0) continue;
                        double[] dArray = histogramPerDay[i - Constants.DAY_SLOTS_FIRST];
                        int n = j;
                        dArray[n] = dArray[n] + 1.0 / (double)lecture.values().size();
                    }
                }
            }
        }
        double threshold = this.iSpreadFactor * ((double)totalUsedSlots / (double)(Constants.NR_DAYS_WEEK * Constants.SLOTS_PER_DAY_NO_EVENINGS));
        for (int i3 = 0; i3 < Constants.SLOTS_PER_DAY_NO_EVENINGS; ++i3) {
            for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                this.iMaxCourses[i3][j] = (int)(0.999 + (histogramPerDay[i3][j] <= threshold ? this.iSpreadFactor * histogramPerDay[i3][j] : histogramPerDay[i3][j]));
            }
        }
        for (Lecture lecture : this.variables()) {
            Placement placement = (Placement)lecture.getAssignment();
            if (placement == null || (firstSlot = placement.getTimeLocation().getStartSlot()) > Constants.DAY_SLOTS_LAST || (endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1) < Constants.DAY_SLOTS_FIRST) continue;
            for (i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
                for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                    int dayCode = Constants.DAY_CODES[j];
                    if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
                    int[] nArray = this.iNrCourses[i - Constants.DAY_SLOTS_FIRST];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                    this.iCourses[i - Constants.DAY_SLOTS_FIRST][j].add(placement);
                }
            }
        }
        this.iCurrentPenalty = 0;
        for (int i4 = 0; i4 < Constants.SLOTS_PER_DAY_NO_EVENINGS; ++i4) {
            for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                this.iCurrentPenalty += Math.max(0, this.iNrCourses[i4][j] - this.iMaxCourses[i4][j]);
            }
        }
        this.iMaxAllowedPenalty = this.iCurrentPenalty;
        this.getCriterion().inc(this.iCurrentPenalty);
        this.iInitialized = true;
    }

    public Placement getAdept(Placement placement, int[][] nrCourses, Set<Placement> conflicts) {
        int imp;
        Placement plac;
        Placement adept = null;
        int improvement = 0;
        for (Lecture lect : this.variables()) {
            if (lect.isCommitted() || (plac = (Placement)lect.getAssignment()) == null || plac.equals(placement) || ((Lecture)placement.variable()).equals(plac.variable()) || conflicts.contains(plac) || (imp = this.getPenaltyIfUnassigned(plac, nrCourses)) == 0 || adept != null && imp <= improvement) continue;
            adept = plac;
            improvement = imp;
        }
        if (adept != null) {
            return adept;
        }
        for (Lecture lect : this.variables()) {
            if (!lect.isCommitted() || (plac = (Placement)lect.getAssignment()) == null || plac.equals(placement) || conflicts.contains(plac) || (imp = this.getPenaltyIfUnassigned(plac, nrCourses)) == 0 || adept != null && imp <= improvement) continue;
            adept = plac;
            improvement = imp;
        }
        return adept;
    }

    private Set<Placement>[] getAdepts(Placement placement, int[][] nrCourses, Set<Placement> conflicts) {
        int firstSlot = placement.getTimeLocation().getStartSlot();
        if (firstSlot > Constants.DAY_SLOTS_LAST) {
            return null;
        }
        int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
        if (endSlot < Constants.DAY_SLOTS_FIRST) {
            return null;
        }
        HashSet[] adepts = new HashSet[]{new HashSet(), new HashSet()};
        for (int i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
            for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                int dayCode = Constants.DAY_CODES[j];
                if ((dayCode & placement.getTimeLocation().getDayCode()) == 0 || nrCourses[i - Constants.DAY_SLOTS_FIRST][j] < this.iMaxCourses[i - Constants.DAY_SLOTS_FIRST][j]) continue;
                for (Placement p : this.iCourses[i - Constants.DAY_SLOTS_FIRST][j]) {
                    if (conflicts.contains(p) || p.equals(placement) || ((Lecture)p.variable()).equals(placement.variable())) continue;
                    adepts[((Lecture)p.variable()).isCommitted() ? 1 : 0].add(p);
                }
            }
        }
        return adepts;
    }

    private int getPenaltyIfUnassigned(Placement placement, int[][] nrCourses) {
        int firstSlot = placement.getTimeLocation().getStartSlot();
        if (firstSlot > Constants.DAY_SLOTS_LAST) {
            return 0;
        }
        int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
        if (endSlot < Constants.DAY_SLOTS_FIRST) {
            return 0;
        }
        int penalty = 0;
        for (int i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
            for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                int dayCode = Constants.DAY_CODES[j];
                if ((dayCode & placement.getTimeLocation().getDayCode()) == 0 || nrCourses[i - Constants.DAY_SLOTS_FIRST][j] <= this.iMaxCourses[i - Constants.DAY_SLOTS_FIRST][j]) continue;
                ++penalty;
            }
        }
        return penalty;
    }

    private int tryUnassign(Placement placement, int[][] nrCourses) {
        int firstSlot = placement.getTimeLocation().getStartSlot();
        if (firstSlot > Constants.DAY_SLOTS_LAST) {
            return 0;
        }
        int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
        if (endSlot < Constants.DAY_SLOTS_FIRST) {
            return 0;
        }
        int improvement = 0;
        for (int i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
            for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                int dayCode = Constants.DAY_CODES[j];
                if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
                if (nrCourses[i - Constants.DAY_SLOTS_FIRST][j] > this.iMaxCourses[i - Constants.DAY_SLOTS_FIRST][j]) {
                    ++improvement;
                }
                int[] nArray = nrCourses[i - Constants.DAY_SLOTS_FIRST];
                int n = j;
                nArray[n] = nArray[n] - 1;
            }
        }
        return improvement;
    }

    private int tryAssign(Placement placement, int[][] nrCourses) {
        int firstSlot = placement.getTimeLocation().getStartSlot();
        if (firstSlot > Constants.DAY_SLOTS_LAST) {
            return 0;
        }
        int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
        if (endSlot < Constants.DAY_SLOTS_FIRST) {
            return 0;
        }
        int penalty = 0;
        for (int i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
            for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                int dayCode = Constants.DAY_CODES[j];
                if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
                int[] nArray = nrCourses[i - Constants.DAY_SLOTS_FIRST];
                int n = j;
                nArray[n] = nArray[n] + 1;
                if (nrCourses[i - Constants.DAY_SLOTS_FIRST][j] <= this.iMaxCourses[i - Constants.DAY_SLOTS_FIRST][j]) continue;
                ++penalty;
            }
        }
        return penalty;
    }

    @Override
    public void computeConflicts(Placement placement, Set<Placement> conflicts) {
        block12: {
            int[][] nrCourses;
            int penalty;
            block11: {
                Placement plac;
                if (!this.iInitialized || this.iUnassignmentsToWeaken == 0) {
                    return;
                }
                penalty = this.iCurrentPenalty + this.getPenalty(placement);
                if (penalty <= this.iMaxAllowedPenalty) {
                    return;
                }
                int firstSlot = placement.getTimeLocation().getStartSlot();
                if (firstSlot > Constants.DAY_SLOTS_LAST) {
                    return;
                }
                int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
                if (endSlot < Constants.DAY_SLOTS_FIRST) {
                    return;
                }
                nrCourses = new int[this.iNrCourses.length][Constants.NR_DAYS_WEEK];
                for (int i = 0; i < this.iNrCourses.length; ++i) {
                    for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                        nrCourses[i][j] = this.iNrCourses[i][j];
                    }
                }
                this.tryAssign(placement, nrCourses);
                for (Lecture lect : this.variables()) {
                    if (conflicts.contains(lect)) {
                        penalty -= this.tryUnassign((Placement)lect.getAssignment(), nrCourses);
                    }
                    if (penalty > this.iMaxAllowedPenalty) continue;
                    return;
                }
                if (!USE_MOST_IMPROVEMENT_ADEPTS) break block11;
                while (penalty > this.iMaxAllowedPenalty && (plac = this.getAdept(placement, nrCourses, conflicts)) != null) {
                    conflicts.add(plac);
                    penalty -= this.tryUnassign(plac, nrCourses);
                }
                break block12;
            }
            if (penalty <= this.iMaxAllowedPenalty) break block12;
            Set<Placement>[] adepts = this.getAdepts(placement, nrCourses, conflicts);
            for (int i = 0; penalty > this.iMaxAllowedPenalty && i < adepts.length; ++i) {
                while (!adepts[i].isEmpty() && penalty > this.iMaxAllowedPenalty) {
                    Placement plac = ToolBox.random(adepts[i]);
                    adepts[i].remove(plac);
                    conflicts.add(plac);
                    penalty -= this.tryUnassign(plac, nrCourses);
                }
            }
        }
    }

    @Override
    public boolean inConflict(Placement placement) {
        if (!this.iInitialized || this.iUnassignmentsToWeaken == 0) {
            return false;
        }
        return this.getPenalty(placement) + this.iCurrentPenalty > this.iMaxAllowedPenalty;
    }

    @Override
    public boolean isConsistent(Placement p1, Placement p2) {
        if (!this.iInitialized || this.iUnassignmentsToWeaken == 0) {
            return true;
        }
        if (!p1.getTimeLocation().hasIntersection(p2.getTimeLocation())) {
            return true;
        }
        int firstSlot = Math.max(p1.getTimeLocation().getStartSlot(), p2.getTimeLocation().getStartSlot());
        if (firstSlot > Constants.DAY_SLOTS_LAST) {
            return true;
        }
        int endSlot = Math.min(p1.getTimeLocation().getStartSlot() + p1.getTimeLocation().getNrSlotsPerMeeting() - 1, p2.getTimeLocation().getStartSlot() + p2.getTimeLocation().getNrSlotsPerMeeting() - 1);
        if (endSlot < Constants.DAY_SLOTS_FIRST) {
            return true;
        }
        int penalty = 0;
        for (int i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
            for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                int dayCode = Constants.DAY_CODES[j];
                if ((dayCode & p1.getTimeLocation().getDayCode()) == 0 || (dayCode & p2.getTimeLocation().getDayCode()) == 0) continue;
                penalty += Math.max(0, 2 - this.iMaxCourses[i - Constants.DAY_SLOTS_FIRST][j]);
            }
        }
        return penalty < this.iMaxAllowedPenalty;
    }

    @Override
    public void weaken() {
        if (!this.iInitialized || this.iUnassignmentsToWeaken == 0) {
            return;
        }
        ++this.iUnassignment;
        if (this.iUnassignment % (long)this.iUnassignmentsToWeaken == 0L) {
            ++this.iMaxAllowedPenalty;
        }
    }

    @Override
    public void assigned(long iteration, Placement placement) {
        super.assigned(iteration, placement);
        if (!this.iInitialized) {
            return;
        }
        int firstSlot = placement.getTimeLocation().getStartSlot();
        if (firstSlot > Constants.DAY_SLOTS_LAST) {
            return;
        }
        int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
        if (endSlot < Constants.DAY_SLOTS_FIRST) {
            return;
        }
        this.getCriterion().inc(-this.iCurrentPenalty);
        for (int i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
            for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                int dayCode = Constants.DAY_CODES[j];
                if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
                int[] nArray = this.iNrCourses[i - Constants.DAY_SLOTS_FIRST];
                int n = j;
                nArray[n] = nArray[n] + 1;
                if (this.iNrCourses[i - Constants.DAY_SLOTS_FIRST][j] > this.iMaxCourses[i - Constants.DAY_SLOTS_FIRST][j]) {
                    ++this.iCurrentPenalty;
                }
                this.iCourses[i - Constants.DAY_SLOTS_FIRST][j].add(placement);
            }
        }
        this.getCriterion().inc(this.iCurrentPenalty);
    }

    @Override
    public void unassigned(long iteration, Placement placement) {
        super.unassigned(iteration, placement);
        if (!this.iInitialized) {
            return;
        }
        int firstSlot = placement.getTimeLocation().getStartSlot();
        if (firstSlot > Constants.DAY_SLOTS_LAST) {
            return;
        }
        int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
        if (endSlot < Constants.DAY_SLOTS_FIRST) {
            return;
        }
        this.getCriterion().inc(-this.iCurrentPenalty);
        for (int i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
            for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                int dayCode = Constants.DAY_CODES[j];
                if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
                if (this.iNrCourses[i - Constants.DAY_SLOTS_FIRST][j] > this.iMaxCourses[i - Constants.DAY_SLOTS_FIRST][j]) {
                    --this.iCurrentPenalty;
                }
                int[] nArray = this.iNrCourses[i - Constants.DAY_SLOTS_FIRST];
                int n = j;
                nArray[n] = nArray[n] - 1;
                this.iCourses[i - Constants.DAY_SLOTS_FIRST][j].remove(placement);
            }
        }
        this.getCriterion().inc(this.iCurrentPenalty);
    }

    @Override
    public String getName() {
        return this.iName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Time Spread between ");
        Iterator e = this.variables().iterator();
        while (e.hasNext()) {
            Lecture v = (Lecture)e.next();
            sb.append(v.getName());
            if (!e.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public int getPenalty() {
        if (!this.iInitialized) {
            return this.getPenaltyEstimate();
        }
        return this.iCurrentPenalty;
    }

    public int getPenaltyEstimate() {
        int j;
        double[][] histogramPerDay = new double[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.NR_DAYS_WEEK];
        int[][] maxCourses = new int[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.NR_DAYS_WEEK];
        int[][] nrCourses = new int[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.NR_DAYS_WEEK];
        for (int i = 0; i < Constants.SLOTS_PER_DAY_NO_EVENINGS; ++i) {
            for (int j2 = 0; j2 < Constants.NR_DAYS_WEEK; ++j2) {
                histogramPerDay[i][j2] = 0.0;
            }
        }
        int totalUsedSlots = 0;
        for (Lecture lecture : this.variables()) {
            Placement firstPlacement;
            Placement placement = firstPlacement = lecture.values().isEmpty() ? null : lecture.values().get(0);
            if (firstPlacement != null) {
                totalUsedSlots += firstPlacement.getTimeLocation().getNrSlotsPerMeeting() * firstPlacement.getTimeLocation().getNrMeetings();
            }
            for (Placement p : lecture.values()) {
                int endSlot;
                int firstSlot = p.getTimeLocation().getStartSlot();
                if (firstSlot > Constants.DAY_SLOTS_LAST || (endSlot = firstSlot + p.getTimeLocation().getNrSlotsPerMeeting() - 1) < Constants.DAY_SLOTS_FIRST) continue;
                for (int i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
                    int dayCode = p.getTimeLocation().getDayCode();
                    for (j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                        if ((dayCode & Constants.DAY_CODES[j]) == 0) continue;
                        double[] dArray = histogramPerDay[i - Constants.DAY_SLOTS_FIRST];
                        int n = j;
                        dArray[n] = dArray[n] + 1.0 / (double)lecture.values().size();
                    }
                }
            }
        }
        double threshold = this.iSpreadFactor * ((double)totalUsedSlots / (double)(Constants.NR_DAYS_WEEK * Constants.SLOTS_PER_DAY_NO_EVENINGS));
        for (int i = 0; i < Constants.SLOTS_PER_DAY_NO_EVENINGS; ++i) {
            for (int j3 = 0; j3 < Constants.NR_DAYS_WEEK; ++j3) {
                nrCourses[i][j3] = 0;
                maxCourses[i][j3] = (int)(0.999 + (histogramPerDay[i][j3] <= threshold ? this.iSpreadFactor * histogramPerDay[i][j3] : histogramPerDay[i][j3]));
            }
        }
        int currentPenalty = 0;
        for (Lecture lecture : this.variables()) {
            int endSlot;
            int firstSlot;
            Placement placement = (Placement)lecture.getAssignment();
            if (placement == null || (firstSlot = placement.getTimeLocation().getStartSlot()) > Constants.DAY_SLOTS_LAST || (endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1) < Constants.DAY_SLOTS_FIRST) continue;
            for (int i = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST); i <= Math.min(endSlot, Constants.DAY_SLOTS_LAST); ++i) {
                for (j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                    int dayCode = Constants.DAY_CODES[j];
                    if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
                    int[] nArray = nrCourses[i - Constants.DAY_SLOTS_FIRST];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        for (int i = 0; i < Constants.SLOTS_PER_DAY_NO_EVENINGS; ++i) {
            for (int j4 = 0; j4 < Constants.NR_DAYS_WEEK; ++j4) {
                currentPenalty += Math.max(0, nrCourses[i][j4] - maxCourses[i][j4]);
            }
        }
        this.iMaxAllowedPenalty = Math.max(this.iMaxAllowedPenalty, currentPenalty);
        return currentPenalty;
    }

    public int getMaxPenalty(Placement placement) {
        int penalty = 0;
        TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
        while (e.hasMoreElements()) {
            int dif;
            int slot = (Integer)e.nextElement();
            int day = slot / 288;
            int time = slot % 288;
            if (time < Constants.DAY_SLOTS_FIRST || time > Constants.DAY_SLOTS_LAST || day >= Constants.NR_DAYS_WEEK || (dif = this.iNrCourses[time - Constants.DAY_SLOTS_FIRST][day] - this.iMaxCourses[time - Constants.DAY_SLOTS_FIRST][day]) <= penalty) continue;
            penalty = dif;
        }
        return penalty;
    }

    public int getPenalty(Placement placement) {
        if (!this.iInitialized) {
            return 0;
        }
        int firstSlot = placement.getTimeLocation().getStartSlot();
        if (firstSlot > Constants.DAY_SLOTS_LAST) {
            return 0;
        }
        Placement initialPlacement = (Placement)((Lecture)placement.variable()).getAssignment();
        int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
        if (endSlot < Constants.DAY_SLOTS_FIRST) {
            return 0;
        }
        int penalty = 0;
        int min = Math.max(firstSlot, Constants.DAY_SLOTS_FIRST);
        int max = Math.min(endSlot, Constants.DAY_SLOTS_LAST);
        for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
            int dayCode = Constants.DAY_CODES[j];
            if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
            for (int i = min; i <= max; ++i) {
                if (this.iNrCourses[i - Constants.DAY_SLOTS_FIRST][j] < this.iMaxCourses[i - Constants.DAY_SLOTS_FIRST][j] + (initialPlacement == null ? 0 : (this.iCourses[i - Constants.DAY_SLOTS_FIRST][j].contains(initialPlacement) ? 1 : 0))) continue;
                ++penalty;
            }
        }
        return penalty;
    }

    public int[][] getMaxCourses() {
        return this.iMaxCourses;
    }

    public int[][] getNrCourses() {
        return this.iNrCourses;
    }

    public List<Placement>[][] getCourses() {
        return this.iCourses;
    }

    @Override
    public void addVariable(Lecture lecture) {
        if (lecture.canShareRoom()) {
            for (GroupConstraint gc : lecture.groupConstraints()) {
                if (gc.getType() != GroupConstraint.ConstraintType.MEET_WITH || gc.variables().indexOf(lecture) <= 0) continue;
                return;
            }
        }
        super.addVariable(lecture);
    }

    @Override
    public void weaken(Placement value) {
        while (this.inConflict(value)) {
            this.weaken();
        }
    }
}

