/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.cpsolver.coursett.Constants;
import net.sf.cpsolver.coursett.constraint.FlexibleConstraint;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.ifs.model.WeakeningConstraint;
import net.sf.cpsolver.ifs.util.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxBreaksFlexibleConstraint
extends FlexibleConstraint
implements WeakeningConstraint<Lecture, Placement> {
    private int iMaxBreakBetweenBTB;
    private int iMaxBlocksOnADay;
    private Map<Lecture, Placement> iWeakAssignment = new HashMap<Lecture, Placement>();

    public MaxBreaksFlexibleConstraint(Long id, String owner, String preference, String reference) {
        super(id, owner, preference, reference);
        Matcher matcher = Pattern.compile(FlexibleConstraint.FlexibleConstraintType.MAX_BREAKS.getPattern()).matcher(reference);
        if (matcher.find()) {
            this.iMaxBlocksOnADay = 1 + Integer.parseInt(matcher.group(2));
            this.iMaxBreakBetweenBTB = Integer.parseInt(matcher.group(3)) / Constants.SLOT_LENGTH_MIN;
            this.iConstraintType = FlexibleConstraint.FlexibleConstraintType.MAX_BREAKS;
        }
    }

    public List<FlexibleConstraint.Block> getBlocks(int dayCode, Set<Placement> conflicts, Placement value, HashMap<Lecture, Placement> assignments, BitSet week) {
        ArrayList<Placement> toBeSorted = new ArrayList<Placement>(this.getRelevantPlacements(dayCode, conflicts, value, assignments, week));
        Collections.sort(toBeSorted, new FlexibleConstraint.PlacementTimeComparator());
        return this.mergeToBlocks(toBeSorted, this.iMaxBreakBetweenBTB);
    }

    @Override
    public double getNrViolations(Set<Placement> conflicts, HashMap<Lecture, Placement> assignments) {
        int penalty = 0;
        for (int dayCode : Constants.DAY_CODES) {
            for (BitSet week : this.getWeeks()) {
                List<FlexibleConstraint.Block> blocks = this.getBlocks(dayCode, null, null, assignments, week);
                if (blocks.size() <= this.iMaxBlocksOnADay) continue;
                penalty += (blocks.size() - this.iMaxBlocksOnADay) * (blocks.size() - this.iMaxBlocksOnADay);
            }
        }
        return penalty;
    }

    @Override
    public void computeConflicts(Placement value, Set<Placement> conflicts) {
        if (!this.isHard()) {
            return;
        }
        if (value.equals(this.iWeakAssignment.get(value.variable()))) {
            Object object = this.variables().iterator();
            while (object.hasNext()) {
                Lecture v = (Lecture)object.next();
                if (v.getAssignment() != null || v.equals(value.variable())) continue;
                return;
            }
        }
        for (int dayCode : Constants.DAY_CODES) {
            if ((value.getTimeLocation().getDayCode() & dayCode) == 0) continue;
            for (BitSet week : this.getWeeks()) {
                if (week != null && !week.intersects(value.getTimeLocation().getWeekCode())) continue;
                List<FlexibleConstraint.Block> blocks = this.getBlocks(dayCode, conflicts, value, null, week);
                while (blocks.size() > this.iMaxBlocksOnADay) {
                    ArrayList<FlexibleConstraint.Block> adepts = new ArrayList<FlexibleConstraint.Block>();
                    int size = 0;
                    for (FlexibleConstraint.Block block : blocks) {
                        if (block.getPlacements().contains(value)) continue;
                        if (adepts.isEmpty() || size > block.getPlacements().size()) {
                            adepts.clear();
                            adepts.add(block);
                            size = block.getPlacements().size();
                            continue;
                        }
                        if (size != block.getPlacements().size()) continue;
                        adepts.add(block);
                    }
                    FlexibleConstraint.Block block = (FlexibleConstraint.Block)ToolBox.random(adepts);
                    blocks.remove(block);
                    for (Placement conflict : block.getPlacements()) {
                        if (!conflict.equals(((Lecture)conflict.variable()).getAssignment())) continue;
                        conflicts.add(conflict);
                    }
                }
            }
        }
    }

    @Override
    public void weaken() {
    }

    @Override
    public void weaken(Placement value) {
        if (this.isHard()) {
            this.iWeakAssignment.put((Lecture)value.variable(), value);
        }
    }

    @Override
    public void assigned(long iteration, Placement value) {
        super.assigned(iteration, value);
        if (this.isHard()) {
            this.iWeakAssignment.remove(value.variable());
        }
    }
}

