/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.coursett.Constants;
import net.sf.cpsolver.coursett.constraint.JenrlConstraint;
import net.sf.cpsolver.coursett.criteria.DistributionPreferences;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.TimeLocation;
import net.sf.cpsolver.coursett.model.TimetableModel;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.model.GlobalConstraint;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.model.WeakeningConstraint;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.DistanceMetric;
import net.sf.cpsolver.ifs.util.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupConstraint
extends Constraint<Lecture, Placement> {
    private Long iConstraintId;
    private int iPreference;
    private ConstraintType iType;
    private boolean iIsRequired;
    private boolean iIsProhibited;
    private int iLastPreference = 0;
    private int iDayOfWeekOffset = 0;
    private boolean iPrecedenceConsiderDatePatterns = true;
    private int iForwardCheckMaxDepth = 2;
    private int iForwardCheckMaxDomainSize = 1000;

    public GroupConstraint() {
    }

    @Override
    public void setModel(Model<Lecture, Placement> model) {
        super.setModel(model);
        if (model != null) {
            DataProperties config = ((TimetableModel)model).getProperties();
            this.iDayOfWeekOffset = config.getPropertyInt("DatePattern.DayOfWeekOffset", 0);
            this.iPrecedenceConsiderDatePatterns = config.getPropertyBoolean("Precedence.ConsiderDatePatterns", true);
            this.iForwardCheckMaxDepth = config.getPropertyInt("ForwardCheck.MaxDepth", this.iForwardCheckMaxDepth);
            this.iForwardCheckMaxDomainSize = config.getPropertyInt("ForwardCheck.MaxDomainSize", this.iForwardCheckMaxDomainSize);
        }
        if (!this.isHard()) {
            this.iLastPreference = this.getCurrentPreference();
            if (model != null) {
                model.getCriterion(DistributionPreferences.class).inc(this.iLastPreference);
            }
        }
    }

    @Override
    public void addVariable(Lecture lecture) {
        if (!this.variables().contains(lecture)) {
            super.addVariable(lecture);
        }
        if (this.getType().is(Flag.CH_NOTOVERLAP) && lecture.getChildrenSubpartIds() != null) {
            for (Long subpartId : lecture.getChildrenSubpartIds()) {
                for (Lecture ch : lecture.getChildren(subpartId)) {
                    if (this.variables().contains(ch)) continue;
                    super.addVariable(ch);
                }
            }
        }
    }

    @Override
    public void removeVariable(Lecture lecture) {
        if (this.variables().contains(lecture)) {
            super.removeVariable(lecture);
        }
        if (this.getType().is(Flag.CH_NOTOVERLAP) && lecture.getChildrenSubpartIds() != null) {
            for (Long subpartId : lecture.getChildrenSubpartIds()) {
                for (Lecture ch : lecture.getChildren(subpartId)) {
                    if (!this.variables().contains(ch)) continue;
                    super.removeVariable(ch);
                }
            }
        }
    }

    public GroupConstraint(Long id, ConstraintType type, String preference) {
        this.iConstraintId = id;
        this.iType = type;
        this.iIsRequired = preference.equals("R");
        this.iIsProhibited = preference.equals("P");
        this.iPreference = Constants.preference2preferenceLevel(preference);
    }

    public Long getConstraintId() {
        return this.iConstraintId;
    }

    @Override
    public long getId() {
        return this.iConstraintId == null ? -1L : this.iConstraintId;
    }

    protected long getGeneratedId() {
        return this.iId;
    }

    public ConstraintType getType() {
        return this.iType;
    }

    public void setType(ConstraintType type) {
        this.iType = type;
    }

    public boolean isRequired() {
        return this.iIsRequired;
    }

    public boolean isProhibited() {
        return this.iIsProhibited;
    }

    public String getPrologPreference() {
        return Constants.preferenceLevel2preference(this.iPreference);
    }

    @Override
    public boolean isConsistent(Placement value1, Placement value2) {
        HashMap<Lecture, Placement> assignments;
        if (!this.isHard()) {
            return true;
        }
        if (!this.isSatisfiedPair(value1, value2)) {
            return false;
        }
        if (this.getType().is(Flag.BACK_TO_BACK)) {
            assignments = new HashMap<Lecture, Placement>();
            assignments.put((Lecture)value1.variable(), value1);
            assignments.put((Lecture)value2.variable(), value2);
            if (!this.isSatisfiedSeq(assignments, false, null)) {
                return false;
            }
        }
        if (this.getType().is(Flag.MAX_HRS_DAY)) {
            assignments = new HashMap();
            assignments.put((Lecture)value1.variable(), value1);
            assignments.put((Lecture)value2.variable(), value2);
            for (int dayCode : Constants.DAY_CODES) {
                if (this.nrSlotsADay(dayCode, assignments, null) <= this.getType().getMax()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void computeConflicts(Placement value, Set<Placement> conflicts) {
        HashMap<Lecture, Placement> assignments;
        if (!this.isHard()) {
            return;
        }
        for (Lecture v : this.variables()) {
            if (v.equals(value.variable()) || v.getAssignment() == null || this.isSatisfiedPair((Placement)v.getAssignment(), value)) continue;
            conflicts.add((Placement)v.getAssignment());
        }
        if (this.getType().is(Flag.BACK_TO_BACK)) {
            assignments = new HashMap<Lecture, Placement>();
            assignments.put((Lecture)value.variable(), value);
            if (!this.isSatisfiedSeq(assignments, true, conflicts)) {
                conflicts.add(value);
            }
        }
        if (this.getType().is(Flag.MAX_HRS_DAY)) {
            assignments = new HashMap();
            assignments.put((Lecture)value.variable(), value);
            for (int dayCode : Constants.DAY_CODES) {
                if (this.nrSlotsADay(dayCode, assignments, conflicts) <= this.getType().getMax()) continue;
                ArrayList adepts = new ArrayList();
                for (Lecture lecture : this.assignedVariables()) {
                    if (conflicts.contains(lecture.getAssignment()) || lecture.equals(value.variable()) || ((Placement)lecture.getAssignment()).getTimeLocation() == null || (((Placement)lecture.getAssignment()).getTimeLocation().getDayCode() & dayCode) == 0) continue;
                    adepts.add(lecture.getAssignment());
                }
                do {
                    Placement conflict = (Placement)ToolBox.random(adepts);
                    adepts.remove(conflict);
                    conflicts.add(conflict);
                } while (!adepts.isEmpty() && this.nrSlotsADay(dayCode, assignments, conflicts) > this.getType().getMax());
            }
        }
        this.forwardCheck(value, conflicts, new HashSet<GroupConstraint>(), this.iForwardCheckMaxDepth - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forwardCheck(Placement value, Set<Placement> conflicts, Set<GroupConstraint> ignore, int depth) {
        try {
            if (depth < 0) {
                return;
            }
            ignore.add(this);
            int neededSize = ((Lecture)value.variable()).maxRoomUse();
            for (Lecture lecture : this.variables()) {
                if (conflicts.contains(value)) break;
                if (lecture.equals(value.variable())) continue;
                if (lecture.getAssignment() != null) {
                    if (this.isSatisfiedPair(value, (Placement)lecture.getAssignment())) {
                        if (!this.canShareRoom() || !GroupConstraint.sameRoomAndOverlaps(value, (Placement)lecture.getAssignment())) continue;
                        neededSize += lecture.maxRoomUse();
                        continue;
                    }
                    conflicts.add((Placement)lecture.getAssignment());
                }
                boolean shareRoomAndOverlaps = this.canShareRoom();
                Placement support = null;
                int nrSupports = 0;
                if (lecture.nrValues() >= this.iForwardCheckMaxDomainSize) {
                    return;
                }
                if (lecture.values().isEmpty()) {
                    return;
                }
                for (Placement placement : lecture.values()) {
                    if (nrSupports < 2) {
                        if (this.isSatisfiedPair(value, placement)) {
                            if (support == null) {
                                support = placement;
                            }
                            ++nrSupports;
                            if (shareRoomAndOverlaps && !GroupConstraint.sameRoomAndOverlaps(value, placement)) {
                                shareRoomAndOverlaps = false;
                            }
                        }
                    } else if (shareRoomAndOverlaps && !GroupConstraint.sameRoomAndOverlaps(value, placement) && this.isSatisfiedPair(value, placement)) {
                        shareRoomAndOverlaps = false;
                    }
                    if (nrSupports <= 1 || shareRoomAndOverlaps) continue;
                    break;
                }
                if (nrSupports == 0) {
                    conflicts.add(value);
                    return;
                }
                if (shareRoomAndOverlaps) {
                    neededSize += lecture.maxRoomUse();
                }
                if (nrSupports != 1) continue;
                for (Constraint constraint : lecture.hardConstraints()) {
                    if (constraint instanceof WeakeningConstraint) continue;
                    if (constraint instanceof GroupConstraint) {
                        GroupConstraint gc = (GroupConstraint)constraint;
                        if (depth <= 0 || ignore.contains(gc)) continue;
                        gc.forwardCheck(support, conflicts, ignore, depth - 1);
                        continue;
                    }
                    constraint.computeConflicts(support, conflicts);
                }
                for (GlobalConstraint globalConstraint : this.getModel().globalConstraints()) {
                    if (globalConstraint instanceof WeakeningConstraint) continue;
                    globalConstraint.computeConflicts(support, conflicts);
                }
                if (!conflicts.contains(support)) continue;
                conflicts.add(value);
            }
            if (this.canShareRoom() && neededSize > value.getRoomSize()) {
                conflicts.add(value);
            }
        }
        finally {
            ignore.remove(this);
        }
    }

    @Override
    public boolean inConflict(Placement value) {
        HashMap<Lecture, Placement> assignments;
        if (!this.isHard()) {
            return false;
        }
        for (Lecture v : this.variables()) {
            if (v.equals(value.variable()) || v.getAssignment() == null || this.isSatisfiedPair((Placement)v.getAssignment(), value)) continue;
            return true;
        }
        if (this.getType().is(Flag.BACK_TO_BACK)) {
            assignments = new HashMap<Lecture, Placement>();
            assignments.put((Lecture)value.variable(), value);
            if (!this.isSatisfiedSeq(assignments, true, null)) {
                return true;
            }
        }
        if (this.getType().is(Flag.MAX_HRS_DAY)) {
            assignments = new HashMap();
            assignments.put((Lecture)value.variable(), value);
            for (int dayCode : Constants.DAY_CODES) {
                if (this.nrSlotsADay(dayCode, assignments, null) <= this.getType().getMax()) continue;
                return true;
            }
        }
        return !this.forwardCheck(value, new HashSet<GroupConstraint>(), this.iForwardCheckMaxDepth - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forwardCheck(Placement value, Set<GroupConstraint> ignore, int depth) {
        try {
            if (depth < 0) {
                boolean bl = true;
                return bl;
            }
            ignore.add(this);
            int neededSize = ((Lecture)value.variable()).maxRoomUse();
            for (Lecture lecture : this.variables()) {
                if (lecture.equals(value.variable())) continue;
                if (lecture.getAssignment() != null) {
                    if (this.isSatisfiedPair(value, (Placement)lecture.getAssignment())) {
                        if (!this.canShareRoom() || !GroupConstraint.sameRoomAndOverlaps(value, (Placement)lecture.getAssignment())) continue;
                        neededSize += lecture.maxRoomUse();
                        continue;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean shareRoomAndOverlaps = this.canShareRoom();
                Placement support = null;
                int nrSupports = 0;
                if (lecture.nrValues() >= this.iForwardCheckMaxDomainSize) {
                    boolean bl = true;
                    return bl;
                }
                if (lecture.values().isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
                for (Placement placement : lecture.values()) {
                    if (nrSupports < 2) {
                        if (this.isSatisfiedPair(value, placement)) {
                            if (support == null) {
                                support = placement;
                            }
                            ++nrSupports;
                            if (shareRoomAndOverlaps && !GroupConstraint.sameRoomAndOverlaps(value, placement)) {
                                shareRoomAndOverlaps = false;
                            }
                        }
                    } else if (shareRoomAndOverlaps && !GroupConstraint.sameRoomAndOverlaps(value, placement) && this.isSatisfiedPair(value, placement)) {
                        shareRoomAndOverlaps = false;
                    }
                    if (nrSupports <= 1 || shareRoomAndOverlaps) continue;
                    break;
                }
                if (nrSupports == 0) {
                    boolean bl = false;
                    return bl;
                }
                if (shareRoomAndOverlaps) {
                    neededSize += lecture.maxRoomUse();
                }
                if (nrSupports != 1) continue;
                for (Constraint constraint : lecture.hardConstraints()) {
                    if (constraint instanceof WeakeningConstraint) continue;
                    if (constraint instanceof GroupConstraint) {
                        GroupConstraint gc = (GroupConstraint)constraint;
                        if (depth <= 0 || ignore.contains(gc) || gc.forwardCheck(support, ignore, depth - 1)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    if (!constraint.inConflict(support)) continue;
                    boolean bl = false;
                    return bl;
                }
                for (GlobalConstraint globalConstraint : this.getModel().globalConstraints()) {
                    if (globalConstraint instanceof WeakeningConstraint) continue;
                    if (!globalConstraint.inConflict(support)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            if (this.canShareRoom() && neededSize > value.getRoomSize()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ignore.remove(this);
        }
    }

    public int getPreference() {
        return this.iPreference;
    }

    public int getCurrentPreference() {
        if (this.isHard()) {
            return 0;
        }
        if (this.countAssignedVariables() < 2) {
            return -Math.abs(this.iPreference);
        }
        if (this.getType().is(Flag.MAX_HRS_DAY)) {
            int over = 0;
            for (int dayCode : Constants.DAY_CODES) {
                over += Math.max(0, this.nrSlotsADay(dayCode, null, null) - this.getType().getMax());
            }
            return over > 0 ? Math.abs(this.iPreference) * over / 12 : -Math.abs(this.iPreference);
        }
        int nrViolatedPairs = 0;
        for (Lecture v1 : this.variables()) {
            if (v1.getAssignment() == null) continue;
            for (Lecture v2 : this.variables()) {
                if (v2.getAssignment() == null || v1.getId() >= v2.getId() || this.isSatisfiedPair((Placement)v1.getAssignment(), (Placement)v2.getAssignment())) continue;
                ++nrViolatedPairs;
            }
        }
        if (this.getType().is(Flag.BACK_TO_BACK)) {
            HashSet<Placement> conflicts = new HashSet<Placement>();
            nrViolatedPairs = this.isSatisfiedSeq(new HashMap<Lecture, Placement>(), true, conflicts) ? (nrViolatedPairs += conflicts.size()) : this.variables().size();
        }
        return nrViolatedPairs > 0 ? Math.abs(this.iPreference) * nrViolatedPairs : -Math.abs(this.iPreference);
    }

    public int getCurrentPreference(Placement placement) {
        if (this.isHard()) {
            return 0;
        }
        if (this.countAssignedVariables() + (((Lecture)placement.variable()).getAssignment() == null ? 1 : 0) < 2) {
            return 0;
        }
        if (this.getType().is(Flag.MAX_HRS_DAY)) {
            HashMap<Lecture, Placement> assignment = new HashMap<Lecture, Placement>();
            assignment.put((Lecture)placement.variable(), placement);
            HashMap<Lecture, Placement> unassignment = new HashMap<Lecture, Placement>();
            unassignment.put((Lecture)placement.variable(), (Placement)null);
            int after = 0;
            int before = 0;
            for (int dayCode : Constants.DAY_CODES) {
                after += Math.max(0, this.nrSlotsADay(dayCode, assignment, null) - this.getType().getMax());
                before += Math.max(0, this.nrSlotsADay(dayCode, unassignment, null) - this.getType().getMax());
            }
            return (after > 0 ? Math.abs(this.iPreference) * after / 12 : -Math.abs(this.iPreference)) - (before > 0 ? Math.abs(this.iPreference) * before / 12 : -Math.abs(this.iPreference));
        }
        int nrViolatedPairsAfter = 0;
        int nrViolatedPairsBefore = 0;
        for (Lecture v1 : this.variables()) {
            for (Lecture v2 : this.variables()) {
                Placement p2;
                if (v1.getId() >= v2.getId()) continue;
                Placement p1 = v1.equals(placement.variable()) ? null : (Placement)v1.getAssignment();
                Placement placement2 = p2 = v2.equals(placement.variable()) ? null : (Placement)v2.getAssignment();
                if (p1 != null && p2 != null && !this.isSatisfiedPair(p1, p2)) {
                    ++nrViolatedPairsBefore;
                }
                if (v1.equals(placement.variable())) {
                    p1 = placement;
                }
                if (v2.equals(placement.variable())) {
                    p2 = placement;
                }
                if (p1 == null || p2 == null || this.isSatisfiedPair(p1, p2)) continue;
                ++nrViolatedPairsAfter;
            }
        }
        if (this.getType().is(Flag.BACK_TO_BACK)) {
            HashMap<Lecture, Placement> assignment = new HashMap<Lecture, Placement>();
            assignment.put((Lecture)placement.variable(), placement);
            HashSet<Placement> conflicts = new HashSet<Placement>();
            nrViolatedPairsAfter = this.isSatisfiedSeq(assignment, true, conflicts) ? (nrViolatedPairsAfter += conflicts.size()) : this.variables().size();
            HashMap<Lecture, Placement> unassignment = new HashMap<Lecture, Placement>();
            unassignment.put((Lecture)placement.variable(), (Placement)null);
            HashSet<Placement> previous = new HashSet<Placement>();
            nrViolatedPairsBefore = this.isSatisfiedSeq(unassignment, true, previous) ? (nrViolatedPairsBefore += previous.size()) : this.variables().size();
        }
        return (nrViolatedPairsAfter > 0 ? Math.abs(this.iPreference) * nrViolatedPairsAfter : -Math.abs(this.iPreference)) - (nrViolatedPairsBefore > 0 ? Math.abs(this.iPreference) * nrViolatedPairsBefore : -Math.abs(this.iPreference));
    }

    @Override
    public void unassigned(long iteration, Placement value) {
        super.unassigned(iteration, value);
        if (this.iIsRequired || this.iIsProhibited) {
            return;
        }
        this.getModel().getCriterion(DistributionPreferences.class).inc(-this.iLastPreference);
        this.iLastPreference = this.getCurrentPreference();
        this.getModel().getCriterion(DistributionPreferences.class).inc(this.iLastPreference);
    }

    @Override
    public void assigned(long iteration, Placement value) {
        super.assigned(iteration, value);
        if (this.iIsRequired || this.iIsProhibited) {
            return;
        }
        this.getModel().getCriterion(DistributionPreferences.class).inc(-this.iLastPreference);
        this.iLastPreference = this.getCurrentPreference();
        this.getModel().getCriterion(DistributionPreferences.class).inc(this.iLastPreference);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(" between ");
        Iterator e = this.variables().iterator();
        while (e.hasNext()) {
            Lecture v = (Lecture)e.next();
            sb.append(v.getName() + " " + (v.getAssignment() == null ? "" : ((Placement)v.getAssignment()).getName()));
            if (!e.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public boolean isHard() {
        return this.iIsRequired || this.iIsProhibited;
    }

    @Override
    public String getName() {
        return this.getType().getName();
    }

    private boolean isPrecedence(Placement p1, Placement p2, boolean firstGoesFirst, boolean considerDatePatterns) {
        int ord1 = this.variables().indexOf(p1.variable());
        int ord2 = this.variables().indexOf(p2.variable());
        TimeLocation t1 = null;
        TimeLocation t2 = null;
        if (ord1 < ord2) {
            if (firstGoesFirst) {
                t1 = p1.getTimeLocation();
                t2 = p2.getTimeLocation();
            } else {
                t2 = p1.getTimeLocation();
                t1 = p2.getTimeLocation();
            }
        } else if (!firstGoesFirst) {
            t1 = p1.getTimeLocation();
            t2 = p2.getTimeLocation();
        } else {
            t2 = p1.getTimeLocation();
            t1 = p2.getTimeLocation();
        }
        if (considerDatePatterns && this.iPrecedenceConsiderDatePatterns) {
            int m2;
            int m1;
            boolean sameDatePattern;
            boolean bl = sameDatePattern = t1.getDatePatternId() != null ? t1.getDatePatternId().equals(t2.getDatePatternId()) : t1.getWeekCode().equals(t2.getWeekCode());
            if (!sameDatePattern && (m1 = t1.getFirstMeeting(this.iDayOfWeekOffset)) != (m2 = t2.getFirstMeeting(this.iDayOfWeekOffset))) {
                return m1 < m2;
            }
        }
        return (Integer)t1.getStartSlots().nextElement() + t1.getLength() <= (Integer)t2.getStartSlots().nextElement();
    }

    private static boolean isBackToBackDays(TimeLocation t1, TimeLocation t2) {
        int f1 = -1;
        int f2 = -1;
        int e1 = -1;
        int e2 = -1;
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            if ((t1.getDayCode() & Constants.DAY_CODES[i]) != 0) {
                if (f1 < 0) {
                    f1 = i;
                }
                e1 = i;
            }
            if ((t2.getDayCode() & Constants.DAY_CODES[i]) == 0) continue;
            if (f2 < 0) {
                f2 = i;
            }
            e2 = i;
        }
        return e1 + 1 == f2 || e2 + 1 == f1;
    }

    private static boolean isNrDaysBetweenGreaterThanOne(TimeLocation t1, TimeLocation t2) {
        int f1 = -1;
        int f2 = -1;
        int e1 = -1;
        int e2 = -1;
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            if ((t1.getDayCode() & Constants.DAY_CODES[i]) != 0) {
                if (f1 < 0) {
                    f1 = i;
                }
                e1 = i;
            }
            if ((t2.getDayCode() & Constants.DAY_CODES[i]) == 0) continue;
            if (f2 < 0) {
                f2 = i;
            }
            e2 = i;
        }
        return e1 - f2 > 2 || e2 - f1 > 2;
    }

    private boolean isFollowingDay(Placement p1, Placement p2, boolean firstGoesFirst) {
        int ord1 = this.variables().indexOf(p1.variable());
        int ord2 = this.variables().indexOf(p2.variable());
        TimeLocation t1 = null;
        TimeLocation t2 = null;
        if (ord1 < ord2) {
            if (firstGoesFirst) {
                t1 = p1.getTimeLocation();
                t2 = p2.getTimeLocation();
            } else {
                t2 = p1.getTimeLocation();
                t1 = p2.getTimeLocation();
            }
        } else if (!firstGoesFirst) {
            t1 = p1.getTimeLocation();
            t2 = p2.getTimeLocation();
        } else {
            t2 = p1.getTimeLocation();
            t1 = p2.getTimeLocation();
        }
        int f1 = -1;
        int f2 = -1;
        int e1 = -1;
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            if ((t1.getDayCode() & Constants.DAY_CODES[i]) != 0) {
                if (f1 < 0) {
                    f1 = i;
                }
                e1 = i;
            }
            if ((t2.getDayCode() & Constants.DAY_CODES[i]) == 0 || f2 >= 0) continue;
            f2 = i;
        }
        return (e1 + 1) % Constants.NR_DAYS_WEEK == f2;
    }

    private boolean isEveryOtherDay(Placement p1, Placement p2, boolean firstGoesFirst) {
        int ord1 = this.variables().indexOf(p1.variable());
        int ord2 = this.variables().indexOf(p2.variable());
        TimeLocation t1 = null;
        TimeLocation t2 = null;
        if (ord1 < ord2) {
            if (firstGoesFirst) {
                t1 = p1.getTimeLocation();
                t2 = p2.getTimeLocation();
            } else {
                t2 = p1.getTimeLocation();
                t1 = p2.getTimeLocation();
            }
        } else if (!firstGoesFirst) {
            t1 = p1.getTimeLocation();
            t2 = p2.getTimeLocation();
        } else {
            t2 = p1.getTimeLocation();
            t1 = p2.getTimeLocation();
        }
        int f1 = -1;
        int f2 = -1;
        int e1 = -1;
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            if ((t1.getDayCode() & Constants.DAY_CODES[i]) != 0) {
                if (f1 < 0) {
                    f1 = i;
                }
                e1 = i;
            }
            if ((t2.getDayCode() & Constants.DAY_CODES[i]) == 0 || f2 >= 0) continue;
            f2 = i;
        }
        return (e1 + 2) % Constants.NR_DAYS_WEEK == f2;
    }

    private static boolean sameDays(int[] days1, int[] days2) {
        if (days2.length < days1.length) {
            return GroupConstraint.sameDays(days2, days1);
        }
        int i2 = 0;
        for (int i1 = 0; i1 < days1.length; ++i1) {
            block4: {
                int d1 = days1[i1];
                do {
                    if (i2 == days2.length) {
                        return false;
                    }
                    int d2 = days2[i2];
                    if (d1 == d2) break block4;
                } while (++i2 != days2.length);
                return false;
            }
            ++i2;
        }
        return true;
    }

    private static boolean sameRoomAndOverlaps(Placement p1, Placement p2) {
        return p1.shareRooms(p2) && p1.getTimeLocation() != null && p2.getTimeLocation() != null && p1.getTimeLocation().hasIntersection(p2.getTimeLocation());
    }

    private static boolean sameHours(int start1, int len1, int start2, int len2) {
        if (len1 > len2) {
            return GroupConstraint.sameHours(start2, len2, start1, len1);
        }
        return (start1 %= 288) >= (start2 %= 288) && start1 + len1 <= start2 + len2;
    }

    private static boolean canFill(int totalGap, int gapMin, int gapMax, List<Integer> lengths) {
        if (gapMin <= totalGap && totalGap <= gapMax) {
            return true;
        }
        if (totalGap < 2 * gapMin) {
            return false;
        }
        for (int i = 0; i < lengths.size(); ++i) {
            int length = lengths.get(i);
            lengths.remove(i);
            for (int gap = gapMin; gap <= gapMax; ++gap) {
                if (!GroupConstraint.canFill(totalGap - gap - length, gapMin, gapMax, lengths)) continue;
                return true;
            }
            lengths.add(i, length);
        }
        return false;
    }

    private boolean isSatisfiedSeq(HashMap<Lecture, Placement> assignments, boolean considerCurrentAssignments, Set<Placement> conflicts) {
        if (conflicts == null) {
            return this.isSatisfiedSeqCheck(assignments, considerCurrentAssignments, conflicts);
        }
        Set<Placement> bestConflicts = this.isSatisfiedRecursive(0, assignments, considerCurrentAssignments, conflicts, new HashSet<Placement>(), null);
        if (bestConflicts == null) {
            return false;
        }
        conflicts.addAll(bestConflicts);
        return true;
    }

    private Set<Placement> isSatisfiedRecursive(int idx, HashMap<Lecture, Placement> assignments, boolean considerCurrentAssignments, Set<Placement> conflicts, Set<Placement> newConflicts, Set<Placement> bestConflicts) {
        if (idx == this.variables().size() && newConflicts.isEmpty()) {
            return bestConflicts;
        }
        if (this.isSatisfiedSeqCheck(assignments, considerCurrentAssignments, conflicts)) {
            if (bestConflicts == null) {
                return new HashSet<Placement>(newConflicts);
            }
            int b = 0;
            int n = 0;
            for (Placement value : assignments.values()) {
                if (value != null && bestConflicts.contains(value)) {
                    ++b;
                }
                if (value == null || !newConflicts.contains(value)) continue;
                ++n;
            }
            if (n < b || n == b && newConflicts.size() < bestConflicts.size()) {
                return new HashSet<Placement>(newConflicts);
            }
            return bestConflicts;
        }
        if (idx == this.variables().size()) {
            return bestConflicts;
        }
        bestConflicts = this.isSatisfiedRecursive(idx + 1, assignments, considerCurrentAssignments, conflicts, newConflicts, bestConflicts);
        Lecture lecture = (Lecture)this.variables().get(idx);
        Placement placement = null;
        if (assignments != null && assignments.containsKey(lecture)) {
            placement = assignments.get(lecture);
        } else if (considerCurrentAssignments) {
            placement = (Placement)lecture.getAssignment();
        }
        if (placement == null) {
            return bestConflicts;
        }
        if (conflicts != null && conflicts.contains(placement)) {
            return bestConflicts;
        }
        conflicts.add(placement);
        newConflicts.add(placement);
        bestConflicts = this.isSatisfiedRecursive(idx + 1, assignments, considerCurrentAssignments, conflicts, newConflicts, bestConflicts);
        newConflicts.remove(placement);
        conflicts.remove(placement);
        return bestConflicts;
    }

    private boolean isSatisfiedSeqCheck(HashMap<Lecture, Placement> assignments, boolean considerCurrentAssignments, Set<Placement> conflicts) {
        block23: {
            Placement p;
            int nrLectures;
            Placement[] res;
            ArrayList<Integer> lengths;
            int gapMax;
            int gapMin;
            block24: {
                if (!this.getType().is(Flag.BACK_TO_BACK)) {
                    return true;
                }
                gapMin = this.getType().getMin();
                gapMax = this.getType().getMax();
                lengths = new ArrayList<Integer>();
                res = new Placement[288];
                for (int i = 0; i < 288; ++i) {
                    res[i] = null;
                }
                nrLectures = 0;
                for (Lecture lecture : this.variables()) {
                    int j;
                    Placement placement = null;
                    if (assignments != null && assignments.containsKey(lecture)) {
                        placement = assignments.get(lecture);
                    } else if (considerCurrentAssignments) {
                        placement = (Placement)lecture.getAssignment();
                    }
                    if (placement == null) {
                        lengths.add(lecture.timeLocations().get(0).getLength());
                        continue;
                    }
                    if (conflicts != null && conflicts.contains(placement)) {
                        lengths.add(lecture.timeLocations().get(0).getLength());
                        continue;
                    }
                    int pos = placement.getTimeLocation().getStartSlot();
                    int length = placement.getTimeLocation().getLength();
                    for (j = pos; j < pos + length; ++j) {
                        if (res[j] == null) continue;
                        if (conflicts == null) {
                            return false;
                        }
                        if (!assignments.containsKey(lecture)) {
                            conflicts.add(placement);
                            continue;
                        }
                        if (assignments.containsKey(res[j].variable())) continue;
                        conflicts.add(res[j]);
                    }
                    for (j = pos; j < pos + length; ++j) {
                        res[j] = placement;
                    }
                    ++nrLectures;
                }
                if (nrLectures <= 1) {
                    return true;
                }
                if (!this.iIsRequired && (this.iIsProhibited || this.iPreference >= 0)) break block24;
                int i = 0;
                p = res[i];
                while (p == null) {
                    p = res[++i];
                }
                i += res[i].getTimeLocation().getLength();
                --nrLectures;
                while (nrLectures > 0) {
                    int gap = 0;
                    while (i < 288 && res[i] == null) {
                        ++gap;
                        ++i;
                    }
                    if (i != 288) {
                        if (!GroupConstraint.canFill(gap, gapMin, gapMax, lengths)) {
                            return false;
                        }
                        p = res[i];
                        i += res[i].getTimeLocation().getLength();
                        --nrLectures;
                        continue;
                    }
                    break block23;
                }
                break block23;
            }
            if (!this.iIsProhibited && (this.iIsRequired || this.iPreference <= 0)) break block23;
            int i = 0;
            p = res[i];
            while (p == null) {
                p = res[++i];
            }
            i += res[i].getTimeLocation().getLength();
            --nrLectures;
            while (nrLectures > 0) {
                int gap = 0;
                while (i < 288 && res[i] == null) {
                    ++gap;
                    ++i;
                }
                if (i != 288) {
                    if (!(gapMin != 0 && GroupConstraint.canFill(gap, 0, gapMin - 1, lengths) || gapMax < 288 && GroupConstraint.canFill(gap, gapMax + 1, 288, lengths))) {
                        return false;
                    }
                    p = res[i];
                    i += res[i].getTimeLocation().getLength();
                    --nrLectures;
                    continue;
                }
                break;
            }
        }
        return true;
    }

    public boolean isSatisfied() {
        if (this.isHard()) {
            return true;
        }
        if (this.countAssignedVariables() < 2) {
            return true;
        }
        if (this.getPreference() == 0) {
            return true;
        }
        return this.isHard() || this.countAssignedVariables() < 2 || this.getPreference() == 0 || this.getCurrentPreference() < 0;
    }

    public boolean isChildrenNotOverlap(Lecture lec1, Placement plc1, Lecture lec2, Placement plc2) {
        if (lec1.getSchedulingSubpartId().equals(lec2.getSchedulingSubpartId())) {
            boolean overlap = plc1.getTimeLocation().hasIntersection(plc2.getTimeLocation());
            if (overlap && lec1.getParent() != null && this.variables().contains(lec1.getParent()) && lec2.getParent() != null && this.variables().contains(lec2.getParent())) {
                Placement p1 = (Placement)lec1.getParent().getAssignment();
                Placement p2 = (Placement)lec2.getParent().getAssignment();
                if (p1 != null && p2 != null && !p1.getTimeLocation().hasIntersection(p2.getTimeLocation())) {
                    return false;
                }
            }
            if (!overlap && lec1.getChildrenSubpartIds() != null && lec2.getChildrenSubpartIds() != null) {
                for (Long subpartId : lec1.getChildrenSubpartIds()) {
                    for (Lecture c1 : lec1.getChildren(subpartId)) {
                        if (c1.getAssignment() == null) continue;
                        for (Lecture c2 : lec2.getChildren(subpartId)) {
                            if (c2.getAssignment() == null || !c1.getSchedulingSubpartId().equals(c2.getSchedulingSubpartId())) continue;
                            Placement p1 = (Placement)c1.getAssignment();
                            Placement p2 = (Placement)c2.getAssignment();
                            if (!p1.getTimeLocation().hasIntersection(p2.getTimeLocation())) continue;
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    public boolean isSatisfiedPair(Placement plc1, Placement plc2) {
        if (this.iIsRequired || !this.iIsProhibited && this.iPreference <= 0) {
            return this.getType().isSatisfied(this, plc1, plc2);
        }
        if (this.iIsProhibited || !this.iIsRequired && this.iPreference > 0) {
            return this.getType().isViolated(this, plc1, plc2);
        }
        return true;
    }

    public boolean canShareRoom() {
        return this.getType().is(Flag.CAN_SHARE_ROOM);
    }

    private int nrSlotsADay(int dayCode, HashMap<Lecture, Placement> assignments, Set<Placement> conflicts) {
        HashSet<Integer> slots = new HashSet<Integer>();
        for (Lecture lecture : this.variables()) {
            TimeLocation t;
            Placement placement = null;
            placement = assignments != null && assignments.containsKey(lecture) ? assignments.get(lecture) : (Placement)lecture.getAssignment();
            if (placement == null || placement.getTimeLocation() == null || conflicts != null && conflicts.contains(placement) || (t = placement.getTimeLocation()) == null || (t.getDayCode() & dayCode) == 0) continue;
            for (int i = 0; i < t.getLength(); ++i) {
                slots.add(i + t.getStartSlot());
            }
        }
        return slots.size();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof GroupConstraint)) {
            return false;
        }
        return this.getGeneratedId() == ((GroupConstraint)o).getGeneratedId();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConstraintType {
        SAME_TIME("SAME_TIME", "Same Time", new PairCheck(){

            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return GroupConstraint.sameHours(plc1.getTimeLocation().getStartSlot(), plc1.getTimeLocation().getLength(), plc2.getTimeLocation().getStartSlot(), plc2.getTimeLocation().getLength());
            }

            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !plc1.getTimeLocation().shareHours(plc2.getTimeLocation());
            }
        }, new Flag[0]),
        SAME_DAYS("SAME_DAYS", "Same Days", new PairCheck(){

            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray());
            }

            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !plc1.getTimeLocation().shareDays(plc2.getTimeLocation());
            }
        }, new Flag[0]),
        BTB("BTB", "Back-To-Back & Same Room", new PairCheck(){

            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return plc1.sameRooms(plc2) && GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray());
            }

            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return plc1.sameRooms(plc2) && GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray());
            }
        }, Flag.BACK_TO_BACK),
        BTB_TIME("BTB_TIME", "Back-To-Back", new PairCheck(){

            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray());
            }

            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray());
            }
        }, Flag.BACK_TO_BACK),
        DIFF_TIME("DIFF_TIME", "Different Time", new PairCheck(){

            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !plc1.getTimeLocation().hasIntersection(plc2.getTimeLocation());
            }

            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return plc1.getTimeLocation().hasIntersection(plc2.getTimeLocation());
            }
        }, new Flag[0]),
        NHB_1("NHB(1)", "1 Hour Between", 10, 12, BTB_TIME.check(), Flag.BACK_TO_BACK),
        NHB_2("NHB(2)", "2 Hours Between", 20, 24, BTB_TIME.check(), Flag.BACK_TO_BACK),
        NHB_3("NHB(3)", "3 Hours Between", 30, 36, BTB_TIME.check(), Flag.BACK_TO_BACK),
        NHB_4("NHB(4)", "4 Hours Between", 40, 48, BTB_TIME.check(), Flag.BACK_TO_BACK),
        NHB_5("NHB(5)", "5 Hours Between", 50, 60, BTB_TIME.check(), Flag.BACK_TO_BACK),
        NHB_6("NHB(6)", "6 Hours Between", 60, 72, BTB_TIME.check(), Flag.BACK_TO_BACK),
        NHB_7("NHB(7)", "7 Hours Between", 70, 84, BTB_TIME.check(), Flag.BACK_TO_BACK),
        NHB_8("NHB(8)", "8 Hours Between", 80, 96, BTB_TIME.check(), Flag.BACK_TO_BACK),
        SAME_START("SAME_START", "Same Start Time", new PairCheck(){

            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return plc1.getTimeLocation().getStartSlot() % 288 == plc2.getTimeLocation().getStartSlot() % 288;
            }

            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return plc1.getTimeLocation().getStartSlot() % 288 != plc2.getTimeLocation().getStartSlot() % 288;
            }
        }, new Flag[0]),
        SAME_ROOM("SAME_ROOM", "Same Room", new PairCheck(){

            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return plc1.sameRooms(plc2);
            }

            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !plc1.sameRooms(plc2);
            }
        }, new Flag[0]),
        NHB_GTE_1("NHB_GTE(1)", "At Least 1 Hour Between", 6, 288, BTB_TIME.check(), Flag.BACK_TO_BACK),
        NHB_LT_6("NHB_LT(6)", "Less Than 6 Hours Between", 0, 72, BTB_TIME.check(), Flag.BACK_TO_BACK),
        NHB_1_5("NHB(1.5)", "1.5 Hour Between", 15, 18, BTB_TIME.check(), Flag.BACK_TO_BACK),
        NHB_4_5("NHB(4.5)", "4.5 Hours Between", 45, 54, BTB_TIME.check(), Flag.BACK_TO_BACK),
        SAME_STUDENTS("SAME_STUDENTS", "Same Students", new PairCheck(){

            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !JenrlConstraint.isInConflict(plc1, plc2, ((TimetableModel)gc.getModel()).getDistanceMetric());
            }

            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return true;
            }
        }, new Flag[0]),
        SAME_INSTR("SAME_INSTR", "Same Instructor", new PairCheck(){

            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                TimeLocation t2;
                TimeLocation t1 = plc1.getTimeLocation();
                if (t1.shareDays(t2 = plc2.getTimeLocation()) && t1.shareWeeks(t2)) {
                    if (t1.shareHours(t2)) {
                        return false;
                    }
                    DistanceMetric m = ((TimetableModel)gc.getModel()).getDistanceMetric();
                    if (t1.getStartSlot() + t1.getLength() == t2.getStartSlot() || t2.getStartSlot() + t2.getLength() == t1.getStartSlot()) {
                        if (Placement.getDistanceInMeters(m, plc1, plc2) > m.getInstructorProhibitedLimit()) {
                            return false;
                        }
                    } else if (m.doComputeDistanceConflictsBetweenNonBTBClasses()) {
                        if (t1.getStartSlot() + t1.getLength() < t2.getStartSlot() && Placement.getDistanceInMinutes(m, plc1, plc2) > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - t1.getStartSlot() - t1.getLength())) {
                            return false;
                        }
                        if (t2.getStartSlot() + t2.getLength() < t1.getStartSlot() && Placement.getDistanceInMinutes(m, plc1, plc2) > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t1.getStartSlot() - t2.getStartSlot() - t2.getLength())) {
                            return false;
                        }
                    }
                }
                return true;
            }

            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return true;
            }
        }, new Flag[0]),
        CAN_SHARE_ROOM("CAN_SHARE_ROOM", "Can Share Room", null, Flag.CAN_SHARE_ROOM),
        PRECEDENCE("PRECEDENCE", "Precedence", new PairCheck(){

            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isPrecedence(plc1, plc2, true, true);
            }

            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isPrecedence(plc1, plc2, false, true);
            }
        }, new Flag[0]),
        BTB_DAY("BTB_DAY", "Back-To-Back Day", new PairCheck(){

            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray()) && GroupConstraint.isBackToBackDays(plc1.getTimeLocation(), plc2.getTimeLocation());
            }

            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray()) && !GroupConstraint.isBackToBackDays(plc1.getTimeLocation(), plc2.getTimeLocation());
            }
        }, new Flag[0]),
        MEET_WITH("MEET_WITH", "Meet Together", new PairCheck(){

            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return plc1.sameRooms(plc2) && GroupConstraint.sameHours(plc1.getTimeLocation().getStartSlot(), plc1.getTimeLocation().getLength(), plc2.getTimeLocation().getStartSlot(), plc2.getTimeLocation().getLength()) && GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray());
            }

            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return true;
            }
        }, Flag.CAN_SHARE_ROOM),
        NDB_GT_1("NDB_GT_1", "More Than 1 Day Between", new PairCheck(){

            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray()) && GroupConstraint.isNrDaysBetweenGreaterThanOne(plc1.getTimeLocation(), plc2.getTimeLocation());
            }

            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray()) && !GroupConstraint.isNrDaysBetweenGreaterThanOne(plc1.getTimeLocation(), plc2.getTimeLocation());
            }
        }, new Flag[0]),
        CH_NOTOVERLAP("CH_NOTOVERLAP", "Children Cannot Overlap", new PairCheck(){

            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isChildrenNotOverlap((Lecture)plc1.variable(), plc1, (Lecture)plc2.variable(), plc2);
            }

            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return true;
            }
        }, new Flag[0]),
        FOLLOWING_DAY("FOLLOWING_DAY", "Next Day", new PairCheck(){

            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isFollowingDay(plc1, plc2, true);
            }

            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isFollowingDay(plc1, plc2, false);
            }
        }, new Flag[0]),
        EVERY_OTHER_DAY("EVERY_OTHER_DAY", "Two Days After", new PairCheck(){

            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isEveryOtherDay(plc1, plc2, true);
            }

            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isEveryOtherDay(plc1, plc2, false);
            }
        }, new Flag[0]),
        MAX_HRS_DAY_5("MAX_HRS_DAY(5)", "At Most 5 Hours A Day", 60, null, Flag.MAX_HRS_DAY),
        MAX_HRS_DAY_6("MAX_HRS_DAY(6)", "At Most 6 Hours A Day", 72, null, Flag.MAX_HRS_DAY),
        MAX_HRS_DAY_7("MAX_HRS_DAY(7)", "At Most 7 Hours A Day", 84, null, Flag.MAX_HRS_DAY),
        MAX_HRS_DAY_8("MAX_HRS_DAY(8)", "At Most 8 Hours A Day", 96, null, Flag.MAX_HRS_DAY),
        SAME_WEEKS("SAME_WEEKS", "Same Weeks", new PairCheck(){

            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return plc1.getTimeLocation().getWeekCode().equals(plc2.getTimeLocation().getWeekCode());
            }

            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !plc1.getTimeLocation().shareWeeks(plc2.getTimeLocation());
            }
        }, new Flag[0]),
        LINKED_SECTIONS("LINKED_SECTIONS", "Linked Classes", SAME_STUDENTS.check(), new Flag[0]),
        BTB_PRECEDENCE("BTB_PRECEDENCE", "Back-To-Back Precedence", new PairCheck(){

            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isPrecedence(plc1, plc2, true, false) && GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray());
            }

            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isPrecedence(plc1, plc2, true, false) && GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray());
            }
        }, Flag.BACK_TO_BACK),
        SAME_DAYS_TIME("SAME_D_T", "Same Days-Time", new PairCheck(){

            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return GroupConstraint.sameHours(plc1.getTimeLocation().getStartSlot(), plc1.getTimeLocation().getLength(), plc2.getTimeLocation().getStartSlot(), plc2.getTimeLocation().getLength()) && GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray());
            }

            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !plc1.getTimeLocation().shareHours(plc2.getTimeLocation()) || !plc1.getTimeLocation().shareDays(plc2.getTimeLocation());
            }
        }, new Flag[0]),
        SAME_DAYS_ROOM_TIME("SAME_D_R_T", "Same Days-Room-Time", new PairCheck(){

            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return GroupConstraint.sameHours(plc1.getTimeLocation().getStartSlot(), plc1.getTimeLocation().getLength(), plc2.getTimeLocation().getStartSlot(), plc2.getTimeLocation().getLength()) && GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray()) && plc1.sameRooms(plc2);
            }

            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !plc1.getTimeLocation().shareHours(plc2.getTimeLocation()) || !plc1.getTimeLocation().shareDays(plc2.getTimeLocation()) || !plc1.sameRooms(plc2);
            }
        }, new Flag[0]);

        String iReference;
        String iName;
        int iFlag = 0;
        Flag[] iFlags = null;
        int iMin = 0;
        int iMax = 0;
        PairCheck iCheck = null;

        private ConstraintType(String reference, String name, PairCheck check, Flag ... flags) {
            this.iReference = reference;
            this.iName = name;
            this.iCheck = check;
            this.iFlags = flags;
            for (Flag f : flags) {
                this.iFlag |= f.flag();
            }
        }

        private ConstraintType(String reference, String name, int limit, PairCheck check, Flag ... flags) {
            this(reference, name, check, flags);
            this.iMin = this.iMax = limit;
        }

        private ConstraintType(String reference, String name, int min, int max, PairCheck check, Flag ... flags) {
            this(reference, name, check, flags);
            this.iMin = min;
            this.iMax = max;
        }

        public String reference() {
            return this.iReference;
        }

        public String getName() {
            return this.iName;
        }

        public int getMin() {
            return this.iMin;
        }

        public int getMax() {
            return this.iMax;
        }

        public boolean is(Flag f) {
            return (this.iFlag & f.flag()) != 0;
        }

        public static ConstraintType get(String reference) {
            for (ConstraintType t : ConstraintType.values()) {
                if (!t.reference().equals(reference)) continue;
                return t;
            }
            return null;
        }

        public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
            return this.iCheck == null ? true : this.iCheck.isSatisfied(gc, plc1, plc2);
        }

        public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
            return this.iCheck == null ? true : this.iCheck.isViolated(gc, plc1, plc2);
        }

        private PairCheck check() {
            return this.iCheck;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        BACK_TO_BACK,
        CAN_SHARE_ROOM,
        MAX_HRS_DAY,
        CH_NOTOVERLAP;


        int flag() {
            return 1 << this.ordinal();
        }
    }

    public static interface PairCheck {
        public boolean isSatisfied(GroupConstraint var1, Placement var2, Placement var3);

        public boolean isViolated(GroupConstraint var1, Placement var2, Placement var3);
    }
}

