/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett;

import net.sf.cpsolver.coursett.heuristics.NeighbourSelectionWithSuggestions;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.TimetableModel;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.JProf;
import net.sf.cpsolver.ifs.util.Progress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimetableSolver
extends Solver<Lecture, Placement> {
    private long iLastCompleteSolutionFixIteration = -1L;
    private long iLastIncompleteSolutionFixIteration = -1L;
    private long iCompleteSolutionFixInterval = 1L;
    private long iIncompleteSolutionFixInterval = 5000L;

    public TimetableSolver(DataProperties properties) {
        super(properties);
    }

    @Override
    public void initSolver() {
        super.initSolver();
        this.iCompleteSolutionFixInterval = this.getProperties().getPropertyLong("General.CompleteSolutionFixInterval", this.iCompleteSolutionFixInterval);
        this.iIncompleteSolutionFixInterval = this.getProperties().getPropertyLong("General.IncompleteSolutionFixInterval", this.iIncompleteSolutionFixInterval);
    }

    @Override
    protected void onAssigned(double startTime) {
        if (this.iCurrentSolution.getModel().nrUnassignedVariables() == 0) {
            if (this.iCompleteSolutionFixInterval < 0L) {
                return;
            }
            if (this.iCompleteSolutionFixInterval == 0L ? this.iLastCompleteSolutionFixIteration >= 0L : this.iLastCompleteSolutionFixIteration >= 0L && this.iCurrentSolution.getIteration() - this.iLastCompleteSolutionFixIteration < this.iCompleteSolutionFixInterval) {
                return;
            }
            if (this.getSolutionComparator().isBetterThanBestSolution(this.iCurrentSolution)) {
                this.fixCompleteSolution(startTime);
                this.iLastCompleteSolutionFixIteration = this.iCurrentSolution.getIteration();
            }
        } else if (this.iCurrentSolution.getBestInfo() == null) {
            if (this.iIncompleteSolutionFixInterval < 0L) {
                return;
            }
            if (this.iIncompleteSolutionFixInterval == 0L ? this.iLastIncompleteSolutionFixIteration >= 0L : this.iLastIncompleteSolutionFixIteration >= 0L && this.iCurrentSolution.getIteration() - this.iLastIncompleteSolutionFixIteration < this.iIncompleteSolutionFixInterval) {
                return;
            }
            if (this.getSolutionComparator().isBetterThanBestSolution(this.iCurrentSolution)) {
                this.fixCompleteSolution(startTime);
                this.iLastIncompleteSolutionFixIteration = this.iCurrentSolution.getIteration();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fixCompleteSolution(double startTime) {
        Progress progress = Progress.getInstance(this.currentSolution().getModel());
        TimetableModel model = (TimetableModel)this.iCurrentSolution.getModel();
        this.iCurrentSolution.saveBest();
        progress.save();
        double solutionValue = 0.0;
        double newSolutionValue = model.getTotalValue();
        do {
            solutionValue = newSolutionValue;
            progress.setPhase("Fixing solution", model.variables().size());
            for (Lecture variable : model.variables()) {
                Placement bestValue = null;
                double bestVal = 0.0;
                Placement currentValue = (Placement)variable.getAssignment();
                if (currentValue == null) continue;
                double currentVal = currentValue.toDouble();
                for (Placement value : variable.values()) {
                    if (value.equals(currentValue) || !model.conflictValues(value).isEmpty()) continue;
                    double val = value.toDouble();
                    if (bestValue != null && !(val < bestVal)) continue;
                    bestValue = value;
                    bestVal = val;
                }
                if (bestValue != null && bestVal < currentVal) {
                    variable.assign(0L, bestValue);
                }
                this.iCurrentSolution.update(JProf.currentTimeSec() - startTime);
                progress.incProgress();
                if (!this.iStop) continue;
                break;
            }
            if (!((newSolutionValue = model.getTotalValue()) < solutionValue)) continue;
            progress.debug("New solution value is  " + newSolutionValue);
        } while (!this.iStop && newSolutionValue < solutionValue && this.getTerminationCondition().canContinue(this.iCurrentSolution));
        progress.restore();
        if (!this.iCurrentSolution.getModel().unassignedVariables().isEmpty()) {
            return;
        }
        progress.save();
        try {
            progress.setPhase("Fixing solution [2]", model.variables().size());
            NeighbourSelectionWithSuggestions ns = new NeighbourSelectionWithSuggestions(this);
            for (Lecture lecture : model.variables()) {
                Neighbour<Lecture, Placement> n = ns.selectNeighbourWithSuggestions(this.iCurrentSolution, lecture, 2);
                if (n != null && n.value() <= 0.0) {
                    n.assign(0L);
                }
                this.iCurrentSolution.update(JProf.currentTimeSec() - startTime);
                progress.incProgress();
                if (!this.iStop) continue;
                break;
            }
        }
        catch (Exception e) {
            sLogger.debug((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            progress.restore();
        }
    }
}

