/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett;

import java.io.File;
import java.util.Comparator;
import java.util.TreeSet;
import net.sf.cpsolver.coursett.DomainChart;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.TimetableModel;
import net.sf.cpsolver.ifs.util.ToolBox;

public class JenrlChart
extends DomainChart {
    protected int iMax = 100;

    public JenrlChart(String name, TimetableModel model, int max) {
        super(name, model, Math.min(max, model.variables().size()), Math.min(max, model.variables().size()));
        this.iMax = max;
    }

    public JenrlChart(File xmlFile, int max) throws Exception {
        super(xmlFile, 0, 0);
        this.iMax = max;
        this.iSizeX = Math.min(this.iMax, this.iModel.variables().size());
        this.iSizeY = Math.min(this.iMax, this.iModel.variables().size());
    }

    protected void computeTable() {
        this.clearTable();
        TreeSet<Lecture> vars = new TreeSet<Lecture>(new Comparator<Lecture>(){

            @Override
            public int compare(Lecture l1, Lecture l2) {
                int cmp = -Double.compare(l1.students().size(), l2.students().size());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = -Double.compare(l1.classLimit(), l2.classLimit());
                if (cmp != 0) {
                    return cmp;
                }
                return Double.compare(l1.getId(), l2.getId());
            }
        });
        vars.addAll(this.iModel.variables());
        int x = 1;
        for (Lecture l1 : vars) {
            if (x <= this.iMax) {
                this.iHeader[x] = String.valueOf(l1.students().size());
                int y = 1;
                for (Lecture l2 : vars) {
                    if (y <= this.iMax) {
                        this.iTitle[y] = l2.getName();
                        if (x < y) {
                            this.add(x, y, l1.sameStudents(l2).size());
                        }
                    }
                    ++y;
                }
            }
            ++x;
        }
    }

    public static void main(String[] args) {
        try {
            ToolBox.configureLogging();
            File input = new File(args[0]);
            int max = Integer.parseInt(args[1]);
            File output = null;
            if (args.length > 2) {
                output = new File(args[2]);
                if (output.exists() && output.isDirectory()) {
                    output = new File(output, input.getName().substring(0, input.getName().lastIndexOf(46)) + "_jenrl.csv");
                }
            } else {
                output = new File(input.getParentFile(), input.getName().substring(0, input.getName().lastIndexOf(46)) + "_jenrl.csv");
            }
            new JenrlChart(input, max).createTable().save(output);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

