/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMppInfo {
    public static HashMap<String, String> getInfo(File outputFile) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(outputFile));
            String line = null;
            HashMap<String, String> info = new HashMap<String, String>();
            while ((line = reader.readLine()) != null) {
                int idx = line.indexOf(44);
                if (idx < 0) continue;
                String key = line.substring(0, idx).trim();
                String value = line.substring(idx + 1).trim();
                if (value.indexOf(40) >= 0 && value.indexOf(41) >= 0 && (value = value.substring(value.indexOf(40) + 1, value.indexOf(41))).indexOf(47) >= 0) {
                    String bound = value.substring(value.indexOf(47) + 1);
                    if (bound.indexOf("..") >= 0) {
                        String min = bound.substring(0, bound.indexOf(".."));
                        String max = bound.substring(bound.indexOf("..") + 2);
                        info.put(key + " Min", min);
                        info.put(key + " Max", max);
                    } else {
                        info.put(key + " Bound", bound);
                    }
                    value = value.substring(0, value.indexOf(47));
                }
                if (value.length() <= 0) continue;
                info.put(key, value);
            }
            reader.close();
            return info;
        }
        catch (Exception e) {
            System.err.println("Error reading info, message: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static void getInfos(File file, HashMap<String, HashMap<String, HashMap<Integer, double[]>>> infos, String instance) {
        HashMap<String, String> info = GetMppInfo.getInfo(file);
        if (info == null || info.isEmpty() || !info.containsKey("000.053 Given perturbations")) {
            return;
        }
        Integer pert = Integer.valueOf(info.get("000.053 Given perturbations"));
        for (Map.Entry<String, String> entry : info.entrySet()) {
            double[] pertTable;
            HashMap<Integer, Object> instanceTable;
            String key = entry.getKey();
            String value = entry.getValue();
            if (!key.startsWith("000.") || key.equals("000.053 Given perturbations")) continue;
            HashMap<String, HashMap<Integer, Object>> keyTable = infos.get(key);
            if (keyTable == null) {
                keyTable = new HashMap();
                infos.put(key, keyTable);
            }
            if ((instanceTable = keyTable.get(instance)) == null) {
                instanceTable = new HashMap();
                keyTable.put(instance, instanceTable);
            }
            if ((pertTable = instanceTable.get(pert)) == null) {
                pertTable = new double[]{0.0, 0.0};
                instanceTable.put(pert, pertTable);
            }
            pertTable[0] = pertTable[0] + Double.parseDouble(value);
            pertTable[1] = pertTable[1] + 1.0;
        }
    }

    public static void writeInfos(HashMap<String, HashMap<String, HashMap<Integer, double[]>>> infos, File file) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(file));
        for (String key : new TreeSet<String>(infos.keySet())) {
            HashMap<Integer, double[]> instanceTable;
            out.println(key);
            HashMap<String, HashMap<Integer, double[]>> keyTable = infos.get(key);
            TreeSet<Integer> perts = new TreeSet<Integer>();
            for (String instance : new TreeSet<String>(keyTable.keySet())) {
                instanceTable = keyTable.get(instance);
                perts.addAll(instanceTable.keySet());
            }
            out.print(",,");
            Iterator i = perts.iterator();
            while (i.hasNext()) {
                Integer pert = (Integer)i.next();
                out.print(pert);
                if (!i.hasNext()) continue;
                out.print(",");
            }
            out.println();
            for (String instance : new TreeSet<String>(keyTable.keySet())) {
                instanceTable = keyTable.get(instance);
                perts.addAll(instanceTable.keySet());
                out.print("," + instance + ",");
                Iterator i2 = perts.iterator();
                while (i2.hasNext()) {
                    Integer pert = (Integer)i2.next();
                    double[] pertTable = instanceTable.get(pert);
                    if (pertTable != null) {
                        out.print(pertTable[0] / pertTable[1]);
                    }
                    if (!i2.hasNext()) continue;
                    out.print(",");
                }
                out.println();
            }
        }
        out.flush();
        out.close();
    }

    public static void main(String[] args) {
        try {
            File folder = new File(".");
            if (args.length >= 1) {
                folder = new File(args[0]);
            }
            String config = "mpp";
            if (args.length >= 2) {
                config = args[1];
            }
            File[] instanceFolders = folder.listFiles();
            HashMap<String, HashMap<String, HashMap<Integer, double[]>>> infos = new HashMap<String, HashMap<String, HashMap<Integer, double[]>>>();
            for (int i = 0; i < instanceFolders.length; ++i) {
                File instanceFolder = instanceFolders[i];
                if (!instanceFolder.exists() || !instanceFolder.isDirectory() || !instanceFolder.getName().startsWith(config + "-")) continue;
                System.out.println("Checking " + instanceFolder.getName() + " ...");
                File[] files = instanceFolder.listFiles();
                for (int j = 0; j < files.length; ++j) {
                    File outputFile;
                    if (!files[j].isDirectory() || !(outputFile = new File(files[j], "output.csv")).exists()) continue;
                    System.out.println("  Checking " + files[j].getName() + " ...");
                    GetMppInfo.getInfos(outputFile, infos, instanceFolder.getName().substring(config.length() + 1));
                }
            }
            if (!infos.isEmpty()) {
                GetMppInfo.writeInfos(infos, new File(folder, "info.csv"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

