/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.reservation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.sf.cpsolver.studentsct.model.Offering;
import net.sf.cpsolver.studentsct.model.Student;
import net.sf.cpsolver.studentsct.reservation.Reservation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndividualReservation
extends Reservation {
    private Set<Long> iStudentIds = new HashSet<Long>();

    public IndividualReservation(long id, Offering offering, Long ... studentIds) {
        super(id, offering);
        for (Long studentId : studentIds) {
            this.iStudentIds.add(studentId);
        }
    }

    public IndividualReservation(long id, Offering offering, Collection<Long> studentIds) {
        super(id, offering);
        this.iStudentIds.addAll(studentIds);
    }

    @Override
    public boolean canAssignOverLimit() {
        return true;
    }

    @Override
    public boolean mustBeUsed() {
        return !this.isExpired();
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public boolean isApplicable(Student student) {
        return this.iStudentIds.contains(student.getId());
    }

    public Set<Long> getStudentIds() {
        return this.iStudentIds;
    }

    @Override
    public double getReservationLimit() {
        return this.iStudentIds.size();
    }

    @Override
    public boolean isAllowOverlap() {
        return true;
    }
}

