/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.reservation;

import net.sf.cpsolver.studentsct.model.Course;
import net.sf.cpsolver.studentsct.model.CourseRequest;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Student;
import net.sf.cpsolver.studentsct.reservation.Reservation;

public class CourseReservation
extends Reservation {
    private Course iCourse;

    public CourseReservation(long id, Course course) {
        super(id, course.getOffering());
        this.iCourse = course;
    }

    public boolean canAssignOverLimit() {
        return false;
    }

    public boolean mustBeUsed() {
        return false;
    }

    public double getReservationLimit() {
        return this.iCourse.getLimit();
    }

    public int getPriority() {
        return 2;
    }

    public Course getCourse() {
        return this.iCourse;
    }

    public boolean isApplicable(Student student) {
        for (Request r : student.getRequests()) {
            if (!(r instanceof CourseRequest)) continue;
            for (Course course : ((CourseRequest)r).getCourses()) {
                if (!course.equals(this.getCourse())) continue;
                return true;
            }
        }
        return false;
    }
}

