/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.report;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.cpsolver.ifs.model.GlobalConstraint;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.util.CSVFile;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.studentsct.StudentSectioningModel;
import net.sf.cpsolver.studentsct.constraint.SectionLimit;
import net.sf.cpsolver.studentsct.model.Course;
import net.sf.cpsolver.studentsct.model.CourseRequest;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.FreeTimeRequest;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Section;
import net.sf.cpsolver.studentsct.report.CourseSection;
import net.sf.cpsolver.studentsct.report.StudentSectioningReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectionConflictTable
implements StudentSectioningReport {
    private static DecimalFormat sDF1 = new DecimalFormat("0.####");
    private static DecimalFormat sDF2 = new DecimalFormat("0.0000");
    private StudentSectioningModel iModel = null;
    private Type iType;
    private boolean iOverlapsAllEnrollments = true;

    public SectionConflictTable(StudentSectioningModel model, Type type) {
        this.iModel = model;
        this.iType = type;
    }

    public SectionConflictTable(StudentSectioningModel model) {
        this(model, Type.OVERLAPS_AND_UNAVAILABILITIES);
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    private boolean canIgnore(Enrollment enrollment, Section section, List<Enrollment> other) {
        block0: for (Enrollment e : other) {
            Section a = null;
            for (Section s : e.getSections()) {
                if (s.getSubpart().equals(section.getSubpart())) {
                    if (s.equals(section)) continue block0;
                    a = s;
                    continue;
                }
                if (enrollment.getSections().contains(s)) continue;
                continue block0;
            }
            if (a == null) continue;
            for (Request r : enrollment.getStudent().getRequests()) {
                if (enrollment.getRequest().equals(r) || r.getAssignment() == null || !(r instanceof CourseRequest) || ((Enrollment)r.getAssignment()).isAllowOverlap()) continue;
                for (Section b : ((Enrollment)r.getAssignment()).getSections()) {
                    if (b.isAllowOverlap() || b.isToIgnoreStudentConflictsWith(section.getId()) || b.getTime() == null || a.getTime() == null || a.isAllowOverlap() || !b.getTime().hasIntersection(a.getTime())) continue;
                    continue block0;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * Could not resolve type clashes
     */
    public CSVFile createTable(boolean includeLastLikeStudents, boolean includeRealStudents) {
        HashMap unavailabilities = new HashMap();
        HashMap<Course, HashSet<Long>> totals = new HashMap<Course, HashSet<Long>>();
        HashMap conflictingPairs = new HashMap();
        HashMap<CourseSection, Double> sectionOverlaps = new HashMap<CourseSection, Double>();
        for (Request request : new ArrayList(this.getModel().unassignedVariables())) {
            Object total;
            Object other2;
            CourseRequest courseRequest;
            if (request.getStudent().isDummy() && !includeLastLikeStudents || !request.getStudent().isDummy() && !includeRealStudents || !(request instanceof CourseRequest) || (courseRequest = (CourseRequest)request).getStudent().isComplete()) continue;
            List<Enrollment> values = courseRequest.values();
            SectionLimit limitConstraint = null;
            for (GlobalConstraint c : this.getModel().globalConstraints()) {
                if (!(c instanceof SectionLimit)) continue;
                limitConstraint = (SectionLimit)c;
                break;
            }
            if (limitConstraint == null) {
                limitConstraint = new SectionLimit(new DataProperties());
                limitConstraint.setModel(this.getModel());
            }
            ArrayList<Enrollment> notAvailableValues = new ArrayList<Enrollment>(values.size());
            List<Object> availableValues = new ArrayList(values.size());
            for (Object enrollment : values) {
                if (limitConstraint.inConflict((Enrollment)enrollment)) {
                    notAvailableValues.add((Enrollment)enrollment);
                    continue;
                }
                availableValues.add(enrollment);
            }
            if (!notAvailableValues.isEmpty() && this.iType.hasUnavailabilities()) {
                Double[] total2;
                Object s;
                HashMap<Object, Double[]> sections;
                Object s22;
                HashSet<CourseSection> ones;
                Object enrollment;
                ArrayList<Enrollment> notOverlappingEnrollments = new ArrayList<Enrollment>(values.size());
                enrollment = notAvailableValues.iterator();
                block3: while (enrollment.hasNext()) {
                    Enrollment enrollment2 = (Enrollment)enrollment.next();
                    for (Object other2 : request.getStudent().getRequests()) {
                        if (((Request)other2).equals(request) || ((Variable)other2).getAssignment() == null || other2 instanceof FreeTimeRequest || !((Enrollment)((Variable)other2).getAssignment()).isOverlapping(enrollment2)) continue;
                        continue block3;
                    }
                    notOverlappingEnrollments.add(enrollment2);
                }
                if (notOverlappingEnrollments.isEmpty() && availableValues.isEmpty() && this.iOverlapsAllEnrollments) {
                    double fraction = request.getWeight() / (double)notAvailableValues.size();
                    ones = new HashSet();
                    other2 = notAvailableValues.iterator();
                    while (other2.hasNext()) {
                        Enrollment enrollment3 = (Enrollment)other2.next();
                        boolean hasConflict = false;
                        for (Object s22 : enrollment3.getSections()) {
                            if (((Section)s22).getLimit() < 0 || !(((Section)s22).getEnrollmentWeight(request) + request.getWeight() > (double)((Section)s22).getLimit())) continue;
                            hasConflict = true;
                            break;
                        }
                        if ((sections = (Map)unavailabilities.get(enrollment3.getCourse())) == null) {
                            sections = new HashMap();
                            unavailabilities.put(enrollment3.getCourse(), sections);
                        }
                        s22 = enrollment3.getSections().iterator();
                        while (s22.hasNext()) {
                            s = s22.next();
                            if (hasConflict && ((Section)s).getLimit() < 0 || ((Section)s).getEnrollmentWeight(request) + request.getWeight() <= (double)((Section)s).getLimit()) continue;
                            total2 = (Double[])sections.get(s);
                            sections.put(s, new Double[]{fraction + (total2 == null ? 0.0 : total2[0]), total2 == null ? 0.0 : total2[1]});
                            ones.add(new CourseSection(enrollment3.getCourse(), (Section)s));
                        }
                        total = (Set)totals.get(enrollment3.getCourse());
                        if (total == null) {
                            total = new HashSet();
                            totals.put(enrollment3.getCourse(), (HashSet<Long>)total);
                        }
                        total.add(enrollment3.getStudent().getId());
                    }
                } else if (!notOverlappingEnrollments.isEmpty()) {
                    double fraction = request.getWeight() / (double)notOverlappingEnrollments.size();
                    ones = new HashSet<CourseSection>();
                    for (Enrollment enrollment3 : notOverlappingEnrollments) {
                        boolean hasConflict = false;
                        sections = enrollment3.getSections().iterator();
                        while (sections.hasNext()) {
                            s22 = sections.next();
                            if (((Section)s22).getLimit() < 0 || !(((Section)s22).getEnrollmentWeight(request) + request.getWeight() > (double)((Section)s22).getLimit())) continue;
                            hasConflict = true;
                            break;
                        }
                        if ((sections = (Map)unavailabilities.get(enrollment3.getCourse())) == null) {
                            sections = new HashMap<Object, Double[]>();
                            unavailabilities.put(enrollment3.getCourse(), sections);
                        }
                        s22 = enrollment3.getSections().iterator();
                        while (s22.hasNext()) {
                            s = s22.next();
                            if (hasConflict && ((Section)s).getLimit() < 0 || ((Section)s).getEnrollmentWeight(request) + request.getWeight() <= (double)((Section)s).getLimit()) continue;
                            total2 = (Double[])sections.get(s);
                            sections.put(s, new Double[]{fraction + (total2 == null ? 0.0 : total2[0]), total2 == null ? 0.0 : total2[1]});
                            ones.add(new CourseSection(enrollment3.getCourse(), (Section)s));
                        }
                        total = (Set)totals.get(enrollment3.getCourse());
                        if (total == null) {
                            total = new HashSet<Long>();
                            totals.put(enrollment3.getCourse(), (HashSet<Long>)total);
                        }
                        total.add(enrollment3.getStudent().getId());
                    }
                    other2 = ones.iterator();
                    while (other2.hasNext()) {
                        Comparable<CourseSection> section = (CourseSection)other2.next();
                        Map sections2 = (Map)unavailabilities.get(((CourseSection)section).getCourse());
                        Double[] total3 = (Double[])sections2.get(((CourseSection)section).getSection());
                        sections2.put(((CourseSection)section).getSection(), new Double[]{total3 == null ? 0.0 : (Double)total3[0], request.getWeight() + (total3 == null ? 0.0 : (Double)total3[1])});
                    }
                }
            }
            if (this.iOverlapsAllEnrollments) {
                availableValues = values;
            }
            if (availableValues.isEmpty() || !this.iType.hasOverlaps()) continue;
            ArrayList<Object> conflicts = new ArrayList<Object>();
            for (Enrollment enrollment2 : availableValues) {
                HashMap overlaps = new HashMap();
                other2 = request.getStudent().getRequests().iterator();
                while (other2.hasNext()) {
                    Enrollment otherEnrollment;
                    Request other3 = (Request)other2.next();
                    if (other3.equals(request) || other3.getAssignment() == null || other3 instanceof FreeTimeRequest || !enrollment2.isOverlapping(otherEnrollment = (Enrollment)other3.getAssignment())) continue;
                    for (Section a : enrollment2.getSections()) {
                        for (Section b : ((Enrollment)other3.getAssignment()).getSections()) {
                            if (a.getTime() == null || b.getTime() == null || a.isAllowOverlap() || b.isAllowOverlap() || a.isToIgnoreStudentConflictsWith(b.getId()) || !a.getTime().hasIntersection(b.getTime()) || this.canIgnore(enrollment2, a, availableValues)) continue;
                            ArrayList<CourseSection> x = (ArrayList<CourseSection>)overlaps.get(new CourseSection(enrollment2.getCourse(), a));
                            if (x == null) {
                                x = new ArrayList<CourseSection>();
                                overlaps.put(new CourseSection(enrollment2.getCourse(), a), x);
                            }
                            x.add(new CourseSection(((Enrollment)other3.getAssignment()).getCourse(), b));
                        }
                    }
                }
                if (overlaps.isEmpty()) continue;
                conflicts.add(overlaps);
                HashSet<Long> total4 = (HashSet<Long>)totals.get(enrollment2.getCourse());
                if (total4 == null) {
                    total4 = new HashSet<Long>();
                    totals.put(enrollment2.getCourse(), total4);
                }
                total4.add(enrollment2.getStudent().getId());
            }
            double fraction = request.getWeight() / (double)conflicts.size();
            for (Map overlaps : conflicts) {
                for (Map.Entry entry : overlaps.entrySet()) {
                    CourseSection a;
                    total = (Double)sectionOverlaps.get(a = (CourseSection)entry.getKey());
                    sectionOverlaps.put(a, fraction + (total == null ? 0.0 : (Double)total));
                    HashMap<CourseSection, Double> pair = (HashMap<CourseSection, Double>)conflictingPairs.get(a);
                    if (pair == null) {
                        pair = new HashMap<CourseSection, Double>();
                        conflictingPairs.put(a, pair);
                    }
                    Iterator<Object> iterator = ((List)entry.getValue()).iterator();
                    while (iterator.hasNext()) {
                        CourseSection b;
                        Double prev = (Double)pair.get(b = (CourseSection)iterator.next());
                        pair.put(b, fraction + (prev == null ? 0.0 : prev));
                    }
                }
            }
        }
        Comparator<Course> courseComparator = new Comparator<Course>(){

            @Override
            public int compare(Course a, Course b) {
                int cmp = a.getName().compareTo(b.getName());
                if (cmp != 0) {
                    return cmp;
                }
                return a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1);
            }
        };
        Comparator<Section> sectionComparator = new Comparator<Section>(){

            @Override
            public int compare(Section a, Section b) {
                int cmp = a.getSubpart().getConfig().getOffering().getName().compareTo(b.getSubpart().getConfig().getOffering().getName());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = a.getSubpart().getInstructionalType().compareTo(b.getSubpart().getInstructionalType());
                if (cmp != 0) {
                    return cmp;
                }
                return a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1);
            }
        };
        CSVFile csv = new CSVFile();
        ArrayList<CSVFile.CSVField> headers = new ArrayList<CSVFile.CSVField>();
        headers.add(new CSVFile.CSVField("Course"));
        headers.add(new CSVFile.CSVField("Total\nConflicts"));
        if (this.iType.hasUnavailabilities()) {
            headers.add(new CSVFile.CSVField("Course\nEnrollment"));
            headers.add(new CSVFile.CSVField("Course\nLimit"));
        }
        headers.add(new CSVFile.CSVField("Class"));
        headers.add(new CSVFile.CSVField("Meeting Time"));
        if (this.iType.hasUnavailabilities()) {
            headers.add(new CSVFile.CSVField("Availability\nConflicts"));
            headers.add(new CSVFile.CSVField("% of Total\nConflicts"));
        }
        if (this.iType.hasOverlaps()) {
            headers.add(new CSVFile.CSVField("Time\nConflicts"));
            headers.add(new CSVFile.CSVField("% of Total\nConflicts"));
        }
        if (this.iType.hasUnavailabilities()) {
            headers.add(new CSVFile.CSVField("Class\nEnrollment"));
            headers.add(new CSVFile.CSVField("Class\nLimit"));
            if (!this.iType.hasOverlaps()) {
                headers.add(new CSVFile.CSVField("Class\nPotential"));
            }
        }
        if (this.iType.hasOverlaps()) {
            headers.add(new CSVFile.CSVField("Conflicting\nClass"));
            headers.add(new CSVFile.CSVField("Conflicting\nMeeting Time"));
            headers.add(new CSVFile.CSVField("Joined\nConflicts"));
            headers.add(new CSVFile.CSVField("% of Total\nConflicts"));
        }
        csv.setHeader(headers);
        TreeSet<Course> courses = new TreeSet<Course>(courseComparator);
        courses.addAll(totals.keySet());
        for (Course course : courses) {
            Map sectionUnavailability = (Map)unavailabilities.get(course);
            Set total = (Set)totals.get(course);
            TreeSet<Section> sections = new TreeSet<Section>(sectionComparator);
            if (sectionUnavailability != null) {
                sections.addAll(sectionUnavailability.keySet());
            }
            for (Map.Entry entry : sectionOverlaps.entrySet()) {
                if (!course.equals(((CourseSection)entry.getKey()).getCourse())) continue;
                sections.add(((CourseSection)entry.getKey()).getSection());
            }
            boolean firstCourse = true;
            for (Comparable<CourseSection> section : sections) {
                Double[] sectionUnavailable = sectionUnavailability == null ? null : (Double[])sectionUnavailability.get(section);
                Double sectionOverlap = (Double)sectionOverlaps.get(new CourseSection(course, (Section)section));
                Map pair = (Map)conflictingPairs.get(new CourseSection(course, (Section)section));
                if (pair == null) {
                    ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                    line.add(new CSVFile.CSVField(firstCourse ? course.getName() : ""));
                    line.add(new CSVFile.CSVField(firstCourse ? Integer.valueOf(total.size()) : ""));
                    if (this.iType.hasUnavailabilities()) {
                        line.add(new CSVFile.CSVField(firstCourse ? sDF1.format(course.getEnrollmentWeight(null)) : ""));
                        line.add(new CSVFile.CSVField(firstCourse ? (course.getLimit() < 0 ? "" : String.valueOf(course.getLimit())) : ""));
                    }
                    line.add(new CSVFile.CSVField(((Section)section).getSubpart().getName() + " " + ((Section)section).getName(course.getId())));
                    line.add(new CSVFile.CSVField(((Section)section).getTime() == null ? "" : ((Section)section).getTime().getDayHeader() + " " + ((Section)section).getTime().getStartTimeHeader() + " - " + ((Section)section).getTime().getEndTimeHeader()));
                    if (this.iType.hasUnavailabilities()) {
                        line.add(new CSVFile.CSVField(sectionUnavailable != null ? sDF2.format(sectionUnavailable[0]) : ""));
                        line.add(new CSVFile.CSVField(sectionUnavailable != null ? sDF2.format(sectionUnavailable[0] / (double)total.size()) : ""));
                    }
                    if (this.iType.hasOverlaps()) {
                        line.add(new CSVFile.CSVField(sectionOverlap != null ? sDF2.format(sectionOverlap) : ""));
                        line.add(new CSVFile.CSVField(sectionOverlap != null ? sDF2.format(sectionOverlap / (double)total.size()) : ""));
                    }
                    if (this.iType.hasUnavailabilities()) {
                        line.add(new CSVFile.CSVField(sDF1.format(((Section)section).getEnrollmentWeight(null))));
                        line.add(new CSVFile.CSVField(((Section)section).getLimit() < 0 ? "" : String.valueOf(((Section)section).getLimit())));
                        if (!this.iType.hasOverlaps()) {
                            line.add(new CSVFile.CSVField(sectionUnavailable != null ? sDF1.format(sectionUnavailable[1]) : ""));
                        }
                    }
                    csv.addLine(line);
                } else {
                    boolean firstClass = true;
                    for (CourseSection other : new TreeSet(pair.keySet())) {
                        ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                        line.add(new CSVFile.CSVField(firstCourse && firstClass ? course.getName() : ""));
                        line.add(new CSVFile.CSVField(firstCourse && firstClass ? Integer.valueOf(total.size()) : ""));
                        if (this.iType.hasUnavailabilities()) {
                            line.add(new CSVFile.CSVField(firstCourse && firstClass ? sDF1.format(course.getEnrollmentWeight(null)) : ""));
                            line.add(new CSVFile.CSVField(firstCourse && firstClass ? (course.getLimit() < 0 ? "" : String.valueOf(course.getLimit())) : ""));
                        }
                        line.add(new CSVFile.CSVField(firstClass ? ((Section)section).getSubpart().getName() + " " + ((Section)section).getName(course.getId()) : ""));
                        line.add(new CSVFile.CSVField(firstClass ? (((Section)section).getTime() == null ? "" : ((Section)section).getTime().getDayHeader() + " " + ((Section)section).getTime().getStartTimeHeader() + " - " + ((Section)section).getTime().getEndTimeHeader()) : ""));
                        if (this.iType.hasUnavailabilities()) {
                            line.add(new CSVFile.CSVField(firstClass && sectionUnavailable != null ? sDF2.format(sectionUnavailable[0]) : ""));
                            line.add(new CSVFile.CSVField(sectionUnavailable != null ? sDF2.format(sectionUnavailable[0] / (double)total.size()) : ""));
                        }
                        line.add(new CSVFile.CSVField(firstClass && sectionOverlap != null ? sDF2.format(sectionOverlap) : ""));
                        line.add(new CSVFile.CSVField(firstClass && sectionOverlap != null ? sDF2.format(sectionOverlap / (double)total.size()) : ""));
                        if (this.iType.hasUnavailabilities()) {
                            line.add(new CSVFile.CSVField(firstClass ? sDF1.format(((Section)section).getEnrollmentWeight(null)) : ""));
                            line.add(new CSVFile.CSVField(firstClass ? (((Section)section).getLimit() < 0 ? "" : String.valueOf(((Section)section).getLimit())) : ""));
                        }
                        line.add(new CSVFile.CSVField(other.getCourse().getName() + " " + other.getSection().getSubpart().getName() + " " + other.getSection().getName(other.getCourse().getId())));
                        line.add(new CSVFile.CSVField(other.getSection().getTime().getDayHeader() + " " + other.getSection().getTime().getStartTimeHeader() + " - " + other.getSection().getTime().getEndTimeHeader()));
                        line.add(new CSVFile.CSVField(sDF2.format(pair.get(other))));
                        line.add(new CSVFile.CSVField(sDF2.format((Double)pair.get(other) / (double)total.size())));
                        csv.addLine(line);
                        firstClass = false;
                    }
                }
                firstCourse = false;
            }
            csv.addLine();
        }
        return csv;
    }

    @Override
    public CSVFile create(DataProperties properties) {
        this.iType = Type.valueOf(properties.getProperty("type", this.iType.name()));
        this.iOverlapsAllEnrollments = properties.getPropertyBoolean("overlapsIncludeAll", true);
        return this.createTable(properties.getPropertyBoolean("lastlike", false), properties.getPropertyBoolean("real", true));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        OVERLAPS(true, false),
        UNAVAILABILITIES(false, true),
        OVERLAPS_AND_UNAVAILABILITIES(true, true);

        boolean iOveralps;
        boolean iUnavailabilities;

        private Type(boolean overlaps, boolean unavailabilities) {
            this.iOveralps = overlaps;
            this.iUnavailabilities = unavailabilities;
        }

        public boolean hasOverlaps() {
            return this.iOveralps;
        }

        public boolean hasUnavailabilities() {
            return this.iUnavailabilities;
        }
    }
}

