/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.model;

import java.util.ArrayList;
import java.util.List;
import net.sf.cpsolver.coursett.model.TimeLocation;
import net.sf.cpsolver.studentsct.constraint.LinkedSections;
import net.sf.cpsolver.studentsct.model.AcademicAreaCode;
import net.sf.cpsolver.studentsct.model.CourseRequest;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.FreeTimeRequest;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Student
implements Comparable<Student> {
    private long iId;
    private String iExternalId = null;
    private String iName = null;
    private boolean iDummy = false;
    private List<Request> iRequests = new ArrayList<Request>();
    private List<AcademicAreaCode> iAcadAreaClassifs = new ArrayList<AcademicAreaCode>();
    private List<AcademicAreaCode> iMajors = new ArrayList<AcademicAreaCode>();
    private List<AcademicAreaCode> iMinors = new ArrayList<AcademicAreaCode>();
    private List<LinkedSections> iLinkedSections = new ArrayList<LinkedSections>();
    private String iStatus = null;
    private Long iEmailTimeStamp = null;

    public Student(long id) {
        this.iId = id;
    }

    public Student(long id, boolean dummy) {
        this.iId = id;
        this.iDummy = dummy;
    }

    public long getId() {
        return this.iId;
    }

    public void setId(long id) {
        this.iId = id;
    }

    public List<Request> getRequests() {
        return this.iRequests;
    }

    public int nrRequests() {
        int ret = 0;
        for (Request r : this.getRequests()) {
            if (r.isAlternative()) continue;
            ++ret;
        }
        return ret;
    }

    public int nrAlternativeRequests() {
        int ret = 0;
        for (Request r : this.getRequests()) {
            if (!r.isAlternative()) continue;
            ++ret;
        }
        return ret;
    }

    public boolean canAssign(Request request) {
        if (request.isAssigned()) {
            return true;
        }
        int alt = 0;
        boolean found = false;
        for (Request r : this.getRequests()) {
            boolean waitlist;
            if (r.equals(request)) {
                found = true;
            }
            boolean assigned = r.isAssigned() || r.equals(request);
            boolean course = r instanceof CourseRequest;
            boolean bl = waitlist = course && ((CourseRequest)r).isWaitlist();
            if (r.isAlternative()) {
                if (!assigned && (found || !waitlist)) continue;
                --alt;
                continue;
            }
            if (!course || waitlist || assigned) continue;
            ++alt;
        }
        return alt >= 0;
    }

    public boolean isComplete() {
        int nrRequests = 0;
        int nrAssignedRequests = 0;
        for (Request r : this.getRequests()) {
            if (!(r instanceof CourseRequest)) continue;
            if (!r.isAlternative()) {
                ++nrRequests;
            }
            if (!r.isAssigned()) continue;
            ++nrAssignedRequests;
        }
        return nrAssignedRequests == nrRequests;
    }

    public int nrAssignedRequests() {
        int nrAssignedRequests = 0;
        for (Request r : this.getRequests()) {
            if (!(r instanceof CourseRequest) || !r.isAssigned()) continue;
            ++nrAssignedRequests;
        }
        return nrAssignedRequests;
    }

    public String toString() {
        return (this.isDummy() ? "D" : "") + "S[" + this.getId() + "]";
    }

    public boolean isDummy() {
        return this.iDummy;
    }

    public void setDummy(boolean dummy) {
        this.iDummy = dummy;
    }

    public List<AcademicAreaCode> getAcademicAreaClasiffications() {
        return this.iAcadAreaClassifs;
    }

    public List<AcademicAreaCode> getMajors() {
        return this.iMajors;
    }

    public List<AcademicAreaCode> getMinors() {
        return this.iMinors;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Student)) {
            return false;
        }
        return this.getId() == ((Student)object).getId() && this.isDummy() == ((Student)object).isDummy();
    }

    public int hashCode() {
        return (int)(this.iId ^ this.iId >>> 32);
    }

    public int countFreeTimeOverlaps(Enrollment enrollment) {
        if (!enrollment.isCourseRequest()) {
            return 0;
        }
        int ret = 0;
        for (Section section : enrollment.getSections()) {
            TimeLocation time = section.getTime();
            if (time == null) continue;
            ret += this.countFreeTimeOverlaps(time);
        }
        return ret;
    }

    public int countFreeTimeOverlaps(TimeLocation time) {
        int ret = 0;
        for (Request r : this.iRequests) {
            TimeLocation freeTime;
            if (!(r instanceof FreeTimeRequest) || !time.hasIntersection(freeTime = ((FreeTimeRequest)r).getTime())) continue;
            ret += freeTime.nrSharedHours(time) * freeTime.nrSharedDays(time);
        }
        return ret;
    }

    public String getExternalId() {
        return this.iExternalId;
    }

    public void setExternalId(String externalId) {
        this.iExternalId = externalId;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public List<LinkedSections> getLinkedSections() {
        return this.iLinkedSections;
    }

    public String getStatus() {
        return this.iStatus;
    }

    public void setStatus(String status) {
        this.iStatus = status;
    }

    public Long getEmailTimeStamp() {
        return this.iEmailTimeStamp;
    }

    public void setEmailTimeStamp(Long emailTimeStamp) {
        this.iEmailTimeStamp = emailTimeStamp;
    }

    @Override
    public int compareTo(Student s) {
        if (this.isDummy()) {
            if (!s.isDummy()) {
                return 1;
            }
        } else if (s.isDummy()) {
            return -1;
        }
        return new Long(this.getId()).compareTo(s.getId());
    }
}

