/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.model;

import java.util.List;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.studentsct.model.Assignment;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Student;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Request
extends Variable<Request, Enrollment> {
    private long iId = -1L;
    private int iPriority = 0;
    private boolean iAlternative = false;
    private Student iStudent = null;
    private double iWeight = 1.0;
    public static boolean sCacheValues = false;

    public Request(long id, int priority, boolean alternative, Student student) {
        this.iId = id;
        this.iPriority = priority;
        this.iAlternative = alternative;
        this.iStudent = student;
        this.iStudent.getRequests().add(this);
    }

    @Override
    public long getId() {
        return this.iId;
    }

    public int getPriority() {
        return this.iPriority;
    }

    public void setPriority(int priority) {
        this.iPriority = priority;
    }

    public boolean isAlternative() {
        return this.iAlternative;
    }

    public Student getStudent() {
        return this.iStudent;
    }

    @Override
    public int compareTo(Request r) {
        if (this.getStudent().getId() == r.getStudent().getId()) {
            return this.isAlternative() != r.isAlternative() ? (this.isAlternative() ? 1 : -1) : (this.getPriority() < r.getPriority() ? -1 : 1);
        }
        return this.getStudent().compareTo(r.getStudent());
    }

    public abstract List<Enrollment> computeEnrollments();

    @Override
    public List<Enrollment> values() {
        List<Enrollment> values = super.values();
        if (values != null) {
            return values;
        }
        values = this.computeEnrollments();
        if (sCacheValues) {
            this.setValues(values);
        }
        return values;
    }

    @Override
    public void assign(long iteration, Enrollment enrollment) {
        super.assign(iteration, enrollment);
        for (Assignment a : enrollment.getAssignments()) {
            a.assigned(enrollment);
        }
        if (enrollment.getConfig() != null) {
            enrollment.getConfig().assigned(enrollment);
        }
        if (enrollment.getCourse() != null) {
            enrollment.getCourse().assigned(enrollment);
        }
        if (enrollment.getReservation() != null) {
            enrollment.getReservation().assigned(enrollment);
        }
    }

    @Override
    public void unassign(long iteration) {
        if (this.getAssignment() != null) {
            Enrollment enrollment = (Enrollment)this.getAssignment();
            for (Assignment a : enrollment.getAssignments()) {
                a.unassigned(enrollment);
            }
            if (enrollment.getConfig() != null) {
                enrollment.getConfig().unassigned(enrollment);
            }
            if (enrollment.getCourse() != null) {
                enrollment.getCourse().unassigned(enrollment);
            }
            if (enrollment.getReservation() != null) {
                enrollment.getReservation().unassigned(enrollment);
            }
        }
        super.unassign(iteration);
    }

    public abstract double getBound();

    public double getWeight() {
        return this.iWeight;
    }

    public void setWeight(double weight) {
        this.iWeight = weight;
    }

    public boolean isAssigned() {
        return this.getAssignment() != null;
    }

    @Override
    public int hashCode() {
        return (int)(this.iId ^ this.iId >>> 32 ^ this.getStudent().getId() ^ this.getStudent().getId() >>> 32);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Request)) {
            return false;
        }
        return this.getId() == ((Request)o).getId() && this.getStudent().getId() == ((Request)o).getStudent().getId();
    }
}

