/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.model;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.cpsolver.coursett.model.TimeLocation;
import net.sf.cpsolver.ifs.util.ToolBox;
import net.sf.cpsolver.studentsct.StudentSectioningModel;
import net.sf.cpsolver.studentsct.constraint.ConfigLimit;
import net.sf.cpsolver.studentsct.constraint.CourseLimit;
import net.sf.cpsolver.studentsct.constraint.SectionLimit;
import net.sf.cpsolver.studentsct.model.Assignment;
import net.sf.cpsolver.studentsct.model.Choice;
import net.sf.cpsolver.studentsct.model.Config;
import net.sf.cpsolver.studentsct.model.Course;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Section;
import net.sf.cpsolver.studentsct.model.Student;
import net.sf.cpsolver.studentsct.model.Subpart;
import net.sf.cpsolver.studentsct.reservation.Reservation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseRequest
extends Request {
    private static DecimalFormat sDF = new DecimalFormat("0.000");
    private List<Course> iCourses = null;
    private Set<Choice> iWaitlistedChoices = new HashSet<Choice>();
    private Set<Choice> iSelectedChoices = new HashSet<Choice>();
    private boolean iWaitlist = false;
    private Long iTimeStamp = null;
    private Double iCachedMinPenalty = null;
    private Double iCachedMaxPenalty = null;
    public static boolean sSameTimePrecise = false;
    private Map<Course, List<Reservation>> iReservations = null;

    public CourseRequest(long id, int priority, boolean alternative, Student student, List<Course> courses, boolean waitlist, Long timeStamp) {
        super(id, priority, alternative, student);
        this.iCourses = new ArrayList<Course>(courses);
        for (Course course : this.iCourses) {
            course.getRequests().add(this);
        }
        this.iWaitlist = waitlist;
        this.iTimeStamp = timeStamp;
    }

    public List<Course> getCourses() {
        return this.iCourses;
    }

    public Enrollment createEnrollment(Set<? extends Assignment> sections, Reservation reservation) {
        if (sections == null || sections.isEmpty()) {
            return null;
        }
        Config config = ((Section)sections.iterator().next()).getSubpart().getConfig();
        Course course = null;
        for (Course c : this.iCourses) {
            if (!c.getOffering().getConfigs().contains(config)) continue;
            course = c;
            break;
        }
        return new Enrollment(this, this.iCourses.indexOf(course), course, config, sections, reservation);
    }

    public Enrollment createEnrollment(Set<? extends Assignment> sections) {
        Enrollment ret = this.createEnrollment(sections, null);
        ret.guessReservation(true);
        return ret;
    }

    protected int getMaxDomainSize() {
        StudentSectioningModel model = (StudentSectioningModel)this.getModel();
        return model == null ? null : Integer.valueOf(model.getMaxDomainSize());
    }

    @Override
    public List<Enrollment> computeEnrollments() {
        ArrayList<Enrollment> ret = new ArrayList<Enrollment>();
        int idx = 0;
        for (Course course : this.iCourses) {
            for (Config config : course.getOffering().getConfigs()) {
                this.computeEnrollments(ret, idx, 0.0, course, config, new HashSet<Section>(), 0, false, false, false, false, this.getMaxDomainSize() <= 0 ? -1 : ret.size() + this.getMaxDomainSize());
            }
            ++idx;
        }
        return ret;
    }

    public List<Enrollment> computeRandomEnrollments(int limitEachConfig) {
        ArrayList<Enrollment> ret = new ArrayList<Enrollment>();
        int idx = 0;
        for (Course course : this.iCourses) {
            for (Config config : course.getOffering().getConfigs()) {
                this.computeEnrollments(ret, idx, 0.0, course, config, new HashSet<Section>(), 0, false, false, false, true, limitEachConfig <= 0 ? limitEachConfig : ret.size() + limitEachConfig);
            }
            ++idx;
        }
        return ret;
    }

    private boolean sameTimes(Set<Section> sections1, Set<Section> sections2) {
        for (Section s1 : sections1) {
            Section s2 = null;
            for (Section s : sections2) {
                if (!s.getSubpart().equals(s1.getSubpart())) continue;
                s2 = s;
                break;
            }
            if (s2 == null) {
                return false;
            }
            if (ToolBox.equals(s1.getTime(), s2.getTime())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void computeEnrollments(Collection<Enrollment> enrollments, int priority, double penalty, Course course, Config config, HashSet<Section> sections, int idx, boolean availableOnly, boolean skipSameTime, boolean selectedOnly, boolean random, int limit) {
        block44: {
            block42: {
                boolean bl;
                block43: {
                    if (limit > 0 && enrollments.size() >= limit) {
                        return;
                    }
                    if (idx == 0) {
                        boolean canOverLimit = false;
                        if (availableOnly && (this.getModel() == null || ((StudentSectioningModel)this.getModel()).getReservationCanAssignOverTheLimit())) {
                            for (Reservation r : this.getReservations(course)) {
                                if (!r.canAssignOverLimit() || !r.getConfigs().isEmpty() && !r.getConfigs().contains(config) || r.getReservedAvailableSpace(this) < this.getWeight()) continue;
                                canOverLimit = true;
                                break;
                            }
                        }
                        if (!canOverLimit) {
                            if (availableOnly && config.getLimit() >= 0 && ConfigLimit.getEnrollmentWeight(config, this) > (double)config.getLimit()) {
                                return;
                            }
                            if (availableOnly && course.getLimit() >= 0 && CourseLimit.getEnrollmentWeight(course, this) > (double)course.getLimit()) {
                                return;
                            }
                            if (config.getOffering().hasReservations()) {
                                boolean hasReservation = false;
                                boolean hasOtherReservation = false;
                                boolean hasConfigReservation = false;
                                boolean reservationMustBeUsed = false;
                                for (Reservation reservation : this.getReservations(course)) {
                                    if (reservation.mustBeUsed()) {
                                        reservationMustBeUsed = true;
                                    }
                                    if (availableOnly && reservation.getReservedAvailableSpace(this) < this.getWeight()) continue;
                                    if (reservation.getConfigs().isEmpty()) {
                                        hasReservation = true;
                                        continue;
                                    }
                                    if (reservation.getConfigs().contains(config)) {
                                        hasReservation = true;
                                        hasConfigReservation = true;
                                        continue;
                                    }
                                    hasOtherReservation = true;
                                }
                                if (!hasConfigReservation && config.getTotalUnreservedSpace() < this.getWeight()) {
                                    return;
                                }
                                if (!hasReservation && config.getOffering().getTotalUnreservedSpace() < this.getWeight()) {
                                    return;
                                }
                                if (hasOtherReservation && !hasReservation) {
                                    return;
                                }
                                if (availableOnly && !hasReservation && config.getOffering().getUnreservedSpace(this) < this.getWeight()) {
                                    return;
                                }
                                if (availableOnly && !hasConfigReservation && config.getUnreservedSpace(this) < this.getWeight()) {
                                    return;
                                }
                                if (!hasReservation && reservationMustBeUsed) {
                                    return;
                                }
                            }
                        }
                    }
                    if (config.getSubparts().size() != idx) break block42;
                    if (skipSameTime && sSameTimePrecise) {
                        boolean waitListedOrSelected = false;
                        if (!this.getSelectedChoices().isEmpty() || !this.getWaitlistedChoices().isEmpty()) {
                            for (Section section : sections) {
                                if (!this.isWaitlisted(section) && !this.isSelected(section)) continue;
                                waitListedOrSelected = true;
                                break;
                            }
                        }
                        if (!waitListedOrSelected) {
                            for (Enrollment enrollment : enrollments) {
                                if (!this.sameTimes(enrollment.getSections(), sections)) continue;
                                return;
                            }
                        }
                    }
                    if (config.getOffering().hasReservations()) break block43;
                    enrollments.add(new Enrollment(this, priority, null, config, new HashSet<Section>(sections), null));
                    break block44;
                }
                Enrollment e = new Enrollment(this, priority, null, config, new HashSet<Section>(sections), null);
                boolean mustHaveReservation = config.getOffering().getTotalUnreservedSpace() < this.getWeight();
                boolean mustHaveConfigReservation = config.getTotalUnreservedSpace() < this.getWeight();
                boolean mustHaveSectionReservation = false;
                for (Section section : sections) {
                    if (!(section.getTotalUnreservedSpace() < this.getWeight())) continue;
                    mustHaveSectionReservation = true;
                    break;
                }
                boolean canOverLimit = false;
                if (availableOnly && (this.getModel() == null || ((StudentSectioningModel)this.getModel()).getReservationCanAssignOverTheLimit())) {
                    for (Reservation reservation : this.getReservations(course)) {
                        if (!reservation.canAssignOverLimit() || !reservation.isIncluded(e) || reservation.getReservedAvailableSpace(this) < this.getWeight()) continue;
                        enrollments.add(new Enrollment(this, priority, null, config, new HashSet<Section>(sections), reservation));
                        canOverLimit = true;
                    }
                }
                if (canOverLimit) break block44;
                boolean bl2 = false;
                block6: for (Reservation r : availableOnly ? new TreeSet<Reservation>(this.getReservations(course)) : this.getReservations(course)) {
                    if (r.mustBeUsed()) {
                        bl = true;
                    }
                    if (!r.isIncluded(e) || availableOnly && r.getReservedAvailableSpace(this) < this.getWeight() || mustHaveConfigReservation && r.getConfigs().isEmpty()) continue;
                    if (mustHaveSectionReservation) {
                        for (Section s : sections) {
                            if (r.getSections(s.getSubpart()) != null || !(s.getTotalUnreservedSpace() < this.getWeight())) continue;
                            continue block6;
                        }
                    }
                    enrollments.add(new Enrollment(this, priority, null, config, new HashSet<Section>(sections), r));
                    if (!availableOnly) continue;
                    return;
                }
                if (mustHaveReservation || mustHaveConfigReservation || mustHaveSectionReservation || availableOnly && config.getOffering().getUnreservedSpace(this) < this.getWeight() || bl) break block44;
                enrollments.add(new Enrollment(this, (this.getReservations(course).isEmpty() ? 0 : 1) + priority, null, config, new HashSet<Section>(sections), null));
                break block44;
            }
            Subpart subpart = config.getSubparts().get(idx);
            HashSet<TimeLocation> times = skipSameTime ? new HashSet<TimeLocation>() : null;
            List<Section> sectionsThisSubpart = subpart.getSections();
            if (skipSameTime) {
                sectionsThisSubpart = new ArrayList<Section>(subpart.getSections());
                Collections.sort(sectionsThisSubpart);
            }
            ArrayList<Section> matchingSectionsThisSubpart = new ArrayList<Section>(subpart.getSections().size());
            boolean hasChildren = !subpart.getChildren().isEmpty();
            for (Section section : sectionsThisSubpart) {
                if (section.getParent() != null && !sections.contains(section.getParent()) || section.isOverlapping(sections) || selectedOnly && !this.isSelected(section)) continue;
                boolean canOverLimit = false;
                if (availableOnly && (this.getModel() == null || ((StudentSectioningModel)this.getModel()).getReservationCanAssignOverTheLimit())) {
                    for (Reservation r : this.getReservations(course)) {
                        if (!r.canAssignOverLimit() || r.getSections(subpart) != null && !r.getSections(subpart).contains(section) || r.getReservedAvailableSpace(this) < this.getWeight()) continue;
                        canOverLimit = true;
                        break;
                    }
                }
                if (!canOverLimit) {
                    if (availableOnly && section.getLimit() >= 0 && SectionLimit.getEnrollmentWeight(section, this) > (double)section.getLimit()) continue;
                    if (config.getOffering().hasReservations()) {
                        boolean hasReservation = false;
                        boolean hasSectionReservation = false;
                        boolean hasOtherReservation = false;
                        boolean reservationMustBeUsed = false;
                        for (Reservation r : this.getReservations(course)) {
                            if (r.mustBeUsed()) {
                                reservationMustBeUsed = true;
                            }
                            if (availableOnly && r.getReservedAvailableSpace(this) < this.getWeight()) continue;
                            if (r.getSections(subpart) == null) {
                                hasReservation = true;
                                continue;
                            }
                            if (r.getSections(subpart).contains(section)) {
                                hasReservation = true;
                                hasSectionReservation = true;
                                continue;
                            }
                            hasOtherReservation = true;
                        }
                        if (!hasSectionReservation && section.getTotalUnreservedSpace() < this.getWeight() || hasOtherReservation && !hasReservation || availableOnly && !hasSectionReservation && section.getUnreservedSpace(this) < this.getWeight() || !hasReservation && reservationMustBeUsed) continue;
                    }
                }
                if (skipSameTime && section.getTime() != null && !hasChildren && !times.add(section.getTime()) && !this.isSelected(section) && !this.isWaitlisted(section)) continue;
                matchingSectionsThisSubpart.add(section);
            }
            if (random || limit > 0) {
                Collections.shuffle(sectionsThisSubpart);
            }
            boolean bl = false;
            for (Section section : matchingSectionsThisSubpart) {
                void var19_36;
                sections.add(section);
                this.computeEnrollments(enrollments, priority, penalty + section.getPenalty(), course, config, sections, idx + 1, availableOnly, skipSameTime, selectedOnly, random, limit < 0 ? limit : Math.max(1, limit * (1 + var19_36) / matchingSectionsThisSubpart.size()));
                sections.remove(section);
                ++var19_36;
            }
        }
    }

    public List<Enrollment> getAvaiableEnrollments() {
        ArrayList<Enrollment> ret = new ArrayList<Enrollment>();
        int idx = 0;
        for (Course course : this.iCourses) {
            for (Config config : course.getOffering().getConfigs()) {
                this.computeEnrollments(ret, idx, 0.0, course, config, new HashSet<Section>(), 0, true, false, false, false, this.getMaxDomainSize() <= 0 ? -1 : ret.size() + this.getMaxDomainSize());
            }
            ++idx;
        }
        return ret;
    }

    public List<Enrollment> getSelectedEnrollments(boolean availableOnly) {
        if (this.getSelectedChoices().isEmpty()) {
            return null;
        }
        Choice firstChoice = this.getSelectedChoices().iterator().next();
        ArrayList<Enrollment> enrollments = new ArrayList<Enrollment>();
        for (Course course : this.iCourses) {
            if (!course.getOffering().equals(firstChoice.getOffering())) continue;
            for (Config config : course.getOffering().getConfigs()) {
                this.computeEnrollments(enrollments, 0, 0.0, course, config, new HashSet<Section>(), 0, availableOnly, false, true, false, -1);
            }
        }
        return enrollments;
    }

    public List<Enrollment> getAvaiableEnrollmentsSkipSameTime() {
        ArrayList<Enrollment> ret = new ArrayList<Enrollment>();
        if (this.getInitialAssignment() != null) {
            ret.add((Enrollment)this.getInitialAssignment());
        }
        int idx = 0;
        for (Course course : this.iCourses) {
            for (Config config : course.getOffering().getConfigs()) {
                this.computeEnrollments(ret, idx, 0.0, course, config, new HashSet<Section>(), 0, true, true, false, false, this.getMaxDomainSize() <= 0 ? -1 : ret.size() + this.getMaxDomainSize());
            }
            ++idx;
        }
        return ret;
    }

    public List<Enrollment> getEnrollmentsSkipSameTime() {
        ArrayList<Enrollment> ret = new ArrayList<Enrollment>();
        int idx = 0;
        for (Course course : this.iCourses) {
            for (Config config : course.getOffering().getConfigs()) {
                this.computeEnrollments(ret, idx, 0.0, course, config, new HashSet<Section>(), 0, false, true, false, false, this.getMaxDomainSize() <= 0 ? -1 : ret.size() + this.getMaxDomainSize());
            }
            ++idx;
        }
        return ret;
    }

    public Set<Choice> getWaitlistedChoices() {
        return this.iWaitlistedChoices;
    }

    public boolean isWaitlisted(Section section) {
        return this.iWaitlistedChoices.contains(section.getChoice());
    }

    public Set<Choice> getSelectedChoices() {
        return this.iSelectedChoices;
    }

    public boolean isSelected(Section section) {
        return this.iSelectedChoices.contains(section.getChoice());
    }

    @Override
    public String getName() {
        String ret = (this.isAlternative() ? "A" : "") + (1 + this.getPriority() + (this.isAlternative() ? -this.getStudent().nrRequests() : 0)) + ". " + (this.isWaitlist() ? "(w) " : "");
        int idx = 0;
        for (Course course : this.iCourses) {
            ret = idx == 0 ? ret + course.getName() : ret + ", " + idx + ". alt " + course.getName();
            ++idx;
        }
        return ret;
    }

    public boolean isWaitlist() {
        return this.iWaitlist;
    }

    public void setWaitlist(boolean waitlist) {
        this.iWaitlist = waitlist;
    }

    public Long getTimeStamp() {
        return this.iTimeStamp;
    }

    @Override
    public String toString() {
        return this.getName() + (this.getWeight() != 1.0 ? " (W:" + sDF.format(this.getWeight()) + ")" : "");
    }

    public Course getCourse(long courseId) {
        for (Course course : this.iCourses) {
            if (course.getId() != courseId) continue;
            return course;
        }
        return null;
    }

    public Config getConfig(long configId) {
        for (Course course : this.iCourses) {
            for (Config config : course.getOffering().getConfigs()) {
                if (config.getId() != configId) continue;
                return config;
            }
        }
        return null;
    }

    public Subpart getSubpart(long subpartId) {
        for (Course course : this.iCourses) {
            for (Config config : course.getOffering().getConfigs()) {
                for (Subpart subpart : config.getSubparts()) {
                    if (subpart.getId() != subpartId) continue;
                    return subpart;
                }
            }
        }
        return null;
    }

    public Section getSection(long sectionId) {
        for (Course course : this.iCourses) {
            for (Config config : course.getOffering().getConfigs()) {
                for (Subpart subpart : config.getSubparts()) {
                    for (Section section : subpart.getSections()) {
                        if (section.getId() != sectionId) continue;
                        return section;
                    }
                }
            }
        }
        return null;
    }

    public double getMinPenalty() {
        if (this.iCachedMinPenalty == null) {
            double min = Double.MAX_VALUE;
            for (Course course : this.iCourses) {
                min = Math.min(min, course.getOffering().getMinPenalty());
            }
            this.iCachedMinPenalty = new Double(min);
        }
        return this.iCachedMinPenalty;
    }

    public double getMaxPenalty() {
        if (this.iCachedMaxPenalty == null) {
            double max = Double.MIN_VALUE;
            for (Course course : this.iCourses) {
                max = Math.max(max, course.getOffering().getMaxPenalty());
            }
            this.iCachedMaxPenalty = new Double(max);
        }
        return this.iCachedMaxPenalty;
    }

    public void clearCache() {
        this.iCachedMaxPenalty = null;
        this.iCachedMinPenalty = null;
    }

    @Override
    public double getBound() {
        return -this.getWeight() * ((StudentSectioningModel)this.getModel()).getStudentWeights().getBound(this);
    }

    @Override
    public boolean isAssigned() {
        return this.getAssignment() != null && !((Enrollment)this.getAssignment()).getAssignments().isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && o instanceof CourseRequest;
    }

    public List<Reservation> getReservations(Course course) {
        List<Reservation> reservations;
        if (this.iReservations == null) {
            this.iReservations = new HashMap<Course, List<Reservation>>();
        }
        if ((reservations = this.iReservations.get(course)) == null) {
            reservations = new ArrayList<Reservation>();
            boolean mustBeUsed = false;
            for (Reservation r : course.getOffering().getReservations()) {
                if (!r.isApplicable(this.getStudent())) continue;
                if (!mustBeUsed && r.mustBeUsed()) {
                    reservations.clear();
                    mustBeUsed = true;
                }
                if (mustBeUsed && !r.mustBeUsed()) continue;
                reservations.add(r);
            }
            this.iReservations.put(course, reservations);
        }
        return reservations;
    }

    public boolean hasReservations() {
        for (Course course : this.getCourses()) {
            if (this.getReservations(course).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void clearReservationCache() {
        if (this.iReservations != null) {
            this.iReservations.clear();
        }
    }
}

