/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sf.cpsolver.studentsct.model.CourseRequest;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Offering;
import net.sf.cpsolver.studentsct.model.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Course {
    private long iId = -1L;
    private String iSubjectArea = null;
    private String iCourseNumber = null;
    private Offering iOffering = null;
    private int iLimit = 0;
    private int iProjected = 0;
    private double iEnrollmentWeight = 0.0;
    private Set<Enrollment> iEnrollments = new HashSet<Enrollment>();
    private Set<CourseRequest> iRequests = Collections.synchronizedSet(new HashSet());
    private String iNote = null;

    public Course(long id, String subjectArea, String courseNumber, Offering offering) {
        this.iId = id;
        this.iSubjectArea = subjectArea;
        this.iCourseNumber = courseNumber;
        this.iOffering = offering;
        this.iOffering.getCourses().add(this);
    }

    public Course(long id, String subjectArea, String courseNumber, Offering offering, int limit, int projected) {
        this.iId = id;
        this.iSubjectArea = subjectArea;
        this.iCourseNumber = courseNumber;
        this.iOffering = offering;
        this.iOffering.getCourses().add(this);
        this.iLimit = limit;
        this.iProjected = projected;
    }

    public long getId() {
        return this.iId;
    }

    public String getSubjectArea() {
        return this.iSubjectArea;
    }

    public String getCourseNumber() {
        return this.iCourseNumber;
    }

    public String getName() {
        return this.iSubjectArea + " " + this.iCourseNumber;
    }

    public String toString() {
        return this.getName();
    }

    public Offering getOffering() {
        return this.iOffering;
    }

    public int getLimit() {
        return this.iLimit;
    }

    public void setLimit(int limit) {
        this.iLimit = limit;
    }

    public int getProjected() {
        return this.iProjected;
    }

    public void assigned(Enrollment enrollment) {
        this.iEnrollments.add(enrollment);
        this.iEnrollmentWeight += enrollment.getRequest().getWeight();
    }

    public void unassigned(Enrollment enrollment) {
        this.iEnrollments.remove(enrollment);
        this.iEnrollmentWeight -= enrollment.getRequest().getWeight();
    }

    public double getEnrollmentWeight(Request excludeRequest) {
        double weight = this.iEnrollmentWeight;
        if (excludeRequest != null && excludeRequest.getAssignment() != null && this.iEnrollments.contains(excludeRequest.getAssignment())) {
            weight -= excludeRequest.getWeight();
        }
        return weight;
    }

    public Set<Enrollment> getEnrollments() {
        return this.iEnrollments;
    }

    public Set<CourseRequest> getRequests() {
        return this.iRequests;
    }

    public String getNote() {
        return this.iNote;
    }

    public void setNote(String note) {
        this.iNote = note;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Course)) {
            return false;
        }
        return this.getId() == ((Course)o).getId();
    }

    public int hashCode() {
        return (int)(this.iId ^ this.iId >>> 32);
    }
}

