/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.heuristics.selection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.ifs.heuristics.NeighbourSelection;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.JProf;
import net.sf.cpsolver.ifs.util.Progress;
import net.sf.cpsolver.studentsct.StudentSectioningModel;
import net.sf.cpsolver.studentsct.heuristics.selection.ProblemStudentsProvider;
import net.sf.cpsolver.studentsct.heuristics.studentord.StudentChoiceRealFirstOrder;
import net.sf.cpsolver.studentsct.heuristics.studentord.StudentOrder;
import net.sf.cpsolver.studentsct.model.CourseRequest;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Student;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwapStudentSelection
implements NeighbourSelection<Request, Enrollment>,
ProblemStudentsProvider {
    private static Logger sLog = Logger.getLogger(SwapStudentSelection.class);
    private Set<Student> iProblemStudents = new HashSet<Student>();
    private Student iStudent = null;
    private Iterator<Student> iStudentsEnumeration = null;
    private int iTimeout = 5000;
    private int iMaxValues = 100;
    public static boolean sDebug = false;
    protected StudentOrder iOrder = new StudentChoiceRealFirstOrder();

    public SwapStudentSelection(DataProperties properties) {
        this.iTimeout = properties.getPropertyInt("Neighbour.SwapStudentsTimeout", this.iTimeout);
        this.iMaxValues = properties.getPropertyInt("Neighbour.SwapStudentsMaxValues", this.iMaxValues);
        if (properties.getProperty("Neighbour.SwapStudentsOrder") != null) {
            try {
                this.iOrder = (StudentOrder)Class.forName(properties.getProperty("Neighbour.SwapStudentsOrder")).getConstructor(DataProperties.class).newInstance(properties);
            }
            catch (Exception e) {
                sLog.error((Object)("Unable to set student order, reason:" + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        List<Student> students = this.iOrder.order(((StudentSectioningModel)solver.currentSolution().getModel()).getStudents());
        this.iStudentsEnumeration = students.iterator();
        this.iProblemStudents.clear();
        Progress.getInstance(solver.currentSolution().getModel()).setPhase("Student swap...", students.size());
    }

    @Override
    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        if (this.iStudent != null && !this.iStudent.isComplete()) {
            Selection selection = this.getSelection(this.iStudent);
            SwapStudentNeighbour neighbour = selection.select();
            if (neighbour != null) {
                return neighbour;
            }
            this.iProblemStudents.addAll(selection.getProblemStudents());
        }
        this.iStudent = null;
        while (this.iStudentsEnumeration.hasNext()) {
            Student student = this.iStudentsEnumeration.next();
            Progress.getInstance(solution.getModel()).incProgress();
            if (student.isComplete() || student.nrAssignedRequests() == 0) continue;
            Selection selection = this.getSelection(student);
            SwapStudentNeighbour neighbour = selection.select();
            if (neighbour != null) {
                this.iStudent = student;
                return neighbour;
            }
            this.iProblemStudents.addAll(selection.getProblemStudents());
        }
        return null;
    }

    @Override
    public Set<Student> getProblemStudents() {
        return this.iProblemStudents;
    }

    public Selection getSelection(Student student) {
        return new Selection(student);
    }

    public static Enrollment bestSwap(Enrollment conflict, Enrollment enrl, Set<Student> problematicStudents) {
        Enrollment bestEnrollment = null;
        double bestValue = 0.0;
        for (Enrollment enrollment : conflict.getRequest().values()) {
            if (((Request)conflict.variable()).getModel().inConflict(enrollment)) continue;
            double value = enrollment.toDouble();
            if (bestEnrollment != null && !(bestValue > value)) continue;
            bestEnrollment = enrollment;
            bestValue = value;
        }
        if (bestEnrollment == null && problematicStudents != null) {
            boolean added = false;
            for (Enrollment enrollment : conflict.getRequest().values()) {
                Set<Enrollment> conflicts = ((Request)conflict.variable()).getModel().conflictValues(enrollment);
                for (Enrollment c : conflicts) {
                    if (enrl.getStudent().isDummy() && !c.getStudent().isDummy() || enrl.getStudent().equals(c.getStudent()) || conflict.getStudent().equals(c.getStudent())) continue;
                    problematicStudents.add(c.getStudent());
                }
            }
            if (!added && !enrl.getStudent().equals(conflict.getStudent())) {
                problematicStudents.add(conflict.getStudent());
            }
        }
        return bestEnrollment;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SwapStudentNeighbour
    extends Neighbour<Request, Enrollment> {
        private double iValue;
        private Enrollment iEnrollment;
        private List<Enrollment> iSwaps;

        public SwapStudentNeighbour(double value, Enrollment enrollment, List<Enrollment> swaps) {
            this.iValue = value;
            this.iEnrollment = enrollment;
            this.iSwaps = swaps;
        }

        @Override
        public double value() {
            return this.iValue;
        }

        @Override
        public void assign(long iteration) {
            if (((Request)this.iEnrollment.variable()).getAssignment() != null) {
                ((Request)this.iEnrollment.variable()).unassign(iteration);
            }
            for (Enrollment swap : this.iSwaps) {
                ((Request)swap.variable()).unassign(iteration);
            }
            ((Request)this.iEnrollment.variable()).assign(iteration, this.iEnrollment);
            for (Enrollment swap : this.iSwaps) {
                ((Request)swap.variable()).assign(iteration, swap);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("SwSt{");
            sb.append(" " + this.iEnrollment.getRequest().getStudent());
            sb.append(" (" + this.iValue + ")");
            sb.append("\n " + this.iEnrollment.getRequest());
            sb.append(" " + this.iEnrollment);
            for (Enrollment swap : this.iSwaps) {
                sb.append("\n " + swap.getRequest());
                sb.append(" " + ((Request)swap.variable()).getAssignment());
                sb.append(" -> " + swap);
            }
            sb.append("\n}");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Selection {
        private Student iStudent;
        private long iT0;
        private long iT1;
        private boolean iTimeoutReached;
        private Enrollment iBestEnrollment;
        private double iBestValue;
        private Set<Student> iProblemStudents;
        private List<Enrollment> iBestSwaps;

        public Selection(Student student) {
            this.iStudent = student;
        }

        public SwapStudentNeighbour select() {
            if (sDebug) {
                sLog.debug((Object)("select(S" + this.iStudent.getId() + ")"));
            }
            this.iT0 = JProf.currentTimeMillis();
            this.iTimeoutReached = false;
            this.iBestEnrollment = null;
            this.iProblemStudents = new HashSet<Student>();
            Double initialValue = null;
            block0: for (Request request : this.iStudent.getRequests()) {
                if (initialValue == null) {
                    initialValue = request.getModel().getTotalValue();
                }
                if (SwapStudentSelection.this.iTimeout > 0 && JProf.currentTimeMillis() - this.iT0 > (long)SwapStudentSelection.this.iTimeout) {
                    if (this.iTimeoutReached) break;
                    if (sDebug) {
                        sLog.debug((Object)"  -- timeout reached");
                    }
                    this.iTimeoutReached = true;
                    break;
                }
                if (request.getAssignment() != null || !this.iStudent.canAssign(request)) continue;
                if (sDebug) {
                    sLog.debug((Object)("  -- checking request " + request));
                }
                List<Enrollment> values = null;
                values = SwapStudentSelection.this.iMaxValues > 0 && request instanceof CourseRequest ? ((CourseRequest)request).computeRandomEnrollments(SwapStudentSelection.this.iMaxValues) : request.values();
                for (Enrollment enrollment : values) {
                    Set<Enrollment> conflicts;
                    if (SwapStudentSelection.this.iTimeout > 0 && JProf.currentTimeMillis() - this.iT0 > (long)SwapStudentSelection.this.iTimeout) {
                        if (this.iTimeoutReached) continue block0;
                        if (sDebug) {
                            sLog.debug((Object)"  -- timeout reached");
                        }
                        this.iTimeoutReached = true;
                        continue block0;
                    }
                    if (sDebug) {
                        sLog.debug((Object)("      -- enrollment " + enrollment));
                    }
                    if ((conflicts = ((Request)enrollment.variable()).getModel().conflictValues(enrollment)).contains(enrollment)) continue;
                    double bound = enrollment.toDouble();
                    for (Enrollment conflict : conflicts) {
                        bound += ((Request)conflict.variable()).getBound();
                    }
                    if (this.iBestEnrollment != null && bound >= this.iBestValue) continue;
                    for (Enrollment conflict : conflicts) {
                        ((Request)conflict.variable()).unassign(0L);
                    }
                    ((Request)enrollment.variable()).assign(0L, enrollment);
                    boolean allResolved = true;
                    ArrayList<Enrollment> swaps = new ArrayList<Enrollment>(conflicts.size());
                    for (Enrollment conflict : conflicts) {
                        Enrollment other;
                        if (sDebug) {
                            sLog.debug((Object)("        -- conflict " + conflict));
                        }
                        if ((other = SwapStudentSelection.bestSwap(conflict, enrollment, this.iProblemStudents)) == null) {
                            if (sDebug) {
                                sLog.debug((Object)"          -- unable to resolve");
                            }
                            allResolved = false;
                            break;
                        }
                        ((Request)other.variable()).assign(0L, other);
                        swaps.add(other);
                        if (!sDebug) continue;
                        sLog.debug((Object)("          -- can be resolved by switching to " + other.getName()));
                    }
                    double value = request.getModel().getTotalValue() - initialValue;
                    for (Enrollment other : swaps) {
                        ((Request)other.variable()).unassign(0L);
                    }
                    ((Request)enrollment.variable()).unassign(0L);
                    for (Enrollment conflict : conflicts) {
                        ((Request)conflict.variable()).assign(0L, conflict);
                    }
                    if (!allResolved || !(value <= 0.0) || this.iBestEnrollment != null && !(this.iBestValue > value)) continue;
                    this.iBestEnrollment = enrollment;
                    this.iBestValue = value;
                    this.iBestSwaps = swaps;
                }
            }
            this.iT1 = JProf.currentTimeMillis();
            if (sDebug) {
                sLog.debug((Object)("  -- done, best enrollment is " + this.iBestEnrollment));
            }
            if (this.iBestEnrollment == null) {
                if (this.iProblemStudents.isEmpty()) {
                    this.iProblemStudents.add(this.iStudent);
                }
                if (sDebug) {
                    sLog.debug((Object)("  -- problem students are: " + this.iProblemStudents));
                }
                return null;
            }
            if (sDebug) {
                sLog.debug((Object)("  -- value " + this.iBestValue));
            }
            Enrollment[] assignment = new Enrollment[this.iStudent.getRequests().size()];
            int idx = 0;
            for (Request request : this.iStudent.getRequests()) {
                assignment[idx++] = this.iBestEnrollment.getRequest().equals(request) ? this.iBestEnrollment : (Enrollment)request.getAssignment();
            }
            return new SwapStudentNeighbour(this.iBestValue, this.iBestEnrollment, this.iBestSwaps);
        }

        public boolean isTimeoutReached() {
            return this.iTimeoutReached;
        }

        public long getTime() {
            return this.iT1 - this.iT0;
        }

        public Enrollment getBestEnrollment() {
            return this.iBestEnrollment;
        }

        public double getBestValue() {
            return this.iBestValue;
        }

        public Set<Student> getProblemStudents() {
            return this.iProblemStudents;
        }
    }
}

