/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.heuristics.selection;

import java.util.List;
import net.sf.cpsolver.ifs.heuristics.NeighbourSelection;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.Progress;
import net.sf.cpsolver.ifs.util.ToolBox;
import net.sf.cpsolver.studentsct.StudentSectioningModel;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Student;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomUnassignmentSelection
implements NeighbourSelection<Request, Enrollment> {
    private List<Student> iStudents = null;
    protected double iRandom = 0.5;

    public RandomUnassignmentSelection(DataProperties properties) {
        this.iRandom = properties.getPropertyDouble("Neighbour.RandomUnassignmentProb", this.iRandom);
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        this.iStudents = ((StudentSectioningModel)solver.currentSolution().getModel()).getStudents();
        Progress.getInstance(solver.currentSolution().getModel()).setPhase("Random unassignment...", 1L);
    }

    @Override
    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        if (Math.random() < this.iRandom) {
            Student student = ToolBox.random(this.iStudents);
            return new UnassignStudentNeighbour(student);
        }
        Progress.getInstance(solution.getModel()).incProgress();
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnassignStudentNeighbour
    extends Neighbour<Request, Enrollment> {
        private Student iStudent = null;

        public UnassignStudentNeighbour(Student student) {
            this.iStudent = student;
        }

        @Override
        public double value() {
            double val = 0.0;
            for (Request request : this.iStudent.getRequests()) {
                if (request.getAssignment() == null) continue;
                val -= ((Enrollment)request.getAssignment()).toDouble();
            }
            return val;
        }

        @Override
        public void assign(long iteration) {
            for (Request request : this.iStudent.getRequests()) {
                if (request.getAssignment() == null) continue;
                request.unassign(iteration);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Un{");
            sb.append(" " + this.iStudent);
            sb.append(" }");
            return sb.toString();
        }
    }
}

