/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.heuristics.selection;

import java.util.ArrayList;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.studentsct.StudentPreferencePenalties;
import net.sf.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import net.sf.cpsolver.studentsct.model.Config;
import net.sf.cpsolver.studentsct.model.Course;
import net.sf.cpsolver.studentsct.model.CourseRequest;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Section;
import net.sf.cpsolver.studentsct.model.Student;
import net.sf.cpsolver.studentsct.model.Subpart;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnlineSelection
extends BranchBoundSelection {
    private static Logger sLog = Logger.getLogger(OnlineSelection.class);
    private int iDistributionType = -1;
    private double iEpsilon = 0.05;
    private boolean iUsePenalties = true;
    private boolean iUseStudentPrefPenalties = false;
    private BranchBoundSelection iBranchBound = null;

    public OnlineSelection(DataProperties properties) {
        super(properties);
        this.iUseStudentPrefPenalties = properties.getPropertyBoolean("Sectioning.UseStudentPreferencePenalties", this.iUseStudentPrefPenalties);
        this.iDistributionType = properties.getPropertyInt("Sectioning.Distribution", StudentPreferencePenalties.sDistTypePreference);
        this.iEpsilon = properties.getPropertyDouble("Sectioning.Epsilon", this.iEpsilon);
        this.iUsePenalties = properties.getPropertyBoolean("Sectioning.UseOnlinePenalties", this.iUsePenalties);
        if (this.iUseStudentPrefPenalties && !properties.containsPropery("Sectioning.UseOnlinePenalties")) {
            this.iUsePenalties = false;
        }
        if (this.iUsePenalties || !this.iUseStudentPrefPenalties) {
            this.iBranchBound = new BranchBoundSelection(properties);
        }
        this.iMinimizePenalty = true;
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        this.init(solver, "Online...");
    }

    public boolean isUseStudentPrefPenalties() {
        return this.iUseStudentPrefPenalties;
    }

    public boolean isUsePenalties() {
        return this.iUsePenalties;
    }

    private static void setPenalties(Student student) {
        for (Request request : student.getRequests()) {
            if (!(request instanceof CourseRequest)) continue;
            CourseRequest courseRequest = (CourseRequest)request;
            for (Course course : courseRequest.getCourses()) {
                for (Config config : course.getOffering().getConfigs()) {
                    for (Subpart subpart : config.getSubparts()) {
                        for (Section section : subpart.getSections()) {
                            section.setPenalty(section.getOnlineSectioningPenalty());
                        }
                    }
                }
            }
            courseRequest.clearCache();
        }
    }

    public void updateSpace(Student student) {
        for (Request request : student.getRequests()) {
            if (!(request instanceof CourseRequest)) continue;
            CourseRequest courseRequest = (CourseRequest)request;
            if (courseRequest.getAssignment() == null) {
                return;
            }
            Enrollment enrollment = (Enrollment)courseRequest.getAssignment();
            for (Section section : enrollment.getSections()) {
                section.setSpaceHeld(section.getSpaceHeld() - courseRequest.getWeight());
            }
            ArrayList<Enrollment> feasibleEnrollments = new ArrayList<Enrollment>();
            for (Enrollment enrl : courseRequest.values()) {
                boolean overlaps = false;
                for (Request otherRequest : courseRequest.getStudent().getRequests()) {
                    Enrollment otherErollment;
                    if (otherRequest.equals(courseRequest) || !(otherRequest instanceof CourseRequest) || (otherErollment = (Enrollment)otherRequest.getAssignment()) == null || !enrl.isOverlapping(otherErollment)) continue;
                    overlaps = true;
                    break;
                }
                if (overlaps) continue;
                feasibleEnrollments.add(enrl);
            }
            double d = courseRequest.getWeight() / (double)feasibleEnrollments.size();
            for (Enrollment feasibleEnrollment : feasibleEnrollments) {
                for (Section section3 : feasibleEnrollment.getSections()) {
                    section3.setSpaceExpected(section3.getSpaceExpected() - d);
                }
            }
        }
    }

    @Override
    public BranchBoundSelection.Selection getSelection(Student student) {
        if (this.iUsePenalties) {
            OnlineSelection.setPenalties(student);
        }
        BranchBoundSelection.Selection selection = null;
        if (this.iBranchBound != null) {
            selection = this.iBranchBound.getSelection(student);
        }
        if (this.iUseStudentPrefPenalties) {
            selection = new EpsilonSelection(student, selection);
        }
        return selection;
    }

    public class EpsilonSelection
    extends BranchBoundSelection.Selection {
        private StudentPreferencePenalties iPenalties;
        private BranchBoundSelection.Selection iSelection;

        public EpsilonSelection(Student student, BranchBoundSelection.Selection selection) {
            super(student);
            this.iPenalties = null;
            this.iSelection = null;
            this.iPenalties = new StudentPreferencePenalties(OnlineSelection.this.iDistributionType);
            this.iSelection = selection;
        }

        public BranchBoundSelection.BranchBoundNeighbour select() {
            BranchBoundSelection.BranchBoundNeighbour neighbour;
            BranchBoundSelection.BranchBoundNeighbour onlineSelection = null;
            if (this.iSelection != null) {
                onlineSelection = this.iSelection.select();
                if (BranchBoundSelection.sDebug) {
                    sLog.debug((Object)("Online: " + onlineSelection));
                }
            }
            if ((neighbour = super.select()) != null) {
                return neighbour;
            }
            if (onlineSelection != null) {
                return onlineSelection;
            }
            return null;
        }

        protected double getAssignmentPenalty(int i) {
            return this.iPenalties.getPenalty(this.iAssignment[i]) + OnlineSelection.this.iDistConfWeight * (double)this.getDistanceConflicts(i).size();
        }

        public boolean isAllowed(int idx, Enrollment enrollment) {
            double limit;
            if (this.iSelection == null || this.iSelection.getBestAssignment() == null || this.iSelection.getBestAssignment()[idx] == null) {
                return true;
            }
            double bestPenalty = this.iSelection.getBestAssignment()[idx].getPenalty();
            double d = OnlineSelection.this.iEpsilon < 0.0 ? Math.max(0.0, bestPenalty) : (limit = (bestPenalty < 0.0 ? 1.0 - OnlineSelection.this.iEpsilon : 1.0 + OnlineSelection.this.iEpsilon) * bestPenalty);
            if (enrollment.getPenalty() > limit) {
                if (BranchBoundSelection.sDebug) {
                    sLog.debug((Object)("  -- enrollment " + enrollment + " was filtered out " + "(penalty=" + enrollment.getPenalty() + ", best=" + bestPenalty + ", limit=" + limit + ")"));
                }
                return false;
            }
            return true;
        }

        public Enrollment firstConflict(int idx, Enrollment enrollment) {
            Enrollment conflict = super.firstConflict(idx, enrollment);
            if (conflict != null) {
                return conflict;
            }
            return this.isAllowed(idx, enrollment) ? null : enrollment;
        }

        public StudentPreferencePenalties getPenalties() {
            return this.iPenalties;
        }
    }
}

