/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.heuristics;

import net.sf.cpsolver.ifs.heuristics.RouletteWheelSelection;
import net.sf.cpsolver.ifs.heuristics.VariableSelection;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.studentsct.StudentSectioningModel;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouletteWheelRequestSelection
implements VariableSelection<Request, Enrollment> {
    RouletteWheelSelection<Request> iRoulette = null;

    public RouletteWheelRequestSelection(DataProperties properties) {
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
    }

    protected RouletteWheelSelection<Request> getRoulette(Solution<Request, Enrollment> solution) {
        if (this.iRoulette != null && this.iRoulette.hasMoreElements() && this.iRoulette.getUsedPoints() < 0.1 * this.iRoulette.getTotalPoints()) {
            return this.iRoulette;
        }
        this.iRoulette = new RouletteWheelSelection();
        for (Request request : ((StudentSectioningModel)solution.getModel()).variables()) {
            double points = 0.0;
            if (request.getAssignment() == null) {
                points += 10.0;
            } else {
                Enrollment enrollment = (Enrollment)request.getAssignment();
                if (enrollment.toDouble() > request.getBound()) {
                    points += 1.0;
                }
            }
            if (!(points > 0.0)) continue;
            this.iRoulette.add(request, points);
        }
        return this.iRoulette;
    }

    @Override
    public Request selectVariable(Solution<Request, Enrollment> solution) {
        return this.getRoulette(solution).nextElement();
    }
}

