/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.heuristics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.ifs.extension.ConflictStatistics;
import net.sf.cpsolver.ifs.extension.Extension;
import net.sf.cpsolver.ifs.extension.MacPropagation;
import net.sf.cpsolver.ifs.extension.ViolatedInitials;
import net.sf.cpsolver.ifs.heuristics.ValueSelection;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.ToolBox;
import net.sf.cpsolver.studentsct.StudentSectioningModel;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnrollmentSelection
implements ValueSelection<Request, Enrollment> {
    private double iRandomWalkProb = 0.0;
    private double iInitialSelectionProb = 0.0;
    private double iGoodSelectionProb = 0.0;
    private int iMPPLimit = -1;
    private double iWeightDeltaInitialAssignment = 0.0;
    private double iWeightPotentialConflicts = 0.0;
    private double iWeightWeightedCoflicts = 0.0;
    private double iWeightCoflicts = 1.0;
    private double iWeightNrAssignments = 0.5;
    private double iWeightValue = 0.0;
    protected int iTabuSize = 0;
    protected List<Enrollment> iTabu = null;
    protected int iTabuPos = 0;
    private boolean iMPP = false;
    private ConflictStatistics<Request, Enrollment> iStat = null;
    private MacPropagation<Request, Enrollment> iProp = null;
    private ViolatedInitials<Request, Enrollment> iViolatedInitials = null;

    public EnrollmentSelection() {
    }

    public EnrollmentSelection(DataProperties properties) {
        this.iMPP = properties.getPropertyBoolean("General.MPP", false);
        if (this.iMPP) {
            this.iMPPLimit = properties.getPropertyInt("Value.MPPLimit", -1);
            this.iInitialSelectionProb = properties.getPropertyDouble("Value.InitialSelectionProb", 0.75);
            this.iWeightDeltaInitialAssignment = properties.getPropertyDouble("Value.WeightDeltaInitialAssignments", 0.0);
        }
        this.iGoodSelectionProb = properties.getPropertyDouble("Value.GoodSelectionProb", 0.0);
        this.iWeightWeightedCoflicts = properties.getPropertyDouble("Value.WeightWeightedConflicts", 1.0);
        this.iWeightPotentialConflicts = properties.getPropertyDouble("Value.WeightPotentialConflicts", 0.0);
        this.iRandomWalkProb = properties.getPropertyDouble("Value.RandomWalkProb", 0.0);
        this.iWeightCoflicts = properties.getPropertyDouble("Value.WeightConflicts", 1.0);
        this.iWeightNrAssignments = properties.getPropertyDouble("Value.WeightNrAssignments", 0.5);
        this.iWeightValue = properties.getPropertyDouble("Value.WeightValue", 0.0);
        this.iTabuSize = properties.getPropertyInt("Value.Tabu", 0);
        if (this.iTabuSize > 0) {
            this.iTabu = new ArrayList<Enrollment>(this.iTabuSize);
        }
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        for (Extension<Request, Enrollment> extension : solver.getExtensions()) {
            if (ConflictStatistics.class.isInstance(extension)) {
                this.iStat = (ConflictStatistics)extension;
            }
            if (MacPropagation.class.isInstance(extension)) {
                this.iProp = (MacPropagation)extension;
            }
            if (!ViolatedInitials.class.isInstance(extension)) continue;
            this.iViolatedInitials = (ViolatedInitials)extension;
        }
    }

    public boolean isAllowed(Enrollment value) {
        return this.isAllowed(value, null);
    }

    public boolean isAllowed(Enrollment value, Set<Enrollment> conflicts) {
        if (value == null) {
            return true;
        }
        StudentSectioningModel model = (StudentSectioningModel)((Request)value.variable()).getModel();
        if (model.getNrLastLikeRequests(false) == 0 || model.getNrRealRequests(false) == 0) {
            return true;
        }
        Request request = (Request)value.variable();
        if (request.getStudent().isDummy()) {
            if (conflicts == null) {
                conflicts = ((Request)value.variable()).getModel().conflictValues(value);
            }
            for (Enrollment conflict : conflicts) {
                if (conflict.getRequest().getStudent().isDummy()) continue;
                return false;
            }
        } else {
            if (conflicts == null) {
                conflicts = ((Request)value.variable()).getModel().conflictValues(value);
            }
            if (conflicts.size() > (request.getAssignment() == null ? 1 : 0)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Enrollment selectValue(Solution<Request, Enrollment> solution, Request selectedVariable) {
        Enrollment selectedValue;
        Set<Enrollment> goodValues;
        Enrollment value;
        if (this.iMPP && selectedVariable.getInitialAssignment() != null) {
            if (solution.getModel().unassignedVariables().isEmpty() && solution.getModel().perturbVariables().size() <= this.iMPPLimit) {
                this.iMPPLimit = solution.getModel().perturbVariables().size() - 1;
            }
            if (this.iMPPLimit >= 0 && solution.getModel().perturbVariables().size() > this.iMPPLimit && this.isAllowed((Enrollment)selectedVariable.getInitialAssignment())) {
                return (Enrollment)selectedVariable.getInitialAssignment();
            }
            if (selectedVariable.getInitialAssignment() != null && ToolBox.random() <= this.iInitialSelectionProb && this.isAllowed((Enrollment)selectedVariable.getInitialAssignment())) {
                return (Enrollment)selectedVariable.getInitialAssignment();
            }
        }
        List<Enrollment> values = selectedVariable.values();
        if (ToolBox.random() <= this.iRandomWalkProb && this.isAllowed(value = ToolBox.random(values))) {
            return value;
        }
        if (this.iProp != null && selectedVariable.getAssignment() == null && ToolBox.random() <= this.iGoodSelectionProb && !(goodValues = this.iProp.goodValues(selectedVariable)).isEmpty()) {
            values = new ArrayList<Enrollment>(goodValues);
        }
        if (values.size() == 1) {
            value = values.get(0);
            if (this.isAllowed(value)) {
                return value;
            }
            return null;
        }
        ArrayList<Enrollment> bestValues = null;
        double bestWeightedSum = 0.0;
        for (Enrollment value2 : values) {
            Set<Enrollment> conf;
            if (this.iTabu != null && this.iTabu.contains(value2) || selectedVariable.getAssignment() != null && ((Enrollment)selectedVariable.getAssignment()).equals(value2) || (conf = solution.getModel().conflictValues(value2)).contains(value2) || !this.isAllowed(value2, conf)) continue;
            double weightedConflicts = this.iStat == null || this.iWeightWeightedCoflicts == 0.0 ? 0.0 : this.iStat.countRemovals(solution.getIteration(), (Enrollment)((Object)conf), value2);
            double potentialConflicts = this.iStat == null || this.iWeightPotentialConflicts == 0.0 ? 0.0 : (double)this.iStat.countPotentialConflicts(solution.getIteration(), value2, 3);
            long deltaInitialAssignments = 0L;
            if (this.iMPP && this.iWeightDeltaInitialAssignment != 0.0) {
                Object violations;
                if (this.iViolatedInitials != null && (violations = this.iViolatedInitials.getViolatedInitials(value2)) != null) {
                    Iterator iterator = violations.iterator();
                    while (iterator.hasNext()) {
                        Enrollment aValue = (Enrollment)iterator.next();
                        if (((Request)aValue.variable()).getAssignment() != null && !((Enrollment)((Request)aValue.variable()).getAssignment()).equals(aValue)) continue;
                        deltaInitialAssignments += 2L;
                    }
                }
                violations = conf.iterator();
                while (violations.hasNext()) {
                    Enrollment aValue = (Enrollment)violations.next();
                    if (((Request)aValue.variable()).getInitialAssignment() == null) continue;
                    --deltaInitialAssignments;
                }
                if (selectedVariable.getInitialAssignment() != null && !((Enrollment)selectedVariable.getInitialAssignment()).equals(value2)) {
                    ++deltaInitialAssignments;
                }
                if (this.iMPPLimit >= 0 && (long)solution.getModel().perturbVariables().size() + deltaInitialAssignments > (long)this.iMPPLimit) continue;
            }
            double weightedSum = this.iWeightDeltaInitialAssignment * (double)deltaInitialAssignments + this.iWeightPotentialConflicts * potentialConflicts + this.iWeightWeightedCoflicts * weightedConflicts + this.iWeightCoflicts * (double)conf.size() + this.iWeightNrAssignments * (double)value2.countAssignments() + this.iWeightValue * value2.toDouble();
            if (bestValues == null || bestWeightedSum > weightedSum) {
                bestWeightedSum = weightedSum;
                if (bestValues == null) {
                    bestValues = new ArrayList<Enrollment>();
                } else {
                    bestValues.clear();
                }
                bestValues.add(value2);
                continue;
            }
            if (bestWeightedSum != weightedSum) continue;
            bestValues.add(value2);
        }
        Enrollment enrollment = selectedValue = bestValues == null ? null : (Enrollment)ToolBox.random(bestValues);
        if (selectedValue == null) {
            selectedValue = ToolBox.random(values);
        }
        if (this.iTabu != null) {
            if (this.iTabu.size() == this.iTabuPos) {
                this.iTabu.add(selectedValue);
            } else {
                this.iTabu.set(this.iTabuPos, selectedValue);
            }
            this.iTabuPos = (this.iTabuPos + 1) % this.iTabuSize;
        }
        return bestValues == null ? null : selectedValue;
    }
}

