/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.extension;

import net.sf.cpsolver.ifs.extension.ConflictStatistics;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentConflictStatistics
extends ConflictStatistics<Request, Enrollment> {
    public double iRealStudentWeight = 2.0;
    public double iDummyStudentWeight = 0.5;

    public StudentConflictStatistics(Solver<Request, Enrollment> solver, DataProperties properties) {
        super(solver, properties);
        this.iRealStudentWeight = properties.getPropertyDouble("StudentConflictStatistics.RealStudentWeight", this.iRealStudentWeight);
        this.iDummyStudentWeight = properties.getPropertyDouble("StudentConflictStatistics.DummyStudentWeight", this.iDummyStudentWeight);
    }

    @Override
    public double countRemovals(long iteration, Enrollment conflictValue, Enrollment value) {
        double ret = super.countRemovals(iteration, conflictValue, value);
        if (ret == 0.0) {
            return ret;
        }
        Enrollment conflict = conflictValue;
        return ret * (conflict.getRequest().getStudent().isDummy() ? this.iDummyStudentWeight : this.iRealStudentWeight);
    }
}

