/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.constraint;

import java.util.ArrayList;
import java.util.Set;
import net.sf.cpsolver.ifs.model.GlobalConstraint;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.ToolBox;
import net.sf.cpsolver.studentsct.StudentSectioningModel;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Section;
import net.sf.cpsolver.studentsct.reservation.Reservation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectionLimit
extends GlobalConstraint<Request, Enrollment> {
    private static double sNominalWeight = 1.0E-5;
    private boolean iPreferDummyStudents = false;

    public SectionLimit(DataProperties cfg) {
        this.iPreferDummyStudents = cfg.getPropertyBoolean("SectionLimit.PreferDummyStudents", false);
    }

    public static double getEnrollmentWeight(Section section, Request request) {
        return section.getEnrollmentWeight(request) + request.getWeight() - Math.max(section.getMaxEnrollmentWeight(), request.getWeight()) + sNominalWeight;
    }

    public static double getUnreservedSpace(Section section, Request request) {
        return section.getUnreservedSpace(request) - request.getWeight() + Math.max(section.getMaxEnrollmentWeight(), request.getWeight()) - sNominalWeight;
    }

    private boolean hasSectionReservation(Enrollment enrollment, Section section) {
        Reservation reservation = enrollment.getReservation();
        if (reservation == null) {
            return false;
        }
        Set<Section> sections = reservation.getSections(section.getSubpart());
        return sections != null && sections.contains(section);
    }

    @Override
    public void computeConflicts(Enrollment enrollment, Set<Enrollment> conflicts) {
        if (((StudentSectioningModel)this.getModel()).getReservationCanAssignOverTheLimit() && enrollment.getReservation() != null && enrollment.getReservation().canAssignOverLimit()) {
            return;
        }
        if (!enrollment.isCourseRequest()) {
            return;
        }
        for (Section section : enrollment.getSections()) {
            double enrlWeight;
            double bestValue;
            ArrayList<Enrollment> best;
            ArrayList<Enrollment> adepts;
            if (enrollment.getConfig().getOffering().hasReservations() && !this.hasSectionReservation(enrollment, section)) {
                if (section.getTotalUnreservedSpace() < enrollment.getRequest().getWeight()) {
                    conflicts.add(enrollment);
                    return;
                }
                double unreserved = SectionLimit.getUnreservedSpace(section, enrollment.getRequest());
                if (unreserved < 0.0) {
                    adepts = new ArrayList(section.getEnrollments().size());
                    for (Enrollment e : section.getEnrollments()) {
                        if (e.getRequest().equals(enrollment.getRequest()) || this.hasSectionReservation(e, section)) continue;
                        if (conflicts.contains(e)) {
                            unreserved += e.getRequest().getWeight();
                            continue;
                        }
                        adepts.add(e);
                    }
                    while (unreserved < 0.0) {
                        if (adepts.isEmpty()) {
                            conflicts.add(enrollment);
                            return;
                        }
                        best = new ArrayList<Enrollment>();
                        boolean bestDummy = false;
                        bestValue = 0.0;
                        for (Enrollment enrollment2 : adepts) {
                            boolean dummy = enrollment2.getStudent().isDummy();
                            double value = enrollment2.toDouble(false);
                            if (this.iPreferDummyStudents && dummy != bestDummy) {
                                if (!dummy) continue;
                                best.clear();
                                best.add(enrollment2);
                                bestDummy = dummy;
                                bestValue = value;
                                continue;
                            }
                            if (best.isEmpty() || value > bestValue) {
                                if (best.isEmpty()) {
                                    best.clear();
                                }
                                best.add(enrollment2);
                                bestDummy = dummy;
                                bestValue = value;
                                continue;
                            }
                            if (bestValue != value) continue;
                            best.add(enrollment2);
                        }
                        Enrollment conflict = (Enrollment)ToolBox.random(best);
                        adepts.remove(conflict);
                        unreserved += conflict.getRequest().getWeight();
                        conflicts.add(conflict);
                    }
                }
            }
            if (section.getLimit() < 0 || (enrlWeight = SectionLimit.getEnrollmentWeight(section, enrollment.getRequest())) <= (double)section.getLimit()) continue;
            adepts = new ArrayList<Enrollment>(section.getEnrollments().size());
            for (Enrollment e : section.getEnrollments()) {
                if (e.getRequest().equals(enrollment.getRequest())) continue;
                if (conflicts.contains(e)) {
                    enrlWeight -= e.getRequest().getWeight();
                    continue;
                }
                adepts.add(e);
            }
            while (enrlWeight > (double)section.getLimit()) {
                if (adepts.isEmpty()) {
                    conflicts.add(enrollment);
                    return;
                }
                best = new ArrayList();
                boolean bestDummy = false;
                bestValue = 0.0;
                boolean bestRes = true;
                for (Enrollment adept2 : adepts) {
                    boolean dummy = adept2.getStudent().isDummy();
                    double value = adept2.toDouble(false);
                    boolean res = this.hasSectionReservation(adept2, section);
                    if (this.iPreferDummyStudents && dummy != bestDummy) {
                        if (!dummy) continue;
                        best.clear();
                        best.add(adept2);
                        bestDummy = dummy;
                        bestValue = value;
                        bestRes = res;
                        continue;
                    }
                    if (bestRes != res) {
                        if (res) continue;
                        best.clear();
                        best.add(adept2);
                        bestDummy = dummy;
                        bestValue = value;
                        bestRes = res;
                        continue;
                    }
                    if (best.isEmpty() || value > bestValue) {
                        if (best.isEmpty()) {
                            best.clear();
                        }
                        best.add(adept2);
                        bestDummy = dummy;
                        bestValue = value;
                        bestRes = res;
                        continue;
                    }
                    if (bestValue != value) continue;
                    best.add(adept2);
                }
                Enrollment enrollment3 = (Enrollment)ToolBox.random(best);
                adepts.remove(enrollment3);
                enrlWeight -= enrollment3.getRequest().getWeight();
                conflicts.add(enrollment3);
            }
        }
    }

    @Override
    public boolean inConflict(Enrollment enrollment) {
        if (((StudentSectioningModel)this.getModel()).getReservationCanAssignOverTheLimit() && enrollment.getReservation() != null && enrollment.getReservation().canAssignOverLimit()) {
            return false;
        }
        if (!enrollment.isCourseRequest()) {
            return false;
        }
        for (Section section : enrollment.getSections()) {
            double enrlWeight;
            if (enrollment.getConfig().getOffering().hasReservations() && !this.hasSectionReservation(enrollment, section) && (section.getTotalUnreservedSpace() < enrollment.getRequest().getWeight() || SectionLimit.getUnreservedSpace(section, enrollment.getRequest()) < 0.0)) {
                return true;
            }
            if (section.getLimit() < 0 || !((enrlWeight = SectionLimit.getEnrollmentWeight(section, enrollment.getRequest())) > (double)section.getLimit())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "SectionLimit";
    }
}

