/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.constraint;

import java.util.Set;
import net.sf.cpsolver.ifs.model.GlobalConstraint;
import net.sf.cpsolver.studentsct.model.Config;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.reservation.Reservation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredReservation
extends GlobalConstraint<Request, Enrollment> {
    @Override
    public void computeConflicts(Enrollment enrollment, Set<Enrollment> conflicts) {
        if (this.inConflict(enrollment)) {
            conflicts.add(enrollment);
        }
    }

    @Override
    public boolean inConflict(Enrollment enrollment) {
        Config config = enrollment.getConfig();
        if (config == null) {
            return false;
        }
        if (!config.getOffering().hasReservations()) {
            return false;
        }
        Reservation reservation = enrollment.getReservation();
        if (reservation != null && reservation.mustBeUsed()) {
            return false;
        }
        for (Reservation r : config.getOffering().getReservations()) {
            if (!r.mustBeUsed() || !r.isApplicable(enrollment.getStudent())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "RequiredReservation";
    }
}

