/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.constraint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.studentsct.model.Course;
import net.sf.cpsolver.studentsct.model.CourseRequest;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Offering;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Section;
import net.sf.cpsolver.studentsct.model.Student;
import net.sf.cpsolver.studentsct.model.Subpart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedSections {
    private Map<Offering, Map<Subpart, Set<Section>>> iSections = new HashMap<Offering, Map<Subpart, Set<Section>>>();

    public LinkedSections(Section ... sections) {
        for (Section section : sections) {
            this.addSection(section);
        }
    }

    public LinkedSections(Collection<Section> sections) {
        for (Section section : sections) {
            this.addSection(section);
        }
    }

    private void addSection(Section section) {
        Set<Section> sections;
        Map<Subpart, Set<Section>> subparts = this.iSections.get(section.getSubpart().getConfig().getOffering());
        if (subparts == null) {
            subparts = new HashMap<Subpart, Set<Section>>();
            this.iSections.put(section.getSubpart().getConfig().getOffering(), subparts);
        }
        if ((sections = subparts.get(section.getSubpart())) == null) {
            sections = new HashSet<Section>();
            subparts.put(section.getSubpart(), sections);
        }
        sections.add(section);
    }

    public Set<Offering> getOfferings() {
        return this.iSections.keySet();
    }

    public Set<Subpart> getSubparts(Offering offering) {
        return this.iSections.get(offering).keySet();
    }

    public Set<Section> getSections(Subpart subpart) {
        return this.iSections.get(subpart.getConfig().getOffering()).get(subpart);
    }

    private LinkedSectionsConstraint createConstraint(Student student) {
        ArrayList<Request> requests = new ArrayList<Request>();
        int nrOfferings = 0;
        block0: for (Request request : student.getRequests()) {
            if (!(request instanceof CourseRequest)) continue;
            for (Course course : ((CourseRequest)request).getCourses()) {
                Map<Subpart, Set<Section>> subpartsThisOffering = this.iSections.get(course.getOffering());
                if (subpartsThisOffering == null) continue;
                requests.add(request);
                ++nrOfferings;
                continue block0;
            }
        }
        if (nrOfferings <= 1) {
            return null;
        }
        LinkedSectionsConstraint constraint = new LinkedSectionsConstraint(student, requests);
        student.getRequests().get(0).getModel().addConstraint(constraint);
        return constraint;
    }

    public void createConstraints() {
        HashSet<Student> students = new HashSet<Student>();
        for (Offering offering : this.iSections.keySet()) {
            for (Course course : offering.getCourses()) {
                for (Request request : course.getRequests()) {
                    if (!students.add(request.getStudent()) || this.createConstraint(request.getStudent()) == null) continue;
                    request.getStudent().getLinkedSections().add(this);
                }
            }
        }
    }

    public void computeConflicts(Enrollment enrollment, ConflictHandler conflicts) {
        this.computeConflicts(enrollment, new CurrentAssignment(), conflicts);
    }

    public void computeConflicts(Enrollment enrollment, Assignment assignment, ConflictHandler conflicts) {
        Enrollment otherEnrollment;
        Request request;
        if (enrollment == null || enrollment.getCourse() == null) {
            return;
        }
        Map<Subpart, Set<Section>> subparts = this.iSections.get(enrollment.getCourse().getOffering());
        if (subparts == null || subparts.isEmpty()) {
            return;
        }
        ArrayList<Section> match = new ArrayList<Section>();
        for (Section section : enrollment.getSections()) {
            Set<Section> sections = subparts.get(section.getSubpart());
            if (sections == null || !sections.contains(section)) continue;
            match.add(section);
        }
        if (match.size() == subparts.size()) {
            for (int i = 0; i < enrollment.getStudent().getRequests().size(); ++i) {
                Map<Subpart, Set<Section>> otherSubparts;
                request = enrollment.getStudent().getRequests().get(i);
                if (request.equals(enrollment.getRequest()) || (otherEnrollment = assignment.getEnrollment(request, i)) == null || otherEnrollment.getCourse() == null || (otherSubparts = this.iSections.get(otherEnrollment.getCourse().getOffering())) == null || otherSubparts.isEmpty()) continue;
                ArrayList<Section> otherMatch = new ArrayList<Section>();
                for (Section section : otherEnrollment.getSections()) {
                    Set<Section> otherSections = otherSubparts.get(section.getSubpart());
                    if (otherSections == null || !otherSections.contains(section)) continue;
                    otherMatch.add(section);
                }
                if (otherMatch.size() == otherSubparts.size() || conflicts.onConflict(otherEnrollment)) continue;
                return;
            }
        } else {
            for (int i = 0; i < enrollment.getStudent().getRequests().size(); ++i) {
                Map<Subpart, Set<Section>> otherSubparts;
                request = enrollment.getStudent().getRequests().get(i);
                if (request.equals(enrollment.getRequest()) || (otherEnrollment = assignment.getEnrollment(request, i)) == null || otherEnrollment.getCourse() == null || (otherSubparts = this.iSections.get(otherEnrollment.getCourse().getOffering())) == null || otherSubparts.isEmpty()) continue;
                ArrayList<Section> otherMatch = new ArrayList<Section>();
                for (Section section : otherEnrollment.getSections()) {
                    Set<Section> otherSections = otherSubparts.get(section.getSubpart());
                    if (otherSections == null || !otherSections.contains(section)) continue;
                    otherMatch.add(section);
                }
                if (otherMatch.size() != otherSubparts.size() || conflicts.onConflict(otherEnrollment)) continue;
                return;
            }
        }
    }

    public Enrollment inConflict(Enrollment enrollment) {
        return this.inConflict(enrollment, new CurrentAssignment());
    }

    public Enrollment inConflict(Enrollment enrollment, Assignment assignment) {
        final Toggle<Object> ret = new Toggle<Object>(null);
        this.computeConflicts(enrollment, assignment, new ConflictHandler(){

            public boolean onConflict(Enrollment conflict) {
                ret.set(conflict);
                return false;
            }
        });
        return ret.get();
    }

    public String toString() {
        return "LinkedSections" + this.iSections.keySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LinkedSectionsConstraint
    extends Constraint<Request, Enrollment> {
        private Student iStudent;

        protected LinkedSectionsConstraint(Student student, Collection<Request> requests) {
            this.iStudent = student;
            for (Request request : requests) {
                this.addVariable(request);
            }
        }

        public Student getStudent() {
            return this.iStudent;
        }

        public LinkedSections getLinkedSections() {
            return LinkedSections.this;
        }

        @Override
        public void computeConflicts(Enrollment value, final Set<Enrollment> conflicts) {
            this.getLinkedSections().computeConflicts(value, new ConflictHandler(){

                public boolean onConflict(Enrollment conflict) {
                    conflicts.add(conflict);
                    return true;
                }
            });
        }

        @Override
        public boolean isConsistent(Enrollment enrollment, final Enrollment other) {
            return this.getLinkedSections().inConflict(enrollment, new Assignment(){

                public Enrollment getEnrollment(Request request, int indext) {
                    return request.equals(other.getRequest()) ? other : null;
                }
            }) == null;
        }

        @Override
        public boolean inConflict(Enrollment value) {
            return this.getLinkedSections().inConflict(value) != null;
        }

        public String toString() {
            return this.getLinkedSections().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Toggle<T> {
        private T iValue;

        Toggle(T value) {
            this.set(value);
        }

        void set(T value) {
            this.iValue = value;
        }

        T get() {
            return this.iValue;
        }
    }

    public static class CurrentAssignment
    implements Assignment {
        public Enrollment getEnrollment(Request request, int index) {
            return (Enrollment)request.getAssignment();
        }
    }

    public static interface ConflictHandler {
        public boolean onConflict(Enrollment var1);
    }

    public static interface Assignment {
        public Enrollment getEnrollment(Request var1, int var2);
    }
}

