/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.constraint;

import java.util.ArrayList;
import java.util.Set;
import net.sf.cpsolver.ifs.model.GlobalConstraint;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.ToolBox;
import net.sf.cpsolver.studentsct.StudentSectioningModel;
import net.sf.cpsolver.studentsct.model.Config;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigLimit
extends GlobalConstraint<Request, Enrollment> {
    private static double sNominalWeight = 1.0E-5;
    private boolean iPreferDummyStudents = false;

    public ConfigLimit(DataProperties cfg) {
        this.iPreferDummyStudents = cfg.getPropertyBoolean("ConfigLimit.PreferDummyStudents", false);
    }

    public static double getEnrollmentWeight(Config config, Request request) {
        return config.getEnrollmentWeight(request) + request.getWeight() - Math.max(config.getMaxEnrollmentWeight(), request.getWeight()) + sNominalWeight;
    }

    @Override
    public void computeConflicts(Enrollment enrollment, Set<Enrollment> conflicts) {
        if (((StudentSectioningModel)this.getModel()).getReservationCanAssignOverTheLimit() && enrollment.getReservation() != null && enrollment.getReservation().canAssignOverLimit()) {
            return;
        }
        Config config = enrollment.getConfig();
        if (config == null) {
            return;
        }
        if (config.getLimit() < 0) {
            return;
        }
        double enrlWeight = ConfigLimit.getEnrollmentWeight(config, enrollment.getRequest());
        if (enrlWeight <= (double)config.getLimit()) {
            return;
        }
        ArrayList<Enrollment> adepts = new ArrayList<Enrollment>(config.getEnrollments().size());
        for (Enrollment e : config.getEnrollments()) {
            if (e.getRequest().equals(enrollment.getRequest())) continue;
            if (conflicts.contains(e)) {
                enrlWeight -= e.getRequest().getWeight();
                continue;
            }
            adepts.add(e);
        }
        while (enrlWeight > (double)config.getLimit()) {
            if (adepts.isEmpty()) {
                conflicts.add(enrollment);
                return;
            }
            ArrayList<Enrollment> best = new ArrayList<Enrollment>();
            boolean bestDummy = false;
            double bestValue = 0.0;
            boolean bestRes = true;
            for (Enrollment adept : adepts) {
                boolean res;
                boolean dummy = adept.getStudent().isDummy();
                double value = adept.toDouble(false);
                boolean bl = res = adept.getReservation() != null;
                if (this.iPreferDummyStudents && dummy != bestDummy) {
                    if (!dummy) continue;
                    best.clear();
                    best.add(adept);
                    bestDummy = dummy;
                    bestValue = value;
                    bestRes = res;
                    continue;
                }
                if (bestRes != res) {
                    if (res) continue;
                    best.clear();
                    best.add(adept);
                    bestDummy = dummy;
                    bestValue = value;
                    bestRes = res;
                    continue;
                }
                if (best.isEmpty() || value > bestValue) {
                    if (best.isEmpty()) {
                        best.clear();
                    }
                    best.add(adept);
                    bestDummy = dummy;
                    bestValue = value;
                    bestRes = res;
                    continue;
                }
                if (bestValue != value) continue;
                best.add(adept);
            }
            Enrollment conflict = (Enrollment)ToolBox.random(best);
            adepts.remove(conflict);
            enrlWeight -= conflict.getRequest().getWeight();
            conflicts.add(conflict);
        }
    }

    @Override
    public boolean inConflict(Enrollment enrollment) {
        if (((StudentSectioningModel)this.getModel()).getReservationCanAssignOverTheLimit() && enrollment.getReservation() != null && enrollment.getReservation().canAssignOverLimit()) {
            return false;
        }
        Config config = enrollment.getConfig();
        if (config == null) {
            return false;
        }
        if (config.getLimit() < 0) {
            return false;
        }
        double enrlWeight = ConfigLimit.getEnrollmentWeight(config, enrollment.getRequest());
        return enrlWeight > (double)config.getLimit();
    }

    public String toString() {
        return "ConfigLimit";
    }
}

