/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.check;

import java.text.DecimalFormat;
import net.sf.cpsolver.studentsct.StudentSectioningModel;
import net.sf.cpsolver.studentsct.model.Config;
import net.sf.cpsolver.studentsct.model.Offering;
import net.sf.cpsolver.studentsct.model.Section;
import net.sf.cpsolver.studentsct.model.Subpart;
import org.apache.log4j.Logger;

public class SectionLimitCheck {
    private static Logger sLog = Logger.getLogger(SectionLimitCheck.class);
    private static DecimalFormat sDF = new DecimalFormat("0.000");
    private StudentSectioningModel iModel;

    public SectionLimitCheck(StudentSectioningModel model) {
        this.iModel = model;
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    public boolean check() {
        sLog.info((Object)"Checking section limits...");
        boolean ret = true;
        for (Offering offering : this.getModel().getOfferings()) {
            for (Config config : offering.getConfigs()) {
                for (Subpart subpart : config.getSubparts()) {
                    for (Section section : subpart.getSections()) {
                        if (section.getLimit() < 0) continue;
                        double used = section.getEnrollmentWeight(null);
                        if (used - section.getMaxEnrollmentWeight() > (double)section.getLimit()) {
                            sLog.error((Object)("Section " + section.getName() + " exceeds its limit " + sDF.format(used) + ">" + section.getLimit() + " for more than one student (W:" + section.getMaxEnrollmentWeight() + ")"));
                            ret = false;
                            continue;
                        }
                        if (Math.round(used) <= (long)section.getLimit()) continue;
                        sLog.debug((Object)("Section " + section.getName() + " exceeds its limit " + sDF.format(used) + ">" + section.getLimit() + " for less than one student (W:" + section.getMaxEnrollmentWeight() + ")"));
                    }
                }
            }
        }
        return ret;
    }
}

