/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.studentsct.constraint.SectionLimit;
import net.sf.cpsolver.studentsct.constraint.StudentConflict;
import net.sf.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import net.sf.cpsolver.studentsct.model.Course;
import net.sf.cpsolver.studentsct.model.CourseRequest;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Student;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentSctBBTest
extends Model<Request, Enrollment> {
    private Student iStudent = null;
    private Solution<Request, Enrollment> iSolution = null;
    private long iTime;
    private boolean iTimeoutReached = false;

    public StudentSctBBTest(Student student) {
        this.iStudent = student;
        for (Request request : this.iStudent.getRequests()) {
            this.addVariable(request);
        }
        this.addGlobalConstraint(new SectionLimit(new DataProperties()));
        this.addConstraint(new StudentConflict(student));
    }

    public Student getStudent() {
        return this.iStudent;
    }

    public Solution<Request, Enrollment> getSolution() {
        if (this.iSolution == null) {
            this.iSolution = new Solution<Request, Enrollment>(this);
            BranchBoundSelection.Selection selection = new BranchBoundSelection(new DataProperties()).getSelection(this.getStudent());
            BranchBoundSelection.BranchBoundNeighbour neighbour = selection.select();
            if (neighbour != null) {
                ((Neighbour)neighbour).assign(0L);
            }
            this.iTime = selection.getTime();
            this.iTimeoutReached = selection.isTimeoutReached();
        }
        return this.iSolution;
    }

    public List<Message> getMessages() {
        ArrayList<Message> ret = new ArrayList<Message>();
        ret.add(new Message(Message.sMsgLevelInfo, null, "<li>Solution found in " + this.iTime + " ms."));
        if (this.iTimeoutReached) {
            ret.add(new Message(Message.sMsgLevelInfo, null, "<li>Time out reached, solution optimality can not be guaranteed."));
        }
        for (Request request : this.getStudent().getRequests()) {
            if (!request.isAlternative() && request.getAssignment() == null) {
                ret.add(new Message(Message.sMsgLevelWarn, request, "<li>Unable to enroll to " + request + ", " + (request instanceof CourseRequest ? (((CourseRequest)request).getCourses().size() == 1 ? "course is" : "courses are") : "time is") + " not available."));
                List<Enrollment> values = request instanceof CourseRequest ? ((CourseRequest)request).getAvaiableEnrollmentsSkipSameTime() : request.computeEnrollments();
                for (Enrollment enrollment : values) {
                    Set<Enrollment> conf = this.conflictValues(enrollment);
                    if (conf == null || conf.isEmpty()) continue;
                    Enrollment conflict = conf.iterator().next();
                    if (conflict.equals(enrollment)) {
                        ret.add(new Message(Message.sMsgLevelInfo, request, "<ul>Assignment of " + enrollment.getName().replaceAll("\n", "<br>&nbsp;&nbsp;&nbsp;&nbsp;") + "<br> is not available."));
                        continue;
                    }
                    ret.add(new Message(Message.sMsgLevelInfo, request, "<ul>Assignment of " + enrollment.getName().replaceAll("\n", "<br>&nbsp;&nbsp;&nbsp;&nbsp;") + "<br> conflicts with " + conflict.getName().replaceAll("\n", "<br>&nbsp;&nbsp;&nbsp;&nbsp;") + "</ul>"));
                }
            }
            if (!(request instanceof CourseRequest) || request.getAssignment() == null) continue;
            CourseRequest courseRequest = (CourseRequest)request;
            Enrollment enrollment = (Enrollment)request.getAssignment();
            List<Enrollment> selectedEnrollments = courseRequest.getSelectedEnrollments(false);
            if (selectedEnrollments == null || selectedEnrollments.isEmpty() || selectedEnrollments.contains(enrollment)) continue;
            Course course = courseRequest.getSelectedChoices().iterator().next().getOffering().getCourse(this.getStudent());
            Enrollment selected = selectedEnrollments.get(0);
            Set<Enrollment> conf = this.conflictValues(selected);
            if (conf != null && !conf.isEmpty()) {
                ret.add(new Message(Message.sMsgLevelWarn, request, "<li>Unable to enroll selected enrollment for " + course.getName() + ", seleted " + (courseRequest.getSelectedChoices().size() == 1 ? "class is" : "classes are") + " conflicting with other choices."));
                Enrollment conflict = conf.iterator().next();
                if (conflict.equals(selected)) {
                    ret.add(new Message(Message.sMsgLevelInfo, request, "<ul>Assignment of " + selected.getName().replaceAll("\n", "<br>&nbsp;&nbsp;&nbsp;&nbsp;") + "<br> is not available."));
                    continue;
                }
                ret.add(new Message(Message.sMsgLevelInfo, request, "<ul>Assignment of " + selected.getName().replaceAll("\n", "<br>&nbsp;&nbsp;&nbsp;&nbsp;") + "<br> conflicts with " + conflict.getName().replaceAll("\n", "<br>&nbsp;&nbsp;&nbsp;&nbsp;") + "</ul>"));
                continue;
            }
            ret.add(new Message(Message.sMsgLevelWarn, request, "<li>Unable to enroll selected enrollment for " + course.getName() + "."));
        }
        return ret;
    }

    public static class Message {
        public static String[] sMsgLevels = new String[]{"INFO", "WARN", "ERROR"};
        public static int sMsgLevelInfo = 0;
        public static int sMsgLevelWarn = 1;
        public static int sMsgLevelError = 2;
        private int iLevel;
        private Request iRequest;
        private String iMessage;

        public Message(int level, Request request, String message) {
            this.iLevel = level;
            this.iRequest = request;
            this.iMessage = message;
        }

        public int getLevel() {
            return this.iLevel;
        }

        public String getLevelString() {
            return sMsgLevels[this.iLevel];
        }

        public Request getRequest() {
            return this.iRequest;
        }

        public String getMessage() {
            return this.iMessage;
        }

        public String toString() {
            return this.getLevelString() + ":" + this.getMessage();
        }
    }
}

