/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import net.sf.cpsolver.coursett.Constants;
import net.sf.cpsolver.coursett.model.TimeLocation;
import net.sf.cpsolver.ifs.heuristics.RouletteWheelSelection;
import net.sf.cpsolver.studentsct.model.Assignment;
import net.sf.cpsolver.studentsct.model.Config;
import net.sf.cpsolver.studentsct.model.Course;
import net.sf.cpsolver.studentsct.model.CourseRequest;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.FreeTimeRequest;
import net.sf.cpsolver.studentsct.model.Offering;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Section;
import net.sf.cpsolver.studentsct.model.Student;
import net.sf.cpsolver.studentsct.model.Subpart;
import org.apache.log4j.Logger;

public class StudentPreferencePenalties {
    private static Logger sLog = Logger.getLogger(StudentPreferencePenalties.class);
    private static DecimalFormat sDF = new DecimalFormat("0.000");
    private static boolean sDebug = false;
    public static int sDistTypeUniform = 0;
    public static int sDistTypePreference = 1;
    public static int sDistTypePreferenceQuadratic = 2;
    public static int sDistTypePreferenceReverse = 3;
    public static int[][] sStudentRequestDistribution = new int[][]{{1, 1, 4, 7, 10, 10, 5, 8, 8, 6, 3, 1}, {1, 2, 4, 7, 10, 10, 5, 8, 8, 6, 3, 1}, {1, 2, 4, 7, 10, 10, 5, 8, 8, 6, 3, 1}, {1, 2, 4, 7, 10, 10, 5, 8, 8, 6, 3, 1}, {1, 2, 4, 7, 10, 10, 5, 4, 3, 2, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}};
    private HashMap<String, Double> iWeight = new HashMap();

    public StudentPreferencePenalties(int disributionType) {
        RouletteWheelSelection<int[]> roulette = new RouletteWheelSelection<int[]>();
        for (int d = 0; d < sStudentRequestDistribution.length; ++d) {
            for (int t = 0; t < sStudentRequestDistribution[d].length; ++t) {
                if (disributionType == sDistTypeUniform) {
                    roulette.add(new int[]{d, t}, 1.0);
                    continue;
                }
                if (disributionType == sDistTypePreference) {
                    roulette.add(new int[]{d, t}, sStudentRequestDistribution[d][t]);
                    continue;
                }
                if (disributionType == sDistTypePreferenceQuadratic) {
                    roulette.add(new int[]{d, t}, sStudentRequestDistribution[d][t] * sStudentRequestDistribution[d][t]);
                    continue;
                }
                if (disributionType == sDistTypePreferenceReverse) {
                    roulette.add(new int[]{d, t}, 11 - sStudentRequestDistribution[d][t]);
                    continue;
                }
                roulette.add(new int[]{d, t}, 1.0);
            }
        }
        int idx = 0;
        while (roulette.hasMoreElements()) {
            int[] dt = (int[])roulette.nextElement();
            this.iWeight.put(dt[0] + "." + dt[1], new Double((double)idx / (double)(roulette.size() - 1)));
            if (sDebug) {
                sLog.debug((Object)("  -- " + (idx + 1) + ". preference is " + this.toString(dt[0], dt[1]) + " (P:" + sDF.format((double)idx / (double)(roulette.size() - 1)) + ")"));
            }
            ++idx;
        }
    }

    public static int day(int slot) {
        return slot / 288;
    }

    public static int time(int slot) {
        int s = slot % 288;
        int min = s * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        if (min < 450) {
            return 0;
        }
        int idx = 1 + (min - 450) / 60;
        return idx > 11 ? 11 : idx;
    }

    public String toString(int day, int time) {
        if (time == 0) {
            return Constants.DAY_NAMES_SHORT[day] + " morning";
        }
        if (time == 11) {
            return Constants.DAY_NAMES_SHORT[day] + " evening";
        }
        return Constants.DAY_NAMES_SHORT[day] + " " + (6 + time) + ":30";
    }

    public double getPenalty(TimeLocation time) {
        int nrSlots = 0;
        double penalty = 0.0;
        TimeLocation.IntEnumeration e = time.getSlots();
        while (e.hasMoreElements()) {
            int slot = (Integer)e.nextElement();
            ++nrSlots;
            penalty += this.iWeight.get(StudentPreferencePenalties.day(slot) + "." + StudentPreferencePenalties.time(slot)).doubleValue();
        }
        return penalty / (double)nrSlots;
    }

    public double getPenalty(Assignment assignment) {
        return assignment.getTime() == null ? 0.0 : this.getPenalty(assignment.getTime());
    }

    public double getPenalty(Enrollment enrollment) {
        double penalty = 0.0;
        for (Section section : enrollment.getSections()) {
            penalty += this.getPenalty(section);
        }
        return penalty / (double)enrollment.getAssignments().size();
    }

    public double getMinPenalty(Request request) {
        if (request instanceof CourseRequest) {
            return this.getMinPenalty((CourseRequest)request);
        }
        if (request instanceof FreeTimeRequest) {
            return this.getPenalty(((FreeTimeRequest)request).getTime());
        }
        return 0.0;
    }

    public double getMinPenalty(CourseRequest request) {
        double min = Double.MAX_VALUE;
        for (Course course : request.getCourses()) {
            min = Math.min(min, this.getMinPenalty(course.getOffering()));
        }
        return min == Double.MAX_VALUE ? 0.0 : min;
    }

    public double getMinPenalty(Offering offering) {
        double min = Double.MAX_VALUE;
        for (Config config : offering.getConfigs()) {
            min = Math.min(min, this.getMinPenalty(config));
        }
        return min == Double.MAX_VALUE ? 0.0 : min;
    }

    public double getMinPenalty(Config config) {
        double min = 0.0;
        for (Subpart subpart : config.getSubparts()) {
            min += this.getMinPenalty(subpart);
        }
        return min / (double)config.getSubparts().size();
    }

    public double getMinPenalty(Subpart subpart) {
        double min = Double.MAX_VALUE;
        for (Section section : subpart.getSections()) {
            min = Math.min(min, this.getPenalty(section));
        }
        return min == Double.MAX_VALUE ? 0.0 : min;
    }

    public double getMaxPenalty(Request request) {
        if (request instanceof CourseRequest) {
            return this.getMaxPenalty((CourseRequest)request);
        }
        if (request instanceof FreeTimeRequest) {
            return this.getPenalty(((FreeTimeRequest)request).getTime());
        }
        return 0.0;
    }

    public double getMaxPenalty(CourseRequest request) {
        double max = Double.MIN_VALUE;
        for (Course course : request.getCourses()) {
            max = Math.max(max, this.getMaxPenalty(course.getOffering()));
        }
        return max == Double.MIN_VALUE ? 0.0 : max;
    }

    public double getMaxPenalty(Offering offering) {
        double max = Double.MIN_VALUE;
        for (Config config : offering.getConfigs()) {
            max = Math.max(max, this.getMaxPenalty(config));
        }
        return max == Double.MIN_VALUE ? 0.0 : max;
    }

    public double getMaxPenalty(Config config) {
        double max = 0.0;
        for (Subpart subpart : config.getSubparts()) {
            max += this.getMaxPenalty(subpart);
        }
        return max / (double)config.getSubparts().size();
    }

    public double getMaxPenalty(Subpart subpart) {
        double max = Double.MIN_VALUE;
        for (Section section : subpart.getSections()) {
            max = Math.max(max, this.getPenalty(section));
        }
        return max == Double.MIN_VALUE ? 0.0 : max;
    }

    public double[] getMinMaxAvailableEnrollmentPenalty(Request request) {
        if (request instanceof CourseRequest) {
            return this.getMinMaxAvailableEnrollmentPenalty((CourseRequest)request);
        }
        double pen = this.getPenalty(((FreeTimeRequest)request).getTime());
        return new double[]{pen, pen};
    }

    public double[] getMinMaxAvailableEnrollmentPenalty(CourseRequest request) {
        List<Enrollment> enrollments = request.getAvaiableEnrollments();
        if (enrollments.isEmpty()) {
            return new double[]{0.0, 0.0};
        }
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (Enrollment enrollment : enrollments) {
            double penalty = this.getPenalty(enrollment);
            min = Math.min(min, penalty);
            max = Math.max(max, penalty);
        }
        return new double[]{min, max};
    }

    public double[] getMinMaxEnrollmentPenalty(Request request) {
        if (request instanceof CourseRequest) {
            return this.getMinMaxEnrollmentPenalty((CourseRequest)request);
        }
        double pen = this.getPenalty(((FreeTimeRequest)request).getTime());
        return new double[]{pen, pen};
    }

    public double[] getMinMaxEnrollmentPenalty(CourseRequest request) {
        List<Enrollment> enrollments = request.values();
        if (enrollments.isEmpty()) {
            return new double[]{0.0, 0.0};
        }
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (Enrollment enrollment : enrollments) {
            double penalty = this.getPenalty(enrollment);
            min = Math.min(min, penalty);
            max = Math.max(max, penalty);
        }
        return new double[]{min, max};
    }

    public static void setPenalties(Student student, int distributionType) {
        if (sDebug) {
            sLog.debug((Object)("Setting penalties for " + student));
        }
        StudentPreferencePenalties penalties = new StudentPreferencePenalties(distributionType);
        for (Request request : student.getRequests()) {
            if (!(request instanceof CourseRequest)) continue;
            CourseRequest courseRequest = (CourseRequest)request;
            if (sDebug) {
                sLog.debug((Object)("-- " + courseRequest));
            }
            for (Course course : courseRequest.getCourses()) {
                if (sDebug) {
                    sLog.debug((Object)("  -- " + course.getName()));
                }
                for (Config config : course.getOffering().getConfigs()) {
                    if (sDebug) {
                        sLog.debug((Object)("    -- " + config.getName()));
                    }
                    for (Subpart subpart : config.getSubparts()) {
                        if (sDebug) {
                            sLog.debug((Object)("      -- " + subpart.getName()));
                        }
                        for (Section section : subpart.getSections()) {
                            section.setPenalty(penalties.getPenalty(section));
                            if (!sDebug) continue;
                            sLog.debug((Object)("        -- " + section));
                        }
                    }
                }
            }
            courseRequest.clearCache();
        }
    }
}

