/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TreeSet;
import net.sf.cpsolver.ifs.util.DataProperties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolBox {
    private static long sSeed = System.currentTimeMillis();
    private static Random sRandom = new Random(sSeed);

    public static int random(int limit) {
        return (int)(ToolBox.random() * (double)limit);
    }

    public static <E> E random(Collection<E> set) {
        switch (set == null ? 0 : set.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return set.iterator().next();
            }
            case 2: {
                Iterator<E> i = set.iterator();
                if (sRandom.nextBoolean()) {
                    i.next();
                }
                return i.next();
            }
        }
        List v = set instanceof List ? (List)set : new ArrayList<E>(set);
        return v.get(ToolBox.random(v.size()));
    }

    public static <E> Collection<E> subSet(Collection<E> set, double part) {
        return ToolBox.subSet(set, part, 1);
    }

    private static <E> void swap(List<E> list, int first, int second) {
        E o = list.get(first);
        list.set(first, list.get(second));
        list.set(second, o);
    }

    public static <E> Collection<E> subSet(Collection<E> set, double part, int minSize) {
        if (set.size() <= minSize || part >= 1.0) {
            return set;
        }
        ArrayList<E> subSet = new ArrayList<E>(set);
        int size = set.size();
        int numberToSelect = Math.max(minSize, (int)(part * (double)set.size()));
        for (int idx = 0; idx < numberToSelect; ++idx) {
            ToolBox.swap(subSet, idx, idx + (int)(ToolBox.random() * (double)(size - idx)));
        }
        return subSet.subList(0, numberToSelect);
    }

    public static String trim(String s, int length) {
        if (s.length() > length) {
            return s.substring(0, length);
        }
        StringBuffer sb = new StringBuffer(s);
        while (sb.length() < length) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String col2string(Collection<?> col, int tab) {
        StringBuffer tabsb = new StringBuffer();
        while (tabsb.length() < 2 * tab) {
            tabsb.append("  ");
        }
        StringBuffer sb = new StringBuffer("[\n");
        Iterator<?> i = col.iterator();
        while (i.hasNext()) {
            sb.append(tabsb + "  " + i.next() + (i.hasNext() ? "," : "") + "\n");
        }
        sb.append(tabsb + "]");
        return sb.toString();
    }

    public static <K, V> String dict2string(Map<K, V> dict, int tab) {
        StringBuffer tabsb = new StringBuffer();
        while (tabsb.length() < 2 * tab) {
            tabsb.append("  ");
        }
        StringBuffer sb = new StringBuffer("[\n");
        TreeSet<K> keys = new TreeSet<K>(dict.keySet());
        for (K key : keys) {
            V value = dict.get(key);
            sb.append(tabsb + "  " + key + ": " + value + "\n");
        }
        sb.append(tabsb + "]");
        return sb.toString();
    }

    public static double rms(int n, double x, double x2) {
        double var = x2 / (double)n;
        double mean = x / (double)n;
        return Math.sqrt(Math.abs(var - mean * mean));
    }

    public static <E> void merge(List<E> target, Collection<E> source) {
        for (E o : source) {
            if (target.contains(o)) continue;
            target.add(o);
        }
    }

    public static <E> List<E> intersect(Collection<E> source1, Collection<E> source2) {
        ArrayList<E> target = new ArrayList<E>();
        for (E o : source1) {
            if (source2.contains(o)) continue;
            target.add(o);
        }
        return target;
    }

    public static void setSeed(long seed) {
        sSeed = seed;
        sRandom = new Random(sSeed);
    }

    public static long getSeed() {
        return sSeed;
    }

    public static Random getRandom() {
        return sRandom;
    }

    public static double random() {
        return sRandom.nextDouble();
    }

    public static void configureLogging() {
        Properties props = new Properties();
        props.setProperty("log4j.rootLogger", "DEBUG, A1");
        props.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        props.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        props.setProperty("log4j.appender.A1.layout.ConversionPattern", "%-5p %c{2}: %m%n");
        props.setProperty("log4j.logger.net", "INFO");
        props.setProperty("log4j.logger.net.sf.cpsolver", "DEBUG");
        props.setProperty("log4j.logger.org", "INFO");
        PropertyConfigurator.configure((Properties)props);
    }

    public static String configureLogging(String logDir, Properties properties) {
        return ToolBox.configureLogging(logDir, properties, false);
    }

    public static String configureLogging(String logDir, Properties properties, boolean timeInFileName) {
        return ToolBox.configureLogging(logDir, properties, timeInFileName, true);
    }

    public static String configureLogging(String logDir, Properties properties, boolean timeInFileName, boolean includeSystemOuts) {
        Properties props;
        String time = new SimpleDateFormat("yyyy-MM-dd_(HH.mm.ss)", Locale.US).format(new Date());
        new File(logDir).mkdirs();
        String fileName = logDir + File.separator + (timeInFileName ? "debug_" + time : "debug") + ".log";
        Properties properties2 = props = properties != null ? properties : new Properties();
        if (!props.containsKey("log4j.rootLogger")) {
            props.setProperty("log4j.rootLogger", "debug, LogFile");
            if (timeInFileName) {
                props.setProperty("log4j.appender.LogFile", "org.apache.log4j.FileAppender");
            } else {
                props.setProperty("log4j.appender.LogFile", "org.apache.log4j.DailyRollingFileAppender");
                props.setProperty("log4j.appender.LogFile.DatePattern", "'.'yyyy-MM-dd");
            }
            props.setProperty("log4j.appender.LogFile.File", fileName);
            props.setProperty("log4j.appender.LogFile.layout", "org.apache.log4j.PatternLayout");
            props.setProperty("log4j.appender.LogFile.layout.ConversionPattern", "%d{dd-MMM-yy HH:mm:ss.SSS} [%t] %-5p %c{2}> %m%n");
        }
        PropertyConfigurator.configure((Properties)props);
        Logger log = Logger.getRootLogger();
        log.info((Object)"-----------------------------------------------------------------------");
        log.info((Object)"IFS debug file");
        log.info((Object)"");
        log.info((Object)("Created: " + new Date()));
        log.info((Object)"");
        log.info((Object)"System info:");
        log.info((Object)("System:      " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch")));
        log.info((Object)("CPU:         " + System.getProperty("sun.cpu.isalist") + " endian:" + System.getProperty("sun.cpu.endian") + " encoding:" + System.getProperty("sun.io.unicode.encoding")));
        log.info((Object)("Java:        " + System.getProperty("java.vendor") + ", " + System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version", System.getProperty("java.version"))));
        log.info((Object)("User:        " + System.getProperty("user.name")));
        log.info((Object)("Timezone:    " + System.getProperty("user.timezone")));
        log.info((Object)("Working dir: " + System.getProperty("user.dir")));
        log.info((Object)("Classpath:   " + System.getProperty("java.class.path")));
        log.info((Object)"");
        if (includeSystemOuts) {
            System.setErr(new PrintStream(new LogOutputStream(System.err, Logger.getLogger((String)"STDERR"), Level.ERROR)));
            System.setOut(new PrintStream(new LogOutputStream(System.out, Logger.getLogger((String)"STDOUT"), Level.DEBUG)));
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataProperties loadProperties(File propertyFile) {
        FileInputStream is = null;
        try {
            DataProperties ret = new DataProperties();
            is = new FileInputStream(propertyFile);
            ret.load(is);
            is.close();
            is = null;
            if (ret.getProperty("INCLUDE") != null) {
                StringTokenizer stk = new StringTokenizer(ret.getProperty("INCLUDE"), ";");
                while (stk.hasMoreTokens()) {
                    String aFile = stk.nextToken();
                    System.out.println("  Loading included file '" + aFile + "' ... ");
                    if (new File(aFile).exists()) {
                        is = new FileInputStream(aFile);
                    }
                    if (new File(propertyFile.getParent() + File.separator + aFile).exists()) {
                        is = new FileInputStream(propertyFile.getParent() + File.separator + aFile);
                    }
                    if (is == null) {
                        System.err.println("Unable to find include file '" + aFile + "'.");
                    }
                    ret.load(is);
                    is.close();
                    is = null;
                }
                ret.remove("INCLUDE");
            }
            DataProperties dataProperties = ret;
            return dataProperties;
        }
        catch (Exception e) {
            System.err.println("Unable to load property file " + propertyFile);
            e.printStackTrace();
            DataProperties dataProperties = new DataProperties();
            return dataProperties;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static <E> List<E> toList(E ... obj) {
        ArrayList<E> ret = new ArrayList<E>(obj == null ? 0 : obj.length);
        if (obj != null) {
            for (E e : obj) {
                ret.add(e);
            }
        }
        return ret;
    }

    private static class LogOutputStream
    extends OutputStream {
        private Logger iLogger = null;
        private Level iLevel = null;
        private OutputStream iOldOutputStream;
        private ByteArrayOutputStream iOut = new ByteArrayOutputStream();

        public LogOutputStream(OutputStream oldOutputStream, Logger logger, Level level) {
            this.iLogger = logger;
            this.iLevel = level;
            this.iOldOutputStream = oldOutputStream;
        }

        public void write(int b) throws IOException {
            this.iOldOutputStream.write(b);
            if (b == 13) {
                return;
            }
            if (b == 10) {
                this.iOut.flush();
                this.iLogger.log((Priority)this.iLevel, (Object)new String(this.iOut.toByteArray()));
                this.iOut.reset();
            } else {
                this.iOut.write(b);
            }
        }
    }
}

