/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrologFile
implements Iterator<Term> {
    private BufferedReader iBufferedReader = null;
    private Term iNextTerm = null;

    public PrologFile(String file) throws IOException {
        this.iBufferedReader = new BufferedReader(new FileReader(file));
        Term term = this.iNextTerm = this.iBufferedReader.ready() ? PrologFile.readTerm(new SpecialReader(this.iBufferedReader)) : null;
        if (this.iNextTerm == null) {
            this.iBufferedReader.close();
        } else {
            this.iBufferedReader.readLine();
        }
    }

    public static List<Term> readTermsFromStream(InputStream is, String term) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        ArrayList<Term> ret = new ArrayList<Term>();
        while (br.ready()) {
            Term t = PrologFile.readTerm(new SpecialReader(br));
            if (t != null && t.getText() != null && t.getText().startsWith(term)) {
                ret.add(t);
            }
            br.readLine();
        }
        br.close();
        return ret;
    }

    public static void writeTerms(PrintWriter pw, List<Term> terms) throws IOException {
        for (Term t : terms) {
            PrologFile.writeTerm(pw, t);
        }
    }

    private static Term readTerm(SpecialReader is) throws IOException {
        StringBuffer text = new StringBuffer();
        ArrayList<Term> content = null;
        int i = is.read();
        if (i >= 0) {
            while ((char)i == '%' || (char)i == ':') {
                while ((i = is.read()) >= 0 && i != 13 && i != 10) {
                }
                i = is.read();
                if (i < 0 || i != 13 && i != 10) continue;
                i = is.read();
            }
            if (i >= 0) {
                is.flush((char)i);
            }
        }
        char prev = (char)i;
        if (i >= 0) {
            while ((i = is.read()) >= 0) {
                char ch = (char)i;
                if (ch == '\n' || ch == '\r') {
                    if (prev != '.') continue;
                    break;
                }
                if (ch == '(' || ch == '[') {
                    content = new ArrayList<Term>();
                    content.add(PrologFile.readTerm(is));
                } else {
                    if (content == null && (ch == ',' || ch == ')' || ch == ']')) {
                        is.flush(ch);
                        break;
                    }
                    if (ch == ',') {
                        content.add(PrologFile.readTerm(is));
                    } else {
                        if (ch == ')' || ch == ']') break;
                        text.append(ch);
                    }
                }
                prev = ch;
            }
        } else {
            return null;
        }
        Term ret = new Term(text.toString().trim(), content);
        return ret;
    }

    private static void writeTerm(PrintWriter pw, Term t) {
        pw.println(t.toString() + ".");
    }

    @Override
    public boolean hasNext() {
        return this.iNextTerm != null;
    }

    @Override
    public Term next() {
        Term ret = this.iNextTerm;
        try {
            this.iNextTerm = this.iBufferedReader.ready() ? PrologFile.readTerm(new SpecialReader(this.iBufferedReader)) : null;
        }
        catch (IOException x) {
            this.iNextTerm = null;
        }
        try {
            if (this.iNextTerm == null) {
                this.iBufferedReader.close();
            } else {
                this.iBufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public void remove() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Term {
        private String iText = null;
        private List<Term> iContent = null;

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Term)) {
                return false;
            }
            Term t = (Term)o;
            if (this.iText == null && t.iText != null) {
                return false;
            }
            if (this.iText != null && t.iText == null) {
                return false;
            }
            if (this.iText != null && !this.iText.equals(t.iText)) {
                return false;
            }
            if (this.iContent == null && t.iContent != null) {
                return false;
            }
            if (this.iContent != null && t.iContent == null) {
                return false;
            }
            return this.iContent == null || this.iContent.equals(t.iContent);
        }

        public Term(String text) {
            this.iText = text;
            this.iContent = null;
        }

        public Term(List<Term> content) {
            this.iText = null;
            this.iContent = content;
        }

        public Term(String text, List<Term> content) {
            this.iText = text;
            this.iContent = content;
        }

        public Term(String text, Term[] content) {
            this.iText = text;
            if (content == null) {
                this.iContent = null;
            } else {
                this.iContent = new ArrayList<Term>();
                for (int i = 0; i < content.length; ++i) {
                    this.iContent.add(content[i]);
                }
            }
        }

        public Term(Term[] content) {
            this(null, content);
        }

        public String getText() {
            return this.iText;
        }

        public List<Term> getContent() {
            return this.iContent;
        }

        public int size() {
            return this.iContent == null ? -1 : this.iContent.size();
        }

        public int toInt() {
            return Integer.parseInt(this.iText);
        }

        public long toLong() {
            return Long.parseLong(this.iText);
        }

        public double toDouble() {
            return Double.parseDouble(this.iText);
        }

        public boolean toBoolean() {
            return this.toInt() != 0;
        }

        public boolean[] toBooleanArray() {
            if (this.iContent.size() == 1 && this.iContent.get(0).toString().length() == 0) {
                return new boolean[0];
            }
            boolean[] ret = new boolean[this.iContent.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.elementAt(i).toBoolean();
            }
            return ret;
        }

        public String[] toStringArray() {
            if (this.iContent.size() == 1 && this.iContent.get(0).toString().length() == 0) {
                return new String[0];
            }
            String[] ret = new String[this.iContent.size()];
            for (int i = 0; i < ret.length; ++i) {
                Term t = this.elementAt(i);
                ret[i] = t.getText().length() > 0 ? t.toString() : t.elementAt(0).toString();
            }
            return ret;
        }

        public int[] toIntArray() {
            if (this.iContent.size() == 1 && this.iContent.get(0).toString().length() == 0) {
                return new int[0];
            }
            int[] ret = new int[this.iContent.size()];
            for (int i = 0; i < ret.length; ++i) {
                Term t = this.elementAt(i);
                ret[i] = t.getText().length() > 0 ? Integer.parseInt(t.getText()) : t.elementAt(0).toInt();
            }
            return ret;
        }

        public Term elementAt(int idx) {
            try {
                return this.iContent.get(idx);
            }
            catch (Exception e) {
                return null;
            }
        }

        public Term element(String name) {
            try {
                for (Term t : this.iContent) {
                    if (t.getText() == null || !t.getText().equals(name)) continue;
                    return t;
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }

        public int indexOf(String name) {
            try {
                int idx = 0;
                for (Term t : this.iContent) {
                    if (t.getText() != null && t.getText().equals(name)) {
                        return idx;
                    }
                    ++idx;
                }
                return -1;
            }
            catch (Exception e) {
                return -1;
            }
        }

        public String toString() {
            boolean isArray = this.iText == null || this.iText.length() == 0;
            StringBuffer sb = new StringBuffer(isArray ? "" : this.iText);
            if (this.iContent != null) {
                sb.append(isArray ? "[" : "(");
                Iterator<Term> e = this.iContent.iterator();
                while (e.hasNext()) {
                    sb.append(e.next().toString());
                    sb.append(e.hasNext() ? "," : "");
                }
                sb.append(isArray ? "]" : ")");
            }
            return sb.toString();
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public Object clone() {
            return new Term(this.iText == null ? null : new String(this.iText), (List<Term>)(this.iContent == null ? this.iContent : new ArrayList<Term>(this.iContent)));
        }
    }

    private static class SpecialReader {
        private Reader iReader = null;
        private StringBuffer iFlushedChars = new StringBuffer();

        public SpecialReader(Reader r) {
            this.iReader = r;
        }

        public int read() throws IOException {
            if (this.iFlushedChars.length() == 0) {
                return this.iReader.read();
            }
            char ret = this.iFlushedChars.charAt(0);
            this.iFlushedChars.deleteCharAt(0);
            return ret;
        }

        public void flush(char ch) {
            this.iFlushedChars.insert(0, ch);
        }
    }
}

