/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.apache.log4j.Logger;

public class JProf {
    private static Mode sMode = Mode.wall;
    private static boolean sInitialized = false;

    private static synchronized void init() {
        if (sInitialized) {
            return;
        }
        if ((sMode = Mode.valueOf(System.getProperty("jprof", sMode.name()))) != Mode.wall) {
            try {
                ThreadMXBean bean = ManagementFactory.getThreadMXBean();
                if (!bean.isCurrentThreadCpuTimeSupported()) {
                    Logger.getLogger(JProf.class).warn((Object)("Measuring " + sMode.name() + " time is not supported, falling back to wall time."));
                    sMode = Mode.wall;
                }
                if (!bean.isThreadCpuTimeEnabled()) {
                    bean.setThreadCpuTimeEnabled(true);
                }
            }
            catch (UnsupportedOperationException e) {
                Logger.getLogger(JProf.class).error((Object)("Unable to measure " + sMode.name() + " time, falling back to wall time: " + e.getMessage()));
                sMode = Mode.wall;
                sMode = Mode.wall;
            }
        }
        Logger.getLogger(JProf.class).info((Object)("Using " + sMode.name() + " time."));
        sInitialized = true;
    }

    public static double currentTimeSec() {
        JProf.init();
        try {
            switch (sMode) {
                case cpu: {
                    return (double)ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime() / 1.0E9;
                }
                case user: {
                    return (double)ManagementFactory.getThreadMXBean().getCurrentThreadUserTime() / 1.0E9;
                }
            }
            return (double)System.nanoTime() / 1.0E9;
        }
        catch (UnsupportedOperationException e) {
            Logger.getLogger(JProf.class).error((Object)("Unable to measure " + sMode.name() + " time, falling back to wall time: " + e.getMessage()));
            sMode = Mode.wall;
            return (double)System.nanoTime() / 1.0E9;
        }
    }

    public static long currentTimeMillis() {
        JProf.init();
        try {
            switch (sMode) {
                case cpu: {
                    return ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime() / 1000000L;
                }
                case user: {
                    return ManagementFactory.getThreadMXBean().getCurrentThreadUserTime() / 1000000L;
                }
            }
            return System.currentTimeMillis();
        }
        catch (UnsupportedOperationException e) {
            Logger.getLogger(JProf.class).error((Object)("Unable to measure " + sMode.name() + " time, falling back to wall time: " + e.getMessage()));
            sMode = Mode.wall;
            return System.currentTimeMillis();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        cpu,
        wall,
        user;

    }
}

