/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.util;

import java.io.File;
import java.io.PrintWriter;
import net.sf.cpsolver.ifs.util.CSVFile;

public class Csv2Html {
    public static void main(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                File file = new File(args[i]);
                String name = file.getName();
                if (name.contains(".")) {
                    name = name.substring(0, name.indexOf(46));
                }
                CSVFile csv = new CSVFile(file);
                PrintWriter pw = new PrintWriter(new File(file.getParentFile(), name + ".html"));
                pw.println("<table>");
                pw.println("\t<tr>");
                for (int j = 0; j < csv.getHeader().size(); ++j) {
                    pw.println("\t\t<th style='border-bottom: 1px #8000AD dashed;' align='" + (j == 0 ? "left" : "center") + "'>" + csv.getHeader().getField(j).toString() + "</th>");
                }
                pw.println("\t</tr>");
                boolean header = false;
                for (CSVFile.CSVLine line : csv.getLines()) {
                    if (line.getField(0).isEmpty()) {
                        pw.println("\t<tr><td colspan='" + line.size() + "'>&nbsp;</td></tr>");
                        header = true;
                        continue;
                    }
                    pw.println("\t<tr>");
                    for (int j = 0; j < line.size(); ++j) {
                        if (header) {
                            pw.println("\t\t<th style='border-bottom: 1px #8000AD dashed;' align='" + (j == 0 ? "left" : "center") + "'>" + line.getField(j).toString() + "</th>");
                            continue;
                        }
                        pw.println("\t\t<td align='" + (j == 0 ? "left" : "center") + "' nowrap>" + (line.getField(j) == null || line.getField(j).isEmpty() ? "-" : line.getField(j).toString().replace("+/-", "&plusmn;")) + "</td>");
                    }
                    pw.println("\t</tr>");
                    header = false;
                }
                pw.println("</table>");
                pw.flush();
                pw.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

