/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.termination;

import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.termination.TerminationCondition;
import net.sf.cpsolver.ifs.util.DataProperties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPPTerminationCondition<V extends Variable<V, T>, T extends Value<V, T>>
implements TerminationCondition<V, T> {
    protected static Logger sLogger = Logger.getLogger(MPPTerminationCondition.class);
    private int iMinPerturbances;
    private int iMaxIter;
    private double iTimeOut;
    private double iMinPertPenalty;
    private boolean iStopWhenComplete;

    public MPPTerminationCondition(DataProperties properties) {
        this.iMaxIter = properties.getPropertyInt("Termination.MaxIters", -1);
        this.iTimeOut = properties.getPropertyDouble("Termination.TimeOut", -1.0);
        this.iMinPerturbances = properties.getPropertyInt("Termination.MinPerturbances", -1);
        this.iStopWhenComplete = properties.getPropertyBoolean("Termination.StopWhenComplete", false);
        this.iMinPertPenalty = properties.getPropertyDouble("Termination.MinPerturbationPenalty", -1.0);
    }

    public MPPTerminationCondition(int maxIter, double timeout, int minPerturbances) {
        this.iMaxIter = maxIter;
        this.iMinPerturbances = minPerturbances;
        this.iTimeOut = timeout;
    }

    @Override
    public boolean canContinue(Solution<V, T> currentSolution) {
        if (this.iMinPerturbances >= 0 && currentSolution.getModel().nrUnassignedVariables() == 0 && currentSolution.getModel().perturbVariables().size() <= this.iMinPerturbances) {
            sLogger.info((Object)"A complete solution with allowed number of perturbances found.");
            return false;
        }
        if (this.iMinPertPenalty >= 0.0 && currentSolution.getModel().nrUnassignedVariables() == 0 && currentSolution.getPerturbationsCounter().getPerturbationPenalty(currentSolution.getModel()) <= this.iMinPertPenalty) {
            sLogger.info((Object)"A complete solution with allowed perturbation penalty found.");
            return false;
        }
        if (this.iMaxIter >= 0 && currentSolution.getIteration() >= (long)this.iMaxIter) {
            sLogger.info((Object)"Maximum number of iteration reached.");
            return false;
        }
        if (this.iTimeOut >= 0.0 && currentSolution.getTime() > this.iTimeOut) {
            sLogger.info((Object)"Timeout reached.");
            return false;
        }
        if (this.iStopWhenComplete || this.iMaxIter < 0 && this.iTimeOut < 0.0) {
            boolean ret;
            boolean bl = ret = currentSolution.getModel().nrUnassignedVariables() != 0;
            if (!ret) {
                sLogger.info((Object)"Complete solution found.");
            }
            return ret;
        }
        return true;
    }
}

