/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.solver;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.cpsolver.ifs.extension.Extension;
import net.sf.cpsolver.ifs.heuristics.NeighbourSelection;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.perturbations.PerturbationsCounter;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solution.SolutionComparator;
import net.sf.cpsolver.ifs.solver.SolverListener;
import net.sf.cpsolver.ifs.termination.TerminationCondition;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.JProf;
import net.sf.cpsolver.ifs.util.Progress;
import net.sf.cpsolver.ifs.util.ToolBox;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solver<V extends Variable<V, T>, T extends Value<V, T>> {
    public static int THREAD_PRIORITY = 3;
    protected static Logger sLogger = Logger.getLogger(Solver.class);
    protected Solution<V, T> iCurrentSolution = null;
    protected Solution<V, T> iLastSolution = null;
    protected boolean iStop = false;
    protected SolverThread iSolverThread = null;
    private DataProperties iProperties = null;
    private TerminationCondition<V, T> iTerminationCondition = null;
    private SolutionComparator<V, T> iSolutionComparator = null;
    private PerturbationsCounter<V, T> iPerturbationsCounter = null;
    private NeighbourSelection<V, T> iNeighbourSelection = null;
    private List<Extension<V, T>> iExtensions = new ArrayList<Extension<V, T>>();
    private List<SolverListener<V, T>> iSolverListeners = new ArrayList<SolverListener<V, T>>();
    private int iSaveBestUnassigned = 0;
    private boolean iUpdateProgress = true;
    private Progress iProgress;
    private boolean iValueExtraUsed = false;
    private boolean iVariableExtraUsed = false;

    public Solver(DataProperties properties) {
        this.iProperties = properties;
    }

    public void dispose() {
        this.iExtensions.clear();
        this.iSolverListeners.clear();
        this.iTerminationCondition = null;
        this.iSolutionComparator = null;
        this.iPerturbationsCounter = null;
        this.iNeighbourSelection = null;
    }

    public void setTerminalCondition(TerminationCondition<V, T> terminationCondition) {
        this.iTerminationCondition = terminationCondition;
    }

    public void setSolutionComparator(SolutionComparator<V, T> solutionComparator) {
        this.iSolutionComparator = solutionComparator;
    }

    public void setNeighbourSelection(NeighbourSelection<V, T> neighbourSelection) {
        this.iNeighbourSelection = neighbourSelection;
    }

    public void setPerturbationsCounter(PerturbationsCounter<V, T> perturbationsCounter) {
        this.iPerturbationsCounter = perturbationsCounter;
    }

    public void addExtension(Extension<V, T> extension) {
        if (extension.useValueExtra() && this.iValueExtraUsed) {
            sLogger.warn((Object)("Unable to add an extension " + extension + " -- value extra is already used."));
            return;
        }
        if (extension.useVariableExtra() && this.iVariableExtraUsed) {
            sLogger.warn((Object)("Unable to add extension " + extension + " -- variable extra is already used."));
            return;
        }
        this.iValueExtraUsed |= extension.useValueExtra();
        this.iValueExtraUsed = this.iVariableExtraUsed | extension.useVariableExtra();
        this.iExtensions.add(extension);
    }

    public TerminationCondition<V, T> getTerminationCondition() {
        return this.iTerminationCondition;
    }

    public SolutionComparator<V, T> getSolutionComparator() {
        return this.iSolutionComparator;
    }

    public NeighbourSelection<V, T> getNeighbourSelection() {
        return this.iNeighbourSelection;
    }

    public PerturbationsCounter<V, T> getPerturbationsCounter() {
        return this.iPerturbationsCounter;
    }

    public List<Extension<V, T>> getExtensions() {
        return this.iExtensions;
    }

    public void addSolverListener(SolverListener<V, T> listener) {
        this.iSolverListeners.add(listener);
    }

    public void removeSolverListener(SolverListener<V, T> listener) {
        this.iSolverListeners.remove(listener);
    }

    public List<SolverListener<V, T>> getSolverListeners() {
        return this.iSolverListeners;
    }

    public DataProperties getProperties() {
        return this.iProperties;
    }

    protected void autoConfigure() {
        try {
            boolean mpp = this.getProperties().getPropertyBoolean("General.MPP", false);
            String terminationConditionClassName = this.getProperties().getProperty("Termination.Class", mpp ? "net.sf.cpsolver.ifs.termination.MPPTerminationCondition" : "net.sf.cpsolver.ifs.termination.GeneralTerminationCondition");
            sLogger.info((Object)("Using " + terminationConditionClassName));
            Class<?> terminationConditionClass = Class.forName(terminationConditionClassName);
            Constructor<?> terminationConditionConstructor = terminationConditionClass.getConstructor(DataProperties.class);
            this.setTerminalCondition((TerminationCondition)terminationConditionConstructor.newInstance(this.getProperties()));
            String solutionComparatorClassName = this.getProperties().getProperty("Comparator.Class", mpp ? "net.sf.cpsolver.ifs.solution.MPPSolutionComparator" : "net.sf.cpsolver.ifs.solution.GeneralSolutionComparator");
            sLogger.info((Object)("Using " + solutionComparatorClassName));
            Class<?> solutionComparatorClass = Class.forName(solutionComparatorClassName);
            Constructor<?> solutionComparatorConstructor = solutionComparatorClass.getConstructor(DataProperties.class);
            this.setSolutionComparator((SolutionComparator)solutionComparatorConstructor.newInstance(this.getProperties()));
            String neighbourSelectionClassName = this.getProperties().getProperty("Neighbour.Class", "net.sf.cpsolver.ifs.heuristics.StandardNeighbourSelection");
            sLogger.info((Object)("Using " + neighbourSelectionClassName));
            Class<?> neighbourSelectionClass = Class.forName(neighbourSelectionClassName);
            Constructor<?> neighbourSelectionConstructor = neighbourSelectionClass.getConstructor(DataProperties.class);
            this.setNeighbourSelection((NeighbourSelection)neighbourSelectionConstructor.newInstance(this.getProperties()));
            String perturbationCounterClassName = this.getProperties().getProperty("PerturbationCounter.Class", "net.sf.cpsolver.ifs.perturbations.DefaultPerturbationsCounter");
            sLogger.info((Object)("Using " + perturbationCounterClassName));
            Class<?> perturbationCounterClass = Class.forName(perturbationCounterClassName);
            Constructor<?> perturbationCounterConstructor = perturbationCounterClass.getConstructor(DataProperties.class);
            this.setPerturbationsCounter((PerturbationsCounter)perturbationCounterConstructor.newInstance(this.getProperties()));
            for (Extension<V, T> extension : this.iExtensions) {
                extension.unregister(this.iCurrentSolution.getModel());
            }
            this.iExtensions.clear();
            String extensionClassNames = this.getProperties().getProperty("Extensions.Classes", null);
            if (extensionClassNames != null) {
                StringTokenizer extensionClassNameTokenizer = new StringTokenizer(extensionClassNames, ";");
                while (extensionClassNameTokenizer.hasMoreTokens()) {
                    String extensionClassName = extensionClassNameTokenizer.nextToken().trim();
                    if (extensionClassName.isEmpty()) continue;
                    sLogger.info((Object)("Using " + extensionClassName));
                    Class<?> extensionClass = Class.forName(extensionClassName);
                    Constructor<?> extensionConstructor = extensionClass.getConstructor(Solver.class, DataProperties.class);
                    this.addExtension((Extension)extensionConstructor.newInstance(this, this.getProperties()));
                }
            }
        }
        catch (Exception e) {
            sLogger.error((Object)"Unable to autoconfigure solver.", (Throwable)e);
        }
    }

    public void clearBest() {
        if (this.iCurrentSolution != null) {
            this.iCurrentSolution.clearBest();
        }
    }

    public void setInitalSolution(Solution<V, T> solution) {
        this.iCurrentSolution = solution;
        this.iLastSolution = null;
    }

    public void setInitalSolution(Model<V, T> model) {
        this.iCurrentSolution = new Solution<V, T>(model, 0L, 0.0);
        this.iLastSolution = null;
    }

    public void start() {
        this.iSolverThread = new SolverThread();
        this.iSolverThread.setPriority(THREAD_PRIORITY);
        this.iSolverThread.start();
    }

    public Thread getSolverThread() {
        return this.iSolverThread;
    }

    public void init() {
    }

    private boolean isUpdateProgress() {
        return this.iUpdateProgress;
    }

    public void setUpdateProgress(boolean updateProgress) {
        this.iUpdateProgress = updateProgress;
    }

    public Solution<V, T> lastSolution() {
        return this.iLastSolution == null ? this.iCurrentSolution : this.iLastSolution;
    }

    public Solution<V, T> currentSolution() {
        return this.iCurrentSolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSolver() {
        long seed = this.getProperties().getPropertyLong("General.Seed", System.currentTimeMillis());
        ToolBox.setSeed(seed);
        this.iSaveBestUnassigned = this.getProperties().getPropertyInt("General.SaveBestUnassigned", 0);
        this.clearBest();
        if (this.iProperties.getPropertyBoolean("Solver.AutoConfigure", true)) {
            this.autoConfigure();
        }
        for (Extension<V, T> extension : this.iExtensions) {
            extension.register(this.iCurrentSolution.getModel());
        }
        this.iCurrentSolution.init(this);
        this.getNeighbourSelection().init(this);
        if (this.getPerturbationsCounter() != null) {
            this.getPerturbationsCounter().init(this);
        }
        if (this.iProperties.getPropertyBoolean("General.SaveConfiguration", false)) {
            FileOutputStream f = null;
            try {
                f = new FileOutputStream(this.iProperties.getProperty("General.Output") + File.separator + this.iProperties.getProperty("General.ProblemName", "ifs") + ".properties");
                this.iProperties.store(f, this.iProperties.getProperty("General.ProblemNameLong", "Iterative Forward Search") + "  -- configuration file");
                f.flush();
                f.close();
                f = null;
            }
            catch (Exception e) {
                sLogger.error((Object)"Unable to store configuration file :-(", (Throwable)e);
            }
            finally {
                try {
                    if (f != null) {
                        f.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    public void stopSolver() {
        this.stopSolver(true);
    }

    public void stopSolver(boolean join) {
        if (this.getSolverThread() != null) {
            this.iStop = true;
            if (join) {
                try {
                    this.getSolverThread().join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isRunning() {
        return this.getSolverThread() != null;
    }

    protected void onStop() {
    }

    protected void onStart() {
    }

    protected void onFinish() {
    }

    protected void onFailure() {
    }

    protected void onAssigned(double startTime) {
    }

    public boolean isStop() {
        return this.iStop;
    }

    protected class SolverThread
    extends Thread {
        protected SolverThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Solver.this.iStop = false;
                this.setName("Solver");
                Solver.this.iProgress = Progress.getInstance(Solver.this.iCurrentSolution.getModel());
                Solver.this.iProgress.setStatus("Solving problem ...");
                Solver.this.iProgress.setPhase("Initializing solver");
                Solver.this.initSolver();
                Solver.this.onStart();
                double startTime = JProf.currentTimeSec();
                if (Solver.this.isUpdateProgress()) {
                    if (Solver.this.iCurrentSolution.getBestInfo() == null) {
                        Solver.this.iProgress.setPhase("Searching for initial solution ...", Solver.this.iCurrentSolution.getModel().variables().size());
                    } else {
                        Solver.this.iProgress.setPhase("Improving found solution ...");
                    }
                }
                long prog = 9999L;
                sLogger.info((Object)("Initial solution:" + ToolBox.dict2string(Solver.this.iCurrentSolution.getInfo(), 1)));
                if (!(Solver.this.iSaveBestUnassigned >= 0 && Solver.this.iSaveBestUnassigned < Solver.this.iCurrentSolution.getModel().nrUnassignedVariables() || Solver.this.iCurrentSolution.getBestInfo() != null && !Solver.this.getSolutionComparator().isBetterThanBestSolution(Solver.this.iCurrentSolution))) {
                    if (Solver.this.iCurrentSolution.getModel().nrUnassignedVariables() == 0) {
                        sLogger.info((Object)("Complete solution " + ToolBox.dict2string(Solver.this.iCurrentSolution.getInfo(), 1) + " was found."));
                    }
                    Solution solution = Solver.this.iCurrentSolution;
                    synchronized (solution) {
                        Solver.this.iCurrentSolution.saveBest();
                    }
                }
                if (Solver.this.iCurrentSolution.getModel().variables().isEmpty()) {
                    Solver.this.iProgress.error("Nothing to solve.");
                    Solver.this.iStop = true;
                }
                while (!Solver.this.iStop && Solver.this.getTerminationCondition().canContinue(Solver.this.iCurrentSolution)) {
                    Solution solution;
                    Neighbour neighbour = Solver.this.getNeighbourSelection().selectNeighbour(Solver.this.iCurrentSolution);
                    for (SolverListener listener : Solver.this.iSolverListeners) {
                        if (listener.neighbourSelected(Solver.this.iCurrentSolution.getIteration(), neighbour)) continue;
                        neighbour = null;
                    }
                    if (neighbour == null) {
                        sLogger.debug((Object)"No neighbour selected.");
                        solution = Solver.this.iCurrentSolution;
                        synchronized (solution) {
                            Solver.this.iCurrentSolution.update(JProf.currentTimeSec() - startTime);
                            continue;
                        }
                    }
                    solution = Solver.this.iCurrentSolution;
                    synchronized (solution) {
                        neighbour.assign(Solver.this.iCurrentSolution.getIteration());
                        Solver.this.iCurrentSolution.update(JProf.currentTimeSec() - startTime);
                    }
                    Solver.this.onAssigned(startTime);
                    if (!(Solver.this.iSaveBestUnassigned >= 0 && Solver.this.iSaveBestUnassigned < Solver.this.iCurrentSolution.getModel().nrUnassignedVariables() || Solver.this.iCurrentSolution.getBestInfo() != null && !Solver.this.getSolutionComparator().isBetterThanBestSolution(Solver.this.iCurrentSolution))) {
                        if (Solver.this.iCurrentSolution.getModel().nrUnassignedVariables() == 0) {
                            Solver.this.iProgress.debug("Complete solution of value " + Solver.this.iCurrentSolution.getModel().getTotalValue() + " was found.");
                        }
                        solution = Solver.this.iCurrentSolution;
                        synchronized (solution) {
                            Solver.this.iCurrentSolution.saveBest();
                        }
                    }
                    if (!Solver.this.isUpdateProgress()) continue;
                    if (Solver.this.iCurrentSolution.getBestInfo() != null && Solver.this.iCurrentSolution.getModel().getBestUnassignedVariables() == 0) {
                        if (++prog == 10000L) {
                            Solver.this.iProgress.setPhase("Improving found solution ...");
                            prog = 0L;
                            continue;
                        }
                        Solver.this.iProgress.setProgress(prog / 100L);
                        continue;
                    }
                    if (Solver.this.iCurrentSolution.getBestInfo() != null && Solver.this.iCurrentSolution.getModel().getBestUnassignedVariables() <= 0 || (long)(Solver.this.iCurrentSolution.getModel().variables().size() - Solver.this.iCurrentSolution.getModel().nrUnassignedVariables()) <= Solver.this.iProgress.getProgress()) continue;
                    Solver.this.iProgress.setProgress(Solver.this.iCurrentSolution.getModel().variables().size() - Solver.this.iCurrentSolution.getModel().nrUnassignedVariables());
                }
                Solver.this.iLastSolution = Solver.this.iCurrentSolution;
                Solver.this.iProgress.setPhase("Done", 1L);
                Solver.this.iProgress.incProgress();
                Solver.this.iSolverThread = null;
                if (Solver.this.iStop) {
                    sLogger.debug((Object)"Solver stopped.");
                    Solver.this.iProgress.setStatus("Solver stopped.");
                    Solver.this.onStop();
                } else {
                    sLogger.debug((Object)"Solver done.");
                    Solver.this.iProgress.setStatus("Solver done.");
                    Solver.this.onFinish();
                }
            }
            catch (Exception ex) {
                sLogger.error((Object)ex.getMessage(), (Throwable)ex);
                Solver.this.iProgress.fatal("Solver failed, reason:" + ex.getMessage(), ex);
                Solver.this.iProgress.setStatus("Solver failed.");
                Solver.this.onFailure();
            }
            Solver.this.iSolverThread = null;
        }
    }
}

