/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.solution;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.perturbations.PerturbationsCounter;
import net.sf.cpsolver.ifs.solution.SolutionListener;
import net.sf.cpsolver.ifs.solver.Solver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solution<V extends Variable<V, T>, T extends Value<V, T>> {
    private static DecimalFormat sTimeFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    private Model<V, T> iModel;
    private long iIteration = 0L;
    private double iTime = 0.0;
    private boolean iBestComplete = false;
    private Map<String, String> iBestInfo = null;
    private long iBestIteration = -1L;
    private double iBestTime = -1.0;
    private double iBestPerturbationsPenaly = -1.0;
    private double iBestValue = 0.0;
    private List<SolutionListener<V, T>> iSolutionListeners = new ArrayList<SolutionListener<V, T>>();
    private PerturbationsCounter<V, T> iPerturbationsCounter = null;

    public Solution(Model<V, T> model) {
        this(model, 0L, 0.0);
    }

    public Solution(Model<V, T> model, long iteration, double time) {
        this.iModel = model;
        this.iIteration = iteration;
        this.iTime = time;
    }

    public long getIteration() {
        return this.iIteration;
    }

    public Model<V, T> getModel() {
        return this.iModel;
    }

    public double getTime() {
        return this.iTime;
    }

    public void update(double time) {
        this.iTime = time;
        ++this.iIteration;
        for (SolutionListener<V, T> listener : this.iSolutionListeners) {
            listener.solutionUpdated(this);
        }
    }

    public void init(Solver<V, T> solver) {
        this.iIteration = 0L;
        this.iTime = 0.0;
        if (this.iModel != null) {
            this.iModel.init(solver);
        }
        this.iPerturbationsCounter = solver.getPerturbationsCounter();
    }

    public String toString() {
        return "Solution{\n  model=" + this.iModel + ",\n  iteration=" + this.iIteration + ",\n  time=" + this.iTime + "\n}";
    }

    public Map<String, String> getInfo() {
        Map<String, String> ret = this.getModel().getInfo();
        if (this.getPerturbationsCounter() != null) {
            this.getPerturbationsCounter().getInfo(ret, this.getModel());
        }
        ret.put("Time", sTimeFormat.format(this.getTime() / 60.0) + " min");
        ret.put("Iteration", String.valueOf(this.getIteration()));
        if (this.getTime() > 0.0) {
            ret.put("Speed", sTimeFormat.format((double)this.getIteration() / this.getTime()) + " it/s");
        }
        for (SolutionListener<V, T> listener : this.iSolutionListeners) {
            listener.getInfo(this, ret);
        }
        return ret;
    }

    public Map<String, String> getExtendedInfo() {
        Map<String, String> ret = this.getModel().getExtendedInfo();
        if (this.getPerturbationsCounter() != null) {
            this.getPerturbationsCounter().getInfo(ret, this.getModel());
        }
        ret.put("Time", sTimeFormat.format(this.getTime() / 60.0) + " min");
        ret.put("Iteration", String.valueOf(this.getIteration()));
        if (this.getTime() > 0.0) {
            ret.put("Speed", sTimeFormat.format((double)this.getIteration() / this.getTime()) + " it/s");
        }
        for (SolutionListener<V, T> listener : this.iSolutionListeners) {
            listener.getInfo(this, ret);
        }
        return ret;
    }

    public Map<String, String> getInfo(Collection<V> variables) {
        Map<String, String> ret = this.getModel().getInfo(variables);
        if (this.getPerturbationsCounter() != null) {
            this.getPerturbationsCounter().getInfo(ret, this.getModel(), variables);
        }
        ret.put("Time", sTimeFormat.format(this.getTime()) + " sec");
        ret.put("Iteration", String.valueOf(this.getIteration()));
        if (this.getTime() > 0.0) {
            ret.put("Speed", sTimeFormat.format((double)this.getIteration() / this.getTime()) + " it/s");
        }
        for (SolutionListener<V, T> listener : this.iSolutionListeners) {
            listener.getInfo(this, ret, variables);
        }
        return ret;
    }

    public Map<String, String> getBestInfo() {
        return this.iBestInfo;
    }

    public long getBestIteration() {
        return this.iBestIteration < 0L ? this.getIteration() : this.iBestIteration;
    }

    public double getBestTime() {
        return this.iBestTime < 0.0 ? this.getTime() : this.iBestTime;
    }

    public boolean isBestComplete() {
        return this.iBestComplete;
    }

    public double getBestValue() {
        return this.iBestValue;
    }

    public void setBestValue(double bestValue) {
        this.iBestValue = bestValue;
    }

    public double getBestPerturbationsPenalty() {
        return this.iBestPerturbationsPenaly;
    }

    public PerturbationsCounter<V, T> getPerturbationsCounter() {
        return this.iPerturbationsCounter;
    }

    public void clearBest() {
        this.getModel().clearBest();
        this.iBestInfo = null;
        this.iBestTime = -1.0;
        this.iBestIteration = -1L;
        this.iBestComplete = false;
        this.iBestValue = 0.0;
        this.iBestPerturbationsPenaly = -1.0;
        for (SolutionListener<V, T> listener : this.iSolutionListeners) {
            listener.bestCleared(this);
        }
    }

    public void saveBest() {
        this.getModel().saveBest();
        this.iBestInfo = this.getInfo();
        this.iBestTime = this.getTime();
        this.iBestIteration = this.getIteration();
        this.iBestComplete = this.getModel().nrUnassignedVariables() == 0;
        this.iBestValue = this.getModel().getTotalValue();
        this.iBestPerturbationsPenaly = this.iPerturbationsCounter == null ? 0.0 : this.iPerturbationsCounter.getPerturbationPenalty(this.getModel());
        for (SolutionListener<V, T> listener : this.iSolutionListeners) {
            listener.bestSaved(this);
        }
    }

    public void restoreBest() {
        if (this.iBestInfo == null) {
            return;
        }
        this.getModel().restoreBest();
        this.iTime = this.iBestTime;
        this.iIteration = this.iBestIteration;
        for (SolutionListener<V, T> listener : this.iSolutionListeners) {
            listener.bestRestored(this);
        }
    }

    public void addSolutionListener(SolutionListener<V, T> listener) {
        this.iSolutionListeners.add(listener);
    }

    public void removeSolutionListener(SolutionListener<V, T> listener) {
        this.iSolutionListeners.remove(listener);
    }
}

