/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.model.GlobalConstraint;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.VariableListener;
import net.sf.cpsolver.ifs.util.IdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Variable<V extends Variable<V, T>, T extends Value<V, T>>
implements Comparable<V> {
    private static IdGenerator iIdGenerator = new IdGenerator();
    protected long iId = -1L;
    private Model<V, T> iModel = null;
    private T iInitialValue = null;
    protected T iValue = null;
    private T iBestValue = null;
    private long iBestAssignmentIteration = 0L;
    private List<T> iValues = null;
    private T iRecentlyRemovedValue = null;
    private long iAssignmentCounter = 0L;
    private long iLastAssignmentIteration = -1L;
    private long iLastUnassignmentIteration = -1L;
    private Object iExtra = null;
    private List<Constraint<V, T>> iConstraints = new ArrayList<Constraint<V, T>>();
    private List<Constraint<V, T>> iHardConstraints = new ArrayList<Constraint<V, T>>();
    private List<Constraint<V, T>> iSoftConstraints = new ArrayList<Constraint<V, T>>();
    private List<VariableListener<T>> iVariableListeners = null;
    private Map<V, List<Constraint<V, T>>> iConstraintVariables = null;

    public Variable() {
        this(null);
    }

    public Variable(T initialValue) {
        this.iId = iIdGenerator.newId();
        this.setInitialAssignment(initialValue);
    }

    public Model<V, T> getModel() {
        return this.iModel;
    }

    public void setModel(Model<V, T> model) {
        this.iModel = model;
    }

    public List<T> values() {
        return this.iValues;
    }

    protected void setValues(List<T> values) {
        this.iValues = values;
    }

    public boolean hasValues() {
        return !this.values().isEmpty();
    }

    public T getAssignment() {
        return this.iValue;
    }

    public boolean hasAssignment() {
        return this.iValue != null;
    }

    public T getInitialAssignment() {
        return this.iInitialValue;
    }

    public void setInitialAssignment(T initialValue) {
        this.iInitialValue = initialValue;
        if (this.iInitialValue != null && ((Value)this.iInitialValue).variable() == null) {
            ((Value)this.iInitialValue).setVariable(this);
        }
        if (this.iModel != null) {
            this.iModel.invalidateVariablesWithInitialValueCache();
        }
    }

    public boolean hasInitialAssignment() {
        return this.iInitialValue != null;
    }

    public void assign(long iteration, T value) {
        if (this.getModel() != null) {
            this.getModel().beforeAssigned(iteration, value);
        }
        this.iLastAssignmentIteration = iteration;
        if (this.iValue != null) {
            this.unassign(iteration);
        }
        if (this.iRecentlyRemovedValue != null && ((Value)this.iRecentlyRemovedValue).equals(value)) {
            this.iRecentlyRemovedValue = null;
            return;
        }
        if (value == null) {
            return;
        }
        this.iValue = value;
        for (Constraint<V, T> constraint : this.iConstraints) {
            constraint.assigned(iteration, value);
        }
        if (this.getModel() != null) {
            for (GlobalConstraint globalConstraint : this.getModel().globalConstraints()) {
                globalConstraint.assigned(iteration, value);
            }
        }
        ++this.iAssignmentCounter;
        ((Value)value).assigned(iteration);
        if (this.iVariableListeners != null) {
            for (VariableListener variableListener : this.iVariableListeners) {
                variableListener.variableAssigned(iteration, value);
            }
        }
        if (this.getModel() != null) {
            this.getModel().afterAssigned(iteration, value);
        }
    }

    public void unassign(long iteration) {
        if (this.iValue == null) {
            return;
        }
        if (this.getModel() != null) {
            this.getModel().beforeUnassigned(iteration, this.iValue);
        }
        this.iLastUnassignmentIteration = iteration;
        T oldValue = this.iValue;
        this.iValue = null;
        for (Constraint<V, T> constraint : this.iConstraints) {
            constraint.unassigned(iteration, oldValue);
        }
        if (this.getModel() != null) {
            for (GlobalConstraint globalConstraint : this.getModel().globalConstraints()) {
                globalConstraint.unassigned(iteration, oldValue);
            }
        }
        ((Value)oldValue).unassigned(iteration);
        if (this.iVariableListeners != null) {
            for (VariableListener variableListener : this.iVariableListeners) {
                variableListener.variableUnassigned(iteration, oldValue);
            }
        }
        if (this.getModel() != null) {
            this.getModel().afterUnassigned(iteration, oldValue);
        }
    }

    public long countAssignments() {
        return this.iAssignmentCounter;
    }

    public void addContstraint(Constraint<V, T> constraint) {
        this.iConstraints.add(constraint);
        if (constraint.isHard()) {
            this.iHardConstraints.add(constraint);
            this.iConstraintVariables = null;
        } else {
            this.iSoftConstraints.add(constraint);
        }
    }

    public void removeContstraint(Constraint<V, T> constraint) {
        this.iConstraints.remove(constraint);
        if (this.iHardConstraints.contains(constraint)) {
            this.iHardConstraints.remove(constraint);
            this.iConstraintVariables = null;
        } else {
            this.iSoftConstraints.remove(constraint);
        }
    }

    public List<Constraint<V, T>> constraints() {
        return this.iConstraints;
    }

    public List<Constraint<V, T>> hardConstraints() {
        return this.iHardConstraints;
    }

    public List<Constraint<V, T>> softConstraints() {
        return this.iSoftConstraints;
    }

    public String toString() {
        return "Variable{name=" + this.getName() + ", initial=" + this.getInitialAssignment() + ", current=" + this.getAssignment() + ", values=" + this.values().size() + ", constraints=" + this.iConstraints.size() + "}";
    }

    public long getId() {
        return this.iId;
    }

    public int hashCode() {
        return (int)this.iId;
    }

    public String getName() {
        return String.valueOf(this.iId);
    }

    public String getDescription() {
        return null;
    }

    public void setBestAssignment(T value) {
        this.iBestValue = value;
        this.iBestAssignmentIteration = value == null ? 0L : ((Value)value).lastAssignmentIteration();
    }

    public T getBestAssignment() {
        return this.iBestValue;
    }

    public long getBestAssignmentIteration() {
        return this.iBestAssignmentIteration;
    }

    public long lastAssignmentIteration() {
        return this.iLastAssignmentIteration;
    }

    public long lastUnassignmentIteration() {
        return this.iLastUnassignmentIteration;
    }

    @Override
    public int compareTo(V variable) {
        if (variable == null) {
            return -1;
        }
        int cmp = this.getName().compareTo(((Variable)variable).getName());
        if (cmp != 0) {
            return cmp;
        }
        return Double.compare(this.getId(), ((Variable)variable).getId());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Variable)) {
            return false;
        }
        return this.getId() == ((Variable)o).getId();
    }

    public void addVariableListener(VariableListener<T> listener) {
        if (this.iVariableListeners == null) {
            this.iVariableListeners = new ArrayList<VariableListener<T>>();
        }
        this.iVariableListeners.add(listener);
    }

    public void removeVariableListener(VariableListener<T> listener) {
        if (this.iVariableListeners != null) {
            this.iVariableListeners.remove(listener);
        }
    }

    public List<VariableListener<T>> getVariableListeners() {
        return this.iVariableListeners;
    }

    public void setExtra(Object object) {
        this.iExtra = object;
    }

    public Object getExtra() {
        return this.iExtra;
    }

    public void removeValue(long iteration, T value) {
        if (this.iValue != null && ((Value)this.iValue).equals(value)) {
            this.unassign(iteration);
        }
        if (this.iValues == null) {
            return;
        }
        this.iValues.remove(value);
        if (this.iInitialValue != null && ((Value)this.iInitialValue).equals(value)) {
            this.iInitialValue = null;
            if (this.iModel != null) {
                this.iModel.invalidateVariablesWithInitialValueCache();
            }
        }
        if (this.iVariableListeners != null) {
            for (VariableListener<T> listener : this.iVariableListeners) {
                listener.valueRemoved(iteration, value);
            }
        }
        this.iRecentlyRemovedValue = value;
    }

    public Map<V, List<Constraint<V, T>>> constraintVariables() {
        if (this.iConstraintVariables == null) {
            this.iConstraintVariables = new HashMap<V, List<Constraint<V, T>>>();
            for (Constraint<V, T> constraint : this.constraints()) {
                for (Variable variable : constraint.variables()) {
                    if (variable.equals(this)) continue;
                    List<Constraint<V, T>> constraints = this.iConstraintVariables.get(variable);
                    if (constraints == null) {
                        constraints = new ArrayList<Constraint<V, T>>();
                        this.iConstraintVariables.put((List<Constraint<V, T>>)((Object)variable), (List<Constraint<List<Constraint<V, T>>, T>>)constraints);
                    }
                    constraints.add(constraint);
                }
            }
        }
        return this.iConstraintVariables;
    }

    public void removeInitialValue() {
        if (this.iInitialValue == null) {
            return;
        }
        if (this.iValues == null) {
            return;
        }
        if (this.getAssignment() != null && ((Value)this.getAssignment()).equals(this.iInitialValue)) {
            this.unassign(0L);
        }
        this.iValues.remove(this.iInitialValue);
        if (this.iModel != null) {
            this.iModel.invalidateVariablesWithInitialValueCache();
        }
        this.iInitialValue = null;
    }
}

