/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.model;

import net.sf.cpsolver.ifs.model.LazyNeighbour;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazySwap<V extends Variable<V, T>, T extends Value<V, T>>
extends LazyNeighbour<V, T> {
    private T iV1;
    private T iV2;
    private T iOldV1;
    private T iOldV2;

    public LazySwap(T v1, T v2) {
        this.iV1 = v1;
        this.iV2 = v2;
        this.iOldV1 = ((Variable)((Value)v1).variable()).getAssignment();
        this.iOldV2 = ((Variable)((Value)v2).variable()).getAssignment();
    }

    @Override
    protected void doAssign(long iteration) {
        if (this.iOldV1 != null) {
            ((Variable)((Value)this.iOldV1).variable()).unassign(iteration);
        }
        if (this.iOldV2 != null) {
            ((Variable)((Value)this.iOldV2).variable()).unassign(iteration);
        }
        ((Variable)((Value)this.iV1).variable()).assign(iteration, this.iV1);
        ((Variable)((Value)this.iV2).variable()).assign(iteration, this.iV2);
    }

    @Override
    protected void undoAssign(long iteration) {
        ((Variable)((Value)this.iV1).variable()).unassign(iteration);
        ((Variable)((Value)this.iV2).variable()).unassign(iteration);
        if (this.iOldV1 != null) {
            ((Variable)((Value)this.iOldV1).variable()).assign(iteration, this.iOldV1);
        }
        if (this.iOldV2 != null) {
            ((Variable)((Value)this.iOldV2).variable()).assign(iteration, this.iOldV2);
        }
    }

    @Override
    public Model<V, T> getModel() {
        return ((Variable)((Value)this.iV1).variable()).getModel();
    }

    public String toString() {
        return "Lazy " + this.iOldV1 + " -> " + this.iV1 + ", " + this.iOldV2 + " -> " + this.iV2;
    }
}

