/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.heuristics;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.ifs.extension.ConflictStatistics;
import net.sf.cpsolver.ifs.extension.Extension;
import net.sf.cpsolver.ifs.extension.MacPropagation;
import net.sf.cpsolver.ifs.extension.ViolatedInitials;
import net.sf.cpsolver.ifs.heuristics.ValueSelection;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralValueSelection<V extends Variable<V, T>, T extends Value<V, T>>
implements ValueSelection<V, T> {
    private double iRandomWalkProb = 0.0;
    private double iInitialSelectionProb = 0.0;
    private double iGoodSelectionProb = 0.0;
    private int iMPPLimit = -1;
    private double iWeightDeltaInitialAssignment = 0.0;
    private double iWeightPotentialConflicts = 0.0;
    private double iWeightWeightedCoflicts = 0.0;
    private double iWeightCoflicts = 1.0;
    private double iWeightNrAssignments = 0.5;
    private double iWeightValue = 0.0;
    protected int iTabuSize = 0;
    protected ArrayList<T> iTabu = null;
    protected int iTabuPos = 0;
    private boolean iMPP = false;
    private ConflictStatistics<V, T> iStat = null;
    private MacPropagation<V, T> iProp = null;
    private ViolatedInitials<V, T> iViolatedInitials = null;

    public GeneralValueSelection() {
    }

    public GeneralValueSelection(DataProperties properties) {
        this.iMPP = properties.getPropertyBoolean("General.MPP", false);
        if (this.iMPP) {
            this.iMPPLimit = properties.getPropertyInt("Value.MPPLimit", -1);
            this.iInitialSelectionProb = properties.getPropertyDouble("Value.InitialSelectionProb", 0.75);
            this.iWeightDeltaInitialAssignment = properties.getPropertyDouble("Value.WeightDeltaInitialAssignments", 0.0);
        }
        this.iGoodSelectionProb = properties.getPropertyDouble("Value.GoodSelectionProb", 0.0);
        this.iWeightWeightedCoflicts = properties.getPropertyDouble("Value.WeightWeightedConflicts", 1.0);
        this.iWeightPotentialConflicts = properties.getPropertyDouble("Value.WeightPotentialConflicts", 0.0);
        this.iRandomWalkProb = properties.getPropertyDouble("Value.RandomWalkProb", 0.0);
        this.iWeightCoflicts = properties.getPropertyDouble("Value.WeightConflicts", 1.0);
        this.iWeightNrAssignments = properties.getPropertyDouble("Value.WeightNrAssignments", 0.5);
        this.iWeightValue = properties.getPropertyDouble("Value.WeightValue", 0.0);
        this.iTabuSize = properties.getPropertyInt("Value.Tabu", 0);
        if (this.iTabuSize > 0) {
            this.iTabu = new ArrayList(this.iTabuSize);
        }
    }

    @Override
    public void init(Solver<V, T> solver) {
        for (Extension<V, T> extension : solver.getExtensions()) {
            if (ConflictStatistics.class.isInstance(extension)) {
                this.iStat = (ConflictStatistics)extension;
            }
            if (MacPropagation.class.isInstance(extension)) {
                this.iProp = (MacPropagation)extension;
            }
            if (!ViolatedInitials.class.isInstance(extension)) continue;
            this.iViolatedInitials = (ViolatedInitials)extension;
        }
    }

    @Override
    public T selectValue(Solution<V, T> solution, V selectedVariable) {
        Value selectedValue;
        Set<T> goodValues;
        if (this.iMPP && ((Variable)selectedVariable).getInitialAssignment() != null) {
            if (solution.getModel().nrUnassignedVariables() == 0 && solution.getModel().perturbVariables().size() <= this.iMPPLimit) {
                this.iMPPLimit = solution.getModel().perturbVariables().size() - 1;
            }
            if (this.iMPPLimit >= 0 && solution.getModel().perturbVariables().size() > this.iMPPLimit) {
                return ((Variable)selectedVariable).getInitialAssignment();
            }
            if (((Variable)selectedVariable).getInitialAssignment() != null && ToolBox.random() <= this.iInitialSelectionProb) {
                return ((Variable)selectedVariable).getInitialAssignment();
            }
        }
        List values = ((Variable)selectedVariable).values();
        if (ToolBox.random() <= this.iRandomWalkProb) {
            return (T)((Value)ToolBox.random(values));
        }
        if (this.iProp != null && ((Variable)selectedVariable).getAssignment() == null && ToolBox.random() <= this.iGoodSelectionProb && !(goodValues = this.iProp.goodValues(selectedVariable)).isEmpty()) {
            values = new ArrayList<T>(goodValues);
        }
        if (values.size() == 1) {
            return (T)((Value)values.get(0));
        }
        ArrayList<Value> bestValues = null;
        double bestWeightedSum = 0.0;
        for (Value value : values) {
            Set<Value> conf;
            if (this.iTabu != null && this.iTabu.contains(value) || ((Variable)selectedVariable).getAssignment() != null && ((Value)((Variable)selectedVariable).getAssignment()).equals(value) || (conf = solution.getModel().conflictValues(value)).contains(value)) continue;
            double weightedConflicts = this.iStat == null || this.iWeightWeightedCoflicts == 0.0 ? 0.0 : this.iStat.countRemovals(solution.getIteration(), (Value)((Object)conf), value);
            double potentialConflicts = this.iStat == null || this.iWeightPotentialConflicts == 0.0 ? 0.0 : (double)this.iStat.countPotentialConflicts(solution.getIteration(), value, 3);
            long deltaInitialAssignments = 0L;
            if (this.iMPP && this.iWeightDeltaInitialAssignment != 0.0) {
                Set<Value> violations;
                if (this.iViolatedInitials != null && (violations = this.iViolatedInitials.getViolatedInitials(value)) != null) {
                    for (Value aValue : violations) {
                        if (((Variable)aValue.variable()).getAssignment() != null && !((Value)((Variable)aValue.variable()).getAssignment()).equals(aValue)) continue;
                        deltaInitialAssignments += 2L;
                    }
                }
                for (Value aValue : conf) {
                    if (((Variable)aValue.variable()).getInitialAssignment() == null) continue;
                    --deltaInitialAssignments;
                }
                if (((Variable)selectedVariable).getInitialAssignment() != null && !((Value)((Variable)selectedVariable).getInitialAssignment()).equals(value)) {
                    ++deltaInitialAssignments;
                }
                if (this.iMPPLimit >= 0 && (long)solution.getModel().perturbVariables().size() + deltaInitialAssignments > (long)this.iMPPLimit) continue;
            }
            double weightedSum = this.iWeightDeltaInitialAssignment * (double)deltaInitialAssignments + this.iWeightPotentialConflicts * potentialConflicts + this.iWeightWeightedCoflicts * weightedConflicts + this.iWeightCoflicts * (double)conf.size() + this.iWeightNrAssignments * (double)value.countAssignments() + this.iWeightValue * value.toDouble();
            if (bestValues == null || bestWeightedSum > weightedSum) {
                bestWeightedSum = weightedSum;
                if (bestValues == null) {
                    bestValues = new ArrayList<Value>();
                } else {
                    bestValues.clear();
                }
                bestValues.add(value);
                continue;
            }
            if (bestWeightedSum != weightedSum) continue;
            bestValues.add(value);
        }
        Value value = selectedValue = bestValues == null ? null : (Value)ToolBox.random(bestValues);
        if (selectedValue == null) {
            selectedValue = (Value)ToolBox.random(values);
        }
        if (this.iTabu != null) {
            if (this.iTabu.size() == this.iTabuPos) {
                this.iTabu.add(selectedValue);
            } else {
                this.iTabu.set(this.iTabuPos, selectedValue);
            }
            this.iTabuPos = (this.iTabuPos + 1) % this.iTabuSize;
        }
        return (T)(bestValues == null ? null : selectedValue);
    }
}

