/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.extension;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.ifs.extension.Extension;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.Progress;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacRevised<V extends Variable<V, T>, T extends Value<V, T>>
extends Extension<V, T> {
    private static Logger sLogger = Logger.getLogger(MacRevised.class);
    private boolean iDbt = false;
    private Progress iProgress;
    protected List<Constraint<V, T>> iConstraints = null;
    protected long iIteration = 0L;

    public MacRevised(Solver<V, T> solver, DataProperties properties) {
        super(solver, properties);
        this.iDbt = properties.getPropertyBoolean("MacRevised.Dbt", false);
    }

    public void addConstraint(Constraint<V, T> constraint) {
        if (this.iConstraints == null) {
            this.iConstraints = new ArrayList<Constraint<V, T>>();
        }
        this.iConstraints.add(constraint);
    }

    public boolean contains(Constraint<V, T> constraint) {
        if (this.iConstraints == null) {
            return true;
        }
        return this.iConstraints.contains(constraint);
    }

    @Override
    public void beforeAssigned(long iteration, T value) {
        if (value == null) {
            return;
        }
        sLogger.debug((Object)("Before assign " + ((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName()));
        this.iIteration = iteration;
        while (!this.isGood(value) && !this.noGood(value).isEmpty()) {
            if (this.iDbt) {
                sLogger.warn((Object)("Going to assign a no-good value " + value + " (noGood:" + this.noGood(value) + ")."));
            }
            Value noGoodValue = (Value)this.noGood(value).iterator().next();
            ((Variable)noGoodValue.variable()).unassign(iteration);
        }
        if (!this.isGood(value)) {
            sLogger.warn((Object)("Going to assign a bad value " + value + " with empty no-good."));
        }
    }

    @Override
    public void afterAssigned(long iteration, T value) {
        sLogger.debug((Object)("After assign " + ((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName()));
        this.iIteration = iteration;
        if (!this.isGood(value)) {
            sLogger.warn((Object)(((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName() + " -- not good value assigned (noGood:" + this.noGood(value) + ")"));
            this.setGood(value);
        }
        HashSet<T> noGood = new HashSet<T>(1);
        noGood.add(value);
        ArrayList<Value> queue = new ArrayList<Value>();
        for (Value anotherValue : ((Variable)((Value)value).variable()).values()) {
            if (anotherValue.equals(value) || !this.isGood(anotherValue)) continue;
            this.setNoGood(anotherValue, noGood);
            queue.add(anotherValue);
        }
        this.propagate(queue);
    }

    @Override
    public void afterUnassigned(long iteration, T value) {
        sLogger.debug((Object)("After unassign " + ((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName()));
        this.iIteration = iteration;
        if (!this.isGood(value)) {
            sLogger.error((Object)(((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName() + " -- not good value unassigned (noGood:" + this.noGood(value) + ")"));
        }
        ArrayList<T> back = new ArrayList<T>(this.supportValues(((Value)value).variable()));
        for (Value aValue : back) {
            if (((Variable)aValue.variable()).getAssignment() != null) {
                HashSet noGood = new HashSet(1);
                noGood.add(((Variable)aValue.variable()).getAssignment());
                this.setNoGood(aValue, noGood);
                continue;
            }
            this.setGood(aValue);
        }
        ArrayList<Value> queue = new ArrayList<Value>();
        for (Value aValue : back) {
            if (this.isGood(aValue) && !this.revise(aValue)) continue;
            queue.add(aValue);
        }
        this.propagate(queue);
    }

    public void propagate(List<T> queue) {
        int idx = 0;
        while (queue.size() > idx) {
            Value value = (Value)queue.get(idx++);
            sLogger.debug((Object)("  -- propagate " + ((Variable)value.variable()).getName() + " = " + value.getName() + " (noGood:" + this.noGood(value) + ")"));
            if (this.goodValues(value.variable()).isEmpty()) {
                sLogger.info((Object)("Empty domain detected for variable " + ((Variable)value.variable()).getName()));
                continue;
            }
            for (Constraint constraint : ((Variable)value.variable()).hardConstraints()) {
                if (!this.contains(constraint)) continue;
                this.propagate(constraint, value, queue);
            }
        }
    }

    public void propagate(Constraint<V, T> constraint, T noGoodValue, List<T> queue) {
        for (Variable aVariable : constraint.variables()) {
            if (aVariable.equals(((Value)noGoodValue).variable())) continue;
            for (Value aValue : aVariable.values()) {
                if (!this.isGood(aValue) || !constraint.isConsistent((Value)noGoodValue, aValue) || this.hasSupport(constraint, aValue, ((Value)noGoodValue).variable())) continue;
                this.setNoGood(aValue, this.explanation(constraint, aValue, ((Value)noGoodValue).variable()));
                queue.add(aValue);
            }
        }
    }

    public boolean revise(T value) {
        sLogger.debug((Object)("  -- revise " + ((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName()));
        for (Constraint constraint : ((Variable)((Value)value).variable()).hardConstraints()) {
            if (!this.contains(constraint) || !this.revise(constraint, value)) continue;
            return true;
        }
        return false;
    }

    public boolean revise(Constraint<V, T> constraint, T value) {
        for (Variable aVariable : constraint.variables()) {
            if (aVariable.equals(((Value)value).variable()) || this.hasSupport(constraint, value, aVariable)) continue;
            this.setNoGood(value, this.explanation(constraint, value, aVariable));
            return true;
        }
        return false;
    }

    public Set<T> explanation(Constraint<V, T> constraint, T value, V variable) {
        HashSet<Value> expl = new HashSet<Value>();
        for (Value aValue : ((Variable)variable).values()) {
            if (!constraint.isConsistent(aValue, (Value)value)) continue;
            expl.addAll(this.noGood(aValue));
        }
        return expl;
    }

    public Set<T> supports(Constraint<V, T> constraint, T value, V variable) {
        HashSet<Value> sup = new HashSet<Value>();
        for (Value aValue : ((Variable)variable).values()) {
            if (!this.isGood(aValue) || !constraint.isConsistent(aValue, (Value)value)) continue;
            sup.add(aValue);
        }
        return sup;
    }

    public boolean hasSupport(Constraint<V, T> constraint, T value, V variable) {
        for (Value aValue : ((Variable)variable).values()) {
            if (!this.isGood(aValue) || !constraint.isConsistent(aValue, (Value)value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean init(Solver<V, T> solver) {
        boolean isOk = true;
        this.iProgress = Progress.getInstance(this.getModel());
        this.iProgress.save();
        this.iProgress.setPhase("Initializing propagation:", this.getModel().variables().size());
        for (Variable aVariable : this.getModel().variables()) {
            this.supportValues(aVariable).clear();
            this.goodValues(aVariable).clear();
        }
        ArrayList<Value> queue = new ArrayList<Value>();
        for (Variable aVariable : this.getModel().variables()) {
            for (Value aValue : aVariable.values()) {
                this.initNoGood(aValue, null);
                this.goodValues(aVariable).add(aValue);
                if (this.revise(aValue)) {
                    queue.add(aValue);
                    continue;
                }
                if (aVariable.getAssignment() == null || aValue.equals(aVariable.getAssignment())) continue;
                HashSet noGood = new HashSet();
                noGood.add(aVariable.getAssignment());
                this.setNoGood(aValue, noGood);
                queue.add(aValue);
            }
            this.iProgress.incProgress();
        }
        this.propagate(queue);
        this.iProgress.restore();
        return isOk;
    }

    private Set<T> supportValues(V variable) {
        Set[] ret = (Set[])((Variable)variable).getExtra();
        if (ret == null) {
            ret = new Set[]{new HashSet(1000), new HashSet()};
            ((Variable)variable).setExtra(ret);
        }
        return ret[0];
    }

    public Set<T> goodValues(V variable) {
        Set[] ret = (Set[])((Variable)variable).getExtra();
        if (ret == null) {
            ret = new Set[]{new HashSet(1000), new HashSet()};
            ((Variable)variable).setExtra(ret);
        }
        return ret[1];
    }

    private void goodnessChanged(T value) {
        if (this.isGood(value)) {
            this.goodValues(((Value)value).variable()).add(value);
        } else {
            this.goodValues(((Value)value).variable()).remove(value);
        }
    }

    private void removeSupport(V variable, T value) {
        this.supportValues(variable).remove(value);
    }

    private void addSupport(V variable, T value) {
        this.supportValues(variable).add(value);
    }

    public Set<T> noGood(T value) {
        return (Set)((Value)value).getExtra();
    }

    public boolean isGood(T value) {
        return ((Value)value).getExtra() == null;
    }

    protected void setGood(T value) {
        sLogger.debug((Object)("    -- set good " + ((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName()));
        Set<T> noGood = this.noGood(value);
        if (noGood != null) {
            for (Value v : noGood) {
                this.removeSupport(v.variable(), value);
            }
        }
        ((Value)value).setExtra(null);
        this.goodnessChanged(value);
    }

    private void initNoGood(T value, Set<T> reason) {
        ((Value)value).setExtra(reason);
    }

    private String expl2str(Set<T> expl) {
        StringBuffer sb = new StringBuffer("[");
        Iterator<T> i = expl.iterator();
        while (i.hasNext()) {
            Value value = (Value)i.next();
            sb.append(((Variable)value.variable()).getName() + "=" + value.getName());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private void checkExpl(Set<T> expl) {
        sLogger.debug((Object)("    -- checking explanation: " + this.expl2str(expl)));
        for (Value value : expl) {
            if (value.equals(((Variable)value.variable()).getAssignment())) continue;
            if (((Variable)value.variable()).getAssignment() == null) {
                sLogger.warn((Object)("      -- variable " + ((Variable)value.variable()).getName() + " unassigned"));
                continue;
            }
            sLogger.warn((Object)("      -- variable " + ((Variable)value.variable()).getName() + " assigned to a different value " + ((Value)((Variable)value.variable()).getAssignment()).getName()));
        }
    }

    private void printAssignments() {
        sLogger.debug((Object)"    -- printing assignments: ");
        for (Variable variable : this.getModel().variables()) {
            if (variable.getAssignment() == null) continue;
            sLogger.debug((Object)("      -- " + variable.getName() + " = " + ((Value)variable.getAssignment()).getName()));
        }
    }

    public void setNoGood(T value, Set<T> reason) {
        Set<T> noGood;
        sLogger.debug((Object)("    -- set nogood " + ((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName() + "(expl:" + this.expl2str(reason) + ")"));
        if (((Value)value).equals(((Variable)((Value)value).variable()).getAssignment())) {
            try {
                throw new Exception("An assigned value " + ((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName() + " become no good (noGood:" + reason + ")!!");
            }
            catch (Exception e) {
                sLogger.warn((Object)e.getMessage(), (Throwable)e);
                this.checkExpl(reason);
                this.printAssignments();
            }
        }
        if ((noGood = this.noGood(value)) != null) {
            for (Value v : noGood) {
                this.removeSupport(v.variable(), value);
            }
        }
        ((Value)value).setExtra(reason);
        for (Value aValue : reason) {
            this.addSupport(aValue.variable(), value);
        }
        this.goodnessChanged(value);
    }
}

