/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import net.sf.cpsolver.ifs.extension.Extension;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.Progress;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacPropagation<V extends Variable<V, T>, T extends Value<V, T>>
extends Extension<V, T> {
    private static Logger sLogger = Logger.getLogger(MacPropagation.class);
    private boolean iJustForwardCheck = false;
    private Progress iProgress;
    protected List<Constraint<V, T>> iConstraints = null;
    protected long iIteration = 0L;

    public MacPropagation(Solver<V, T> solver, DataProperties properties) {
        super(solver, properties);
        this.iJustForwardCheck = properties.getPropertyBoolean("MacPropagation.JustForwardCheck", false);
    }

    public void addConstraint(Constraint<V, T> constraint) {
        if (this.iConstraints == null) {
            this.iConstraints = new ArrayList<Constraint<V, T>>();
        }
        this.iConstraints.add(constraint);
    }

    public boolean contains(Constraint<V, T> constraint) {
        if (this.iConstraints == null) {
            return true;
        }
        return this.iConstraints.contains(constraint);
    }

    @Override
    public void beforeAssigned(long iteration, T value) {
        this.iIteration = iteration;
        if (value == null) {
            return;
        }
        if (!this.isGood(value)) {
            while (!this.isGood(value) && !this.noGood(value).isEmpty()) {
                Value noGoodValue = (Value)this.noGood(value).iterator().next();
                ((Variable)noGoodValue.variable()).unassign(iteration);
            }
        }
        if (!this.isGood(value)) {
            sLogger.warn((Object)("Going to assign a bad value " + value + " with empty no-good."));
        }
    }

    @Override
    public void afterAssigned(long iteration, T value) {
        this.iIteration = iteration;
        if (!this.isGood(value)) {
            sLogger.warn((Object)(((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName() + " -- not good value assigned (noGood:" + this.noGood(value) + ")"));
            this.setGood(value);
        }
        HashSet<T> noGood = new HashSet<T>(1);
        noGood.add(value);
        for (Value anotherValue : ((Variable)((Value)value).variable()).values()) {
            if (anotherValue.equals(value)) continue;
            this.setNoGood(anotherValue, noGood);
        }
        this.propagate(((Value)value).variable());
    }

    @Override
    public void afterUnassigned(long iteration, T value) {
        this.iIteration = iteration;
        if (!this.isGood(value)) {
            sLogger.error((Object)(((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName() + " -- not good value unassigned (noGood:" + this.noGood(value) + ")"));
        }
        for (Value anotherValue : ((Variable)((Value)value).variable()).values()) {
            if (this.isGood(anotherValue)) continue;
            Set noGood = anotherValue.conflicts();
            if (noGood == null) {
                this.setGood(anotherValue);
                continue;
            }
            this.setNoGood(anotherValue, noGood);
        }
        this.undoPropagate(((Value)value).variable());
    }

    @Override
    public boolean init(Solver<V, T> solver) {
        boolean isOk = true;
        this.iProgress = Progress.getInstance(this.getModel());
        this.iProgress.save();
        this.iProgress.setPhase("Initializing propagation:", 3 * this.getModel().variables().size());
        for (Variable aVariable : this.getModel().variables()) {
            this.supportValues(aVariable).clear();
            this.goodValues(aVariable).clear();
        }
        for (Variable aVariable : this.getModel().variables()) {
            for (Object aValue : aVariable.values()) {
                Set set = ((Value)aValue).conflicts();
                this.initNoGood(aValue, set);
                if (set != null) continue;
                this.goodValues(aVariable).add(aValue);
            }
            this.iProgress.incProgress();
        }
        LinkedList queue = new LinkedList();
        for (Variable aVariable : this.getModel().variables()) {
            for (Constraint constraint : aVariable.hardConstraints()) {
                this.propagate((Constraint<V, T>)constraint, (V)aVariable, (Queue<V>)queue);
            }
            this.iProgress.incProgress();
        }
        if (!this.iJustForwardCheck) {
            this.propagate(queue);
        }
        for (Variable aVariable : this.getModel().variables()) {
            ArrayList<Value> values2delete = new ArrayList<Value>();
            for (Value aValue : aVariable.values()) {
                if (this.isGood(aValue) || !this.noGood(aValue).isEmpty()) continue;
                values2delete.add(aValue);
            }
            for (Value val : values2delete) {
                aVariable.removeValue(0L, val);
            }
            if (aVariable.values().isEmpty()) {
                sLogger.error((Object)(aVariable.getName() + " has empty domain!"));
                isOk = false;
            }
            this.iProgress.incProgress();
        }
        this.iProgress.restore();
        return isOk;
    }

    protected void propagate(V variable) {
        LinkedList queue = new LinkedList();
        if (((Variable)variable).getAssignment() != null) {
            for (Constraint constraint : ((Variable)variable).hardConstraints()) {
                if (!this.contains(constraint)) continue;
                this.propagate((Constraint<V, T>)constraint, (V)((Variable)variable).getAssignment(), (Queue<V>)queue);
            }
        } else {
            for (Constraint constraint : ((Variable)variable).hardConstraints()) {
                if (!this.contains(constraint)) continue;
                this.propagate((Constraint<V, T>)constraint, variable, (Queue<V>)queue);
            }
        }
        if (!this.iJustForwardCheck && !queue.isEmpty()) {
            this.propagate(queue);
        }
    }

    protected void propagate(Queue<V> queue) {
        while (!queue.isEmpty()) {
            Variable aVariable = (Variable)queue.poll();
            for (Constraint constraint : aVariable.hardConstraints()) {
                if (!this.contains(constraint)) continue;
                this.propagate((Constraint<V, T>)constraint, (V)aVariable, queue);
            }
        }
    }

    public void undoPropagate(V variable) {
        HashMap undoVars = new HashMap();
        while (!this.supportValues(variable).isEmpty()) {
            Value value = (Value)this.supportValues(variable).iterator().next();
            Set noGood = value.conflicts();
            if (noGood == null) {
                this.setGood(value);
                ArrayList<Value> values = (ArrayList<Value>)undoVars.get(value.variable());
                if (values == null) {
                    values = new ArrayList<Value>();
                    undoVars.put(value.variable(), values);
                }
                values.add(value);
                continue;
            }
            this.setNoGood(value, noGood);
            if (!noGood.isEmpty()) continue;
            ((Variable)value.variable()).removeValue(this.iIteration, (Value)value);
        }
        LinkedList queue = new LinkedList();
        for (Variable aVariable : undoVars.keySet()) {
            List values = (List)undoVars.get(aVariable);
            boolean add = false;
            for (Variable x : aVariable.constraintVariables().keySet()) {
                if (!this.propagate(x, aVariable, values)) continue;
                add = true;
            }
            if (!add) continue;
            queue.add(aVariable);
        }
        for (Variable x : ((Variable)variable).constraintVariables().keySet()) {
            if (!this.propagate(x, variable) || queue.contains(variable)) continue;
            queue.add(variable);
        }
        if (!this.iJustForwardCheck) {
            this.propagate(queue);
        }
    }

    protected boolean propagate(V aVariable, V anotherVariable, List<T> adepts) {
        if (this.goodValues(aVariable).isEmpty()) {
            return false;
        }
        boolean ret = false;
        List<Value> conflicts = null;
        for (Constraint constraint : ((Variable)anotherVariable).constraintVariables().get(aVariable)) {
            for (Value aValue : this.goodValues(aVariable)) {
                if ((conflicts = conflicts == null ? this.conflictValues(constraint, aValue, adepts) : this.conflictValues(constraint, aValue, conflicts)) != null && !conflicts.isEmpty()) continue;
                break;
            }
            if (conflicts == null || conflicts.isEmpty()) continue;
            for (Value conflictValue : conflicts) {
                Set<Value> reason = this.reason(constraint, aVariable, conflictValue);
                this.setNoGood(conflictValue, reason);
                adepts.remove(conflictValue);
                if (reason.isEmpty()) {
                    ((Variable)conflictValue.variable()).removeValue(this.iIteration, (Value)conflictValue);
                }
                ret = true;
            }
        }
        return ret;
    }

    protected boolean propagate(V aVariable, V anotherVariable) {
        if (this.goodValues(anotherVariable).isEmpty()) {
            return false;
        }
        return this.propagate(aVariable, anotherVariable, new ArrayList<T>(this.goodValues(anotherVariable)));
    }

    private Set<T> supportValues(V variable) {
        Set[] ret = (Set[])((Variable)variable).getExtra();
        if (ret == null) {
            ret = new Set[]{new HashSet(1000), new HashSet()};
            ((Variable)variable).setExtra(ret);
        }
        return ret[0];
    }

    public Set<T> goodValues(V variable) {
        Set[] ret = (Set[])((Variable)variable).getExtra();
        if (ret == null) {
            ret = new Set[]{new HashSet(1000), new HashSet()};
            ((Variable)variable).setExtra(ret);
        }
        return ret[1];
    }

    private void goodnessChanged(T value) {
        if (this.isGood(value)) {
            this.goodValues(((Value)value).variable()).add(value);
        } else {
            this.goodValues(((Value)value).variable()).remove(value);
        }
    }

    private void removeSupport(V variable, T value) {
        this.supportValues(variable).remove(value);
    }

    private void addSupport(V variable, T value) {
        this.supportValues(variable).add(value);
    }

    public Set<T> noGood(T value) {
        return (Set)((Value)value).getExtra();
    }

    public boolean isGood(T value) {
        return ((Value)value).getExtra() == null;
    }

    protected void setGood(T value) {
        Set<T> noGood = this.noGood(value);
        if (noGood != null) {
            for (Value v : noGood) {
                this.removeSupport(v.variable(), value);
            }
        }
        ((Value)value).setExtra(null);
        this.goodnessChanged(value);
    }

    private void initNoGood(T value, Set<T> reason) {
        ((Value)value).setExtra(reason);
    }

    public void setNoGood(T value, Set<T> reason) {
        Set<T> noGood = this.noGood(value);
        if (noGood != null) {
            for (Value v : noGood) {
                this.removeSupport(v.variable(), value);
            }
        }
        ((Value)value).setExtra(reason);
        for (Value aValue : reason) {
            this.addSupport(aValue.variable(), value);
        }
        this.goodnessChanged(value);
    }

    private void propagate(Constraint<V, T> constraint, T anAssignedValue, Queue<V> queue) {
        HashSet<T> reason = new HashSet<T>(1);
        reason.add(anAssignedValue);
        List<T> conflicts = this.conflictValues(constraint, (V)anAssignedValue);
        if (conflicts != null && !conflicts.isEmpty()) {
            for (Value conflictValue : conflicts) {
                this.setNoGood(conflictValue, reason);
                if (queue.contains(conflictValue.variable())) continue;
                queue.add(conflictValue.variable());
            }
        }
    }

    private void propagate(Constraint<V, T> constraint, V aVariable, Queue<V> queue) {
        if (this.goodValues(aVariable).isEmpty()) {
            return;
        }
        List<T> conflicts = this.conflictValues(constraint, aVariable);
        if (conflicts != null && !conflicts.isEmpty()) {
            for (Value conflictValue : conflicts) {
                if (!queue.contains(conflictValue.variable())) {
                    queue.add(conflictValue.variable());
                }
                Set<Value> reason = this.reason(constraint, aVariable, conflictValue);
                this.setNoGood(conflictValue, reason);
                if (!reason.isEmpty()) continue;
                ((Variable)conflictValue.variable()).removeValue(this.iIteration, (Value)conflictValue);
            }
        }
    }

    private List<T> conflictValues(Constraint<V, T> constraint, T aValue) {
        ArrayList<Value> ret = new ArrayList<Value>();
        for (Variable variable : constraint.variables()) {
            if (variable.equals(((Value)aValue).variable()) || variable.getAssignment() != null) continue;
            for (Value value : this.goodValues(variable)) {
                if (constraint.isConsistent((Value)aValue, value)) continue;
                ret.add(value);
            }
        }
        return ret;
    }

    private List<T> conflictValues(Constraint<V, T> constraint, T aValue, List<T> values) {
        ArrayList<Value> ret = new ArrayList<Value>(values.size());
        for (Value value : values) {
            if (constraint.isConsistent((Value)aValue, value)) continue;
            ret.add(value);
        }
        return ret;
    }

    private List<T> conflictValues(Constraint<V, T> constraint, V aVariable) {
        List<Object> conflicts = null;
        for (Value aValue : this.goodValues(aVariable)) {
            if ((conflicts = conflicts == null ? this.conflictValues(constraint, (V)aValue) : this.conflictValues(constraint, aValue, conflicts)) != null && !conflicts.isEmpty()) continue;
            return null;
        }
        return conflicts;
    }

    private Set<T> reason(Constraint<V, T> constraint, V aVariable, T aValue) {
        HashSet<Value> ret = new HashSet<Value>();
        for (Value value : ((Variable)aVariable).values()) {
            if (!constraint.isConsistent((Value)aValue, value)) continue;
            if (this.noGood(value) == null) {
                sLogger.error((Object)("Something went wrong: value " + value + " cannot participate in a reason."));
                continue;
            }
            ret.addAll(this.noGood(value));
        }
        return ret;
    }
}

