/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.cpsolver.ifs.extension.Assignment;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignmentSet<T extends Value<?, T>> {
    private List<Assignment<T>> iSet = new ArrayList<Assignment<T>>();
    private int iCounter = 1;
    private String iName = null;
    private String iDescription = null;
    private Constraint<?, T> iConstraint = null;

    public AssignmentSet() {
    }

    public AssignmentSet(Assignment<T>[] assignments) {
        for (Assignment<T> a : assignments) {
            this.iSet.add(a);
        }
    }

    public AssignmentSet(Collection<Assignment<T>> assignments) {
        for (Assignment<T> a : assignments) {
            this.iSet.add(a);
        }
    }

    public static <T extends Value<?, T>> AssignmentSet<T> createAssignmentSet(Collection<Assignment<T>> assignments) {
        AssignmentSet<T> set = new AssignmentSet<T>();
        for (Assignment<T> a : assignments) {
            set.addAssignment(a);
        }
        return set;
    }

    public static <T extends Value<?, T>> AssignmentSet<T> createAssignmentSetForValues(Collection<T> assignments) {
        AssignmentSet<Value> set = new AssignmentSet<Value>();
        for (Value a : assignments) {
            set.addAssignment(0L, a, 1.0);
        }
        return set;
    }

    public static <T extends Value<?, T>> AssignmentSet<T> createAssignmentSetForVariables(Collection<Variable<?, T>> assignments) {
        AssignmentSet<T> set = new AssignmentSet<T>();
        for (Variable<?, T> a : assignments) {
            if (a.getAssignment() == null) continue;
            set.addAssignment(0L, a.getAssignment(), 1.0);
        }
        return set;
    }

    public void incCounter() {
        ++this.iCounter;
    }

    public int getCounter() {
        return this.iCounter;
    }

    public List<Assignment<T>> getSet() {
        return this.iSet;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String description) {
        this.iDescription = description;
    }

    public Constraint<?, T> getConstraint() {
        return this.iConstraint;
    }

    public void setConstraint(Constraint<?, T> constraint) {
        this.iConstraint = constraint;
    }

    public boolean contains(Assignment<T> assignment) {
        return this.iSet.contains(assignment);
    }

    public boolean contains(AssignmentSet<T> assignmentSet) {
        return this.iSet.containsAll(assignmentSet.getSet());
    }

    public boolean contains(T value) {
        return this.iSet.contains(new Assignment<T>(0L, value, 1.0));
    }

    public boolean contains(Variable<?, T> variable) {
        return variable.getAssignment() == null ? false : this.iSet.contains(new Assignment<T>(0L, variable.getAssignment(), 1.0));
    }

    public boolean contains(Collection<Assignment<T>> assignments) {
        for (Assignment<T> a : assignments) {
            if (this.iSet.contains(a)) continue;
            return false;
        }
        return true;
    }

    public boolean containsValues(Collection<T> assignments) {
        for (Value a : assignments) {
            if (this.iSet.contains(new Assignment<Value>(0L, a, 1.0))) continue;
            return false;
        }
        return true;
    }

    public boolean containsVariables(Collection<Variable<?, T>> assignments) {
        for (Variable<?, T> a : assignments) {
            if (a.getAssignment() != null && this.iSet.contains(new Assignment<T>(0L, a.getAssignment(), 1.0))) continue;
            return false;
        }
        return true;
    }

    public void addAssignment(Assignment<T> assignment) {
        if (!this.contains((T)assignment)) {
            this.iSet.add(assignment);
        }
    }

    public void addAssignment(long iteration, T value, double ageing) {
        this.addAssignment(new Assignment<T>(iteration, value, ageing));
    }

    public Assignment<T> getAssignment(T value) {
        for (Assignment<T> a : this.iSet) {
            if (((Value)a.getValue()).getId() != ((Value)value).getId()) continue;
            return a;
        }
        return null;
    }

    public int size() {
        return this.getSet().size();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof AssignmentSet) {
            AssignmentSet as = (AssignmentSet)o;
            if (this.getName() == null && as.getName() != null) {
                return false;
            }
            if (this.getName() != null && as.getName() == null) {
                return false;
            }
            if (this.getName() != null && !this.getName().equals(as.getName())) {
                return false;
            }
            if (as.getSet().size() != this.getSet().size()) {
                return false;
            }
            return this.contains((T)as);
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            if (c.size() != this.getSet().size()) {
                return false;
            }
            return this.contains(c);
        }
        return false;
    }

    public static int xor(int a, int b) {
        return (a | b) & (~a | ~b);
    }

    public int hashCode() {
        int ret = this.getSet().size();
        for (Assignment<T> a : this.iSet) {
            ret = AssignmentSet.xor(ret, a.hashCode());
        }
        return ret;
    }
}

