/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.example.rpp;

import java.util.Set;
import net.sf.cpsolver.ifs.example.rpp.Location;
import net.sf.cpsolver.ifs.example.rpp.Rectangle;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.util.ToolBox;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceConstraint
extends Constraint<Rectangle, Location> {
    private static Logger sLogger = Logger.getLogger(ResourceConstraint.class);
    private Rectangle[][] iResource;
    private int iWidth;
    private int iHeight;

    public ResourceConstraint(int width, int height) {
        this.iWidth = width;
        this.iHeight = height;
        this.iResource = new Rectangle[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                this.iResource[x][y] = null;
            }
        }
    }

    @Override
    public void computeConflicts(Location placement, Set<Location> conflicts) {
        Rectangle rectangle = (Rectangle)placement.variable();
        for (int x = placement.getX(); x < Math.min(this.iWidth, placement.getX() + rectangle.getWidth()); ++x) {
            for (int y = placement.getY(); y < Math.min(this.iHeight, placement.getY() + rectangle.getHeight()); ++y) {
                if (this.iResource[x][y] == null) continue;
                conflicts.add((Location)this.iResource[x][y].getAssignment());
            }
        }
    }

    @Override
    public boolean inConflict(Location placement) {
        Rectangle rectangle = (Rectangle)placement.variable();
        for (int x = placement.getX(); x < Math.min(this.iWidth, placement.getX() + rectangle.getWidth()); ++x) {
            for (int y = placement.getY(); y < Math.min(this.iHeight, placement.getY() + rectangle.getHeight()); ++y) {
                if (this.iResource[x][y] == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isConsistent(Location p1, Location p2) {
        Rectangle r1 = (Rectangle)p1.variable();
        Rectangle r2 = (Rectangle)p2.variable();
        if (p2.getX() + r2.getWidth() <= p1.getX()) {
            return true;
        }
        if (p2.getX() >= p1.getX() + r1.getWidth()) {
            return true;
        }
        if (p2.getY() + r2.getHeight() <= p1.getY()) {
            return true;
        }
        return p2.getY() >= p1.getY() + r1.getHeight();
    }

    @Override
    public void assigned(long iteration, Location placement) {
        super.assigned(iteration, placement);
        Rectangle rectangle = (Rectangle)placement.variable();
        for (int x = placement.getX(); x < Math.min(this.iWidth, placement.getX() + rectangle.getWidth()); ++x) {
            for (int y = placement.getY(); y < Math.min(this.iHeight, placement.getY() + rectangle.getHeight()); ++y) {
                this.iResource[x][y] = rectangle;
            }
        }
    }

    @Override
    public void unassigned(long iteration, Location placement) {
        super.unassigned(iteration, placement);
        Rectangle rectangle = (Rectangle)placement.variable();
        for (int x = placement.getX(); x < Math.min(this.iWidth, placement.getX() + rectangle.getWidth()); ++x) {
            for (int y = placement.getY(); y < Math.min(this.iHeight, placement.getY() + rectangle.getHeight()); ++y) {
                this.iResource[x][y] = null;
            }
        }
    }

    public void check() {
        sLogger.debug((Object)"check");
        for (Rectangle rectangle : this.variables()) {
            Location placement = (Location)rectangle.getAssignment();
            if (placement == null) {
                sLogger.warn((Object)("Rectangle " + rectangle.getName() + " is not assigned."));
                continue;
            }
            sLogger.debug((Object)("Checking " + rectangle.getName() + "    (assigned:" + placement.getName() + ", prohibited:" + rectangle.isProhibited(placement.getX(), placement.getY()) + ", initial:" + rectangle.getInitialAssignment() + ", prohibited:[" + rectangle.getProhibitedX() + "," + rectangle.getProhibitedY() + "])"));
            if (placement.getX() == rectangle.getProhibitedX() || placement.getY() == rectangle.getProhibitedY()) {
                sLogger.error((Object)"Placement is prohibited.");
            }
            if (placement.getX() < rectangle.getMinX() || placement.getX() > rectangle.getMaxX() || placement.getY() < rectangle.getMinY() || placement.getY() > rectangle.getMaxY()) {
                sLogger.error((Object)"Placement is outside bounds.");
            }
            for (int x = placement.getX(); x < Math.min(this.iWidth, placement.getX() + rectangle.getWidth()); ++x) {
                for (int y = placement.getY(); y < Math.min(this.iHeight, placement.getY() + rectangle.getHeight()); ++y) {
                    if (this.iResource[x][y] != null && this.iResource[x][y].equals(rectangle)) continue;
                    sLogger.error((Object)("Problem at [" + x + "," + y + "], " + this.iResource[x][y] + " is assigned there."));
                }
            }
        }
        sLogger.debug((Object)this.toString());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ResourceConstraint{\n        ");
        for (int y = 0; y < this.iHeight; ++y) {
            for (int x = 0; x < this.iWidth; ++x) {
                sb.append(ToolBox.trim(this.iResource[x][y] == null ? "" : this.iResource[x][y].getName().substring(4), 4));
            }
            sb.append("\n        ");
        }
        sb.append("\n      }");
        return sb.toString();
    }
}

