/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.example.jobshop;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import net.sf.cpsolver.ifs.example.jobshop.JobShopModel;
import net.sf.cpsolver.ifs.example.jobshop.Location;
import net.sf.cpsolver.ifs.example.jobshop.Operation;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.Progress;
import net.sf.cpsolver.ifs.util.ProgressWriter;
import net.sf.cpsolver.ifs.util.ToolBox;
import org.apache.log4j.Logger;

public class Test {
    private static SimpleDateFormat sDateFormat = new SimpleDateFormat("dd-MMM-yy_HHmmss", Locale.US);
    private static Logger sLogger = Logger.getLogger(Test.class);

    public static void test(DataProperties properties) {
        try {
            String inputFile = properties.getProperty("General.Input");
            JobShopModel model = JobShopModel.loadModel(inputFile);
            Solver<Operation, Location> s = new Solver<Operation, Location>(properties);
            s.setInitalSolution(model);
            s.start();
            s.getSolverThread().join();
            Solution best = s.currentSolution();
            best.restoreBest();
            sLogger.info((Object)("Best solution info:" + best.getInfo()));
            sLogger.info((Object)("Best solution:" + model.toString()));
            model.save(properties.getProperty("General.Output") + File.separator + "solution.txt");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            Progress.getInstance().addProgressListener(new ProgressWriter(System.out));
            File inputCfg = new File(args[0]);
            DataProperties properties = ToolBox.loadProperties(inputCfg);
            String outDir = properties.getProperty("General.Output", ".") + File.separator + inputCfg.getName().substring(0, inputCfg.getName().lastIndexOf(46)) + File.separator + sDateFormat.format(new Date());
            new File(outDir).mkdirs();
            properties.setProperty("General.Output", outDir.toString());
            ToolBox.configureLogging(outDir, null);
            Test.test(properties);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

